/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.digests;

import org.bouncycastle.crypto.digests.SHAKEDigest;
import org.bouncycastle.util.Arrays;

public class CSHAKEDigest
extends SHAKEDigest {
    private static final byte[] padding = new byte[100];
    private final byte[] diff;

    public CSHAKEDigest(int n, byte[] byArray, byte[] byArray2) {
        super(n);
        if (!(byArray != null && byArray.length != 0 || byArray2 != null && byArray2.length != 0)) {
            this.diff = null;
        } else {
            this.diff = Arrays.concatenate(CSHAKEDigest.leftEncode(this.rate / 8), this.encodeString(byArray), this.encodeString(byArray2));
            this.diffPadAndAbsorb();
        }
    }

    private void diffPadAndAbsorb() {
        int n;
        int n2 = this.rate / 8;
        this.absorb(this.diff, 0, this.diff.length);
        for (n = n2 - this.diff.length % n2; n > padding.length; n -= padding.length) {
            this.absorb(padding, 0, padding.length);
        }
        this.absorb(padding, 0, n);
    }

    private byte[] encodeString(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return CSHAKEDigest.leftEncode(0L);
        }
        return Arrays.concatenate(CSHAKEDigest.leftEncode((long)byArray.length * 8L), byArray);
    }

    private static byte[] leftEncode(long l) {
        int n = 1;
        long l2 = l;
        while ((l2 >>= 8) != 0L) {
            n = (byte)(n + 1);
        }
        byte[] byArray = new byte[n + 1];
        byArray[0] = n;
        for (int i = 1; i <= n; ++i) {
            byArray[i] = (byte)(l >> 8 * (n - i));
        }
        return byArray;
    }

    public int doOutput(byte[] byArray, int n, int n2) {
        if (this.diff != null) {
            if (!this.squeezing) {
                this.absorbBits(0, 2);
            }
            this.squeeze(byArray, n, (long)n2 * 8L);
            return n2;
        }
        return super.doOutput(byArray, n, n2);
    }

    public void reset() {
        super.reset();
        if (this.diff != null) {
            this.diffPadAndAbsorb();
        }
    }
}

