/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.frame.ui.annotation.impl;

import java.lang.reflect.Method;
import org.eclipse.compare.internal.MergeSourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.mylyn.reviews.frame.ui.annotation.IEditorInputListener;
import org.eclipse.mylyn.reviews.frame.ui.annotation.IReviewAnnotationModel;
import org.eclipse.mylyn.reviews.frame.ui.annotation.IReviewAnnotationSupport;
import org.eclipse.ui.texteditor.ITextEditor;

public abstract class ReviewAnnotationSupport
implements IReviewAnnotationSupport {
    protected final IReviewAnnotationModel fTargetAnnotationModel;
    protected IEditorInputListener fTargetViewerListener = null;

    public ReviewAnnotationSupport(Object aSourceFile) {
        this.fTargetAnnotationModel = this.createAnnotationModel(aSourceFile);
        this.fTargetAnnotationModel.setFile(aSourceFile);
    }

    protected abstract IReviewAnnotationModel createAnnotationModel(Object var1);

    protected abstract void install(Object var1);

    public ITextEditor getTargetEditor() {
        if (this.fTargetViewerListener != null) {
            return this.fTargetViewerListener.getEditor();
        }
        return null;
    }

    public IReviewAnnotationModel getTargetAnnotationModel() {
        return this.fTargetAnnotationModel;
    }

    public void setAnnotationModelElement(Object aElement) {
        if (this.fTargetAnnotationModel != null) {
            this.fTargetAnnotationModel.setFile(aElement);
        }
    }

    public void refreshAnnotations(Object aElement) {
        if (this.fTargetAnnotationModel != null) {
            this.fTargetAnnotationModel.setFile(aElement);
            this.fTargetAnnotationModel.refreshAnnotations();
        }
    }

    public void addAnnotation(Object aElement) {
        if (this.fTargetAnnotationModel != null) {
            this.fTargetAnnotationModel.addAnnotation(aElement);
        }
    }

    public void updateAnnotation(Object aElement) {
        if (this.fTargetAnnotationModel != null) {
            this.fTargetAnnotationModel.updateAnnotation(aElement);
        }
    }

    public void removeAnnotation(Object aElement) {
        if (this.fTargetAnnotationModel != null) {
            this.fTargetAnnotationModel.removeAnnotation(aElement);
        }
    }

    public boolean equals(Object aObject) {
        if (this == aObject) {
            return true;
        }
        if (aObject == null) {
            return false;
        }
        if (!this.getClass().equals(aObject.getClass())) {
            return false;
        }
        ReviewAnnotationSupport other = (ReviewAnnotationSupport)aObject;
        return !(this.fTargetAnnotationModel == null ? other.fTargetAnnotationModel != null : !this.fTargetAnnotationModel.equals(other.fTargetAnnotationModel));
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.fTargetAnnotationModel == null ? 0 : this.fTargetAnnotationModel.hashCode());
        return result;
    }

    public static SourceViewer getSourceViewer(MergeSourceViewer aMergeViewer) {
        if (SourceViewer.class.isInstance(aMergeViewer)) {
            return (SourceViewer)SourceViewer.class.cast(aMergeViewer);
        }
        try {
            Method getSourceViewerRefl = MergeSourceViewer.class.getDeclaredMethod("getSourceViewer", new Class[0]);
            getSourceViewerRefl.setAccessible(true);
            Object returnValue = getSourceViewerRefl.invoke((Object)aMergeViewer, new Object[0]);
            if (returnValue instanceof SourceViewer) {
                return (SourceViewer)returnValue;
            }
        }
        catch (Exception exception) {}
        return null;
    }
}

