/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.filters;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewPhase;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewState;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.IR4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReview;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewGroup;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIRule;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIRuleArea;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIRuleSet;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIRuleViolation;

public class ReviewCompletedFilter
extends ViewerFilter {
    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (element instanceof R4EUIReviewGroup || element instanceof R4EUIRuleSet || element instanceof R4EUIRuleArea || element instanceof R4EUIRuleViolation || element instanceof R4EUIRule) {
            return true;
        }
        if (this.isParentReviewInProgress((IR4EUIModelElement)element)) {
            return true;
        }
        return this.isChildrenReviewInProgress((IR4EUIModelElement)element);
    }

    private boolean isChildrenReviewInProgress(IR4EUIModelElement aCurrentElement) {
        int length = aCurrentElement.getChildren().length;
        IR4EUIModelElement element = null;
        int i = 0;
        while (i < length) {
            element = aCurrentElement.getChildren()[i];
            if (!(element instanceof R4EUIReview)) {
                return false;
            }
            if (!((R4EReviewState)((R4EUIReview)element).getReview().getState()).getState().equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_COMPLETED) || ((R4EUIReview)element).isOpen()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isParentReviewInProgress(IR4EUIModelElement aCurrentElement) {
        IR4EUIModelElement reviewParentElement = aCurrentElement;
        while (!(reviewParentElement instanceof R4EUIReview)) {
            if ((reviewParentElement = reviewParentElement.getParent()) != null) continue;
            return false;
        }
        return !((R4EReviewState)((R4EUIReview)reviewParentElement).getReview().getState()).getState().equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_COMPLETED) || ((R4EUIReview)reviewParentElement).isOpen();
    }
}

