/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.console.command;

import java.util.Collection;
import org.eclipse.rdf4j.console.ConsoleIO;
import org.eclipse.rdf4j.console.ConsoleParameters;
import org.eclipse.rdf4j.console.ConsoleState;
import org.eclipse.rdf4j.console.command.QueryEvaluator;
import org.eclipse.rdf4j.console.command.TupleAndGraphQueryEvaluator;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.query.parser.sparql.SPARQLUtil;

public class Sparql
extends QueryEvaluator {
    private static final String PREFIX = "PREFIX";

    @Override
    public String getName() {
        return "sparql";
    }

    @Override
    public String getHelpShort() {
        return "Evaluate a SPARQL query";
    }

    @Override
    public String getHelpLong() {
        return "Usage:\nsparql                               Starts multi-line input for large SPARQL queries.\nsparql <query>                       Evaluates the SPARQL query on the currently open repository.\n\nsparql INFILE=\"infile.ext\"           Evaluates the query stored in a file.\nsparql OUTFILE=\"outfile.ext\" <query> Save the results to a file.\n    Supported extensions for graphs: jsonld, nt, ttl, xml\n    Supported extensions for tuples: csv, srj, srx, tsv\nsparql INFILE=\"infile.ext\" OUTFILE=\"outfile.ext\" \n\nselect|construct|ask|describe|prefix|base <rest-of-query>\n                                     Evaluates a SPARQL query on the currently open repository.\n";
    }

    @Deprecated
    public Sparql(ConsoleIO consoleIO, ConsoleState state, ConsoleParameters params) {
        super(consoleIO, state, params);
    }

    public Sparql(TupleAndGraphQueryEvaluator evaluator) {
        super(evaluator);
    }

    @Override
    protected boolean hasQueryPrefixes(String qry) {
        return qry.trim().startsWith(PREFIX);
    }

    @Override
    protected void addQueryPrefixes(StringBuffer result, Collection<Namespace> namespaces) {
        StringBuilder str = new StringBuilder(512);
        for (Namespace namespace : namespaces) {
            str.append(PREFIX).append(" ").append(namespace.getPrefix()).append(": ");
            str.append("<").append(SPARQLUtil.encodeString(namespace.getName())).append("> ");
        }
        result.insert(0, str);
    }
}

