/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.dawg;

import org.eclipse.rdf4j.model.Graph;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.impl.GraphImpl;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.TupleQueryResultHandlerException;
import org.eclipse.rdf4j.query.dawg.DAWGTestBooleanParser;
import org.eclipse.rdf4j.query.dawg.DAWGTestResultSetParseException;
import org.eclipse.rdf4j.query.dawg.DAWGTestResultSetParser;
import org.eclipse.rdf4j.query.dawg.DAWGTestResultSetWriter;
import org.eclipse.rdf4j.query.impl.TupleQueryResultBuilder;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.helpers.StatementCollector;

public class DAWGTestResultSetUtil {
    public static TupleQueryResult toTupleQueryResult(Iterable<? extends Statement> dawgGraph) throws DAWGTestResultSetParseException {
        TupleQueryResultBuilder tqrBuilder = new TupleQueryResultBuilder();
        DAWGTestResultSetParser parser = new DAWGTestResultSetParser(tqrBuilder);
        try {
            parser.startRDF();
            for (Statement statement : dawgGraph) {
                parser.handleStatement(statement);
            }
            parser.endRDF();
            return tqrBuilder.getQueryResult();
        }
        catch (RDFHandlerException e) {
            throw new DAWGTestResultSetParseException(e.getMessage(), e);
        }
    }

    public static Graph toGraph(TupleQueryResult tqr) throws QueryEvaluationException {
        GraphImpl graph = new GraphImpl();
        DAWGTestResultSetWriter writer = new DAWGTestResultSetWriter(new StatementCollector(graph));
        try {
            writer.startQueryResult(tqr.getBindingNames());
            while (tqr.hasNext()) {
                writer.handleSolution((BindingSet)tqr.next());
            }
            writer.endQueryResult();
        }
        catch (TupleQueryResultHandlerException e) {
            throw new RuntimeException(e);
        }
        return graph;
    }

    public static boolean toBooleanQueryResult(Iterable<? extends Statement> dawgGraph) throws DAWGTestResultSetParseException {
        DAWGTestBooleanParser parser = new DAWGTestBooleanParser();
        try {
            parser.startRDF();
            for (Statement statement : dawgGraph) {
                parser.handleStatement(statement);
            }
            parser.endRDF();
            return parser.getValue();
        }
        catch (RDFHandlerException e) {
            throw new DAWGTestResultSetParseException(e.getMessage(), e);
        }
    }
}

