/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.index.DocValuesWriter;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.Sorter;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedSetSortField;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.ByteBlockPool;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefHash;
import org.apache.lucene.util.Counter;
import org.apache.lucene.util.packed.PackedLongValues;

class SortedSetDocValuesWriter
extends DocValuesWriter {
    final BytesRefHash hash;
    private PackedLongValues.Builder pending;
    private PackedLongValues.Builder pendingCounts;
    private final Counter iwBytesUsed;
    private long bytesUsed;
    private final FieldInfo fieldInfo;
    private int currentDoc;
    private int[] currentValues = new int[8];
    private int currentUpto = 0;
    private int maxCount = 0;
    PackedLongValues finalOrds;
    PackedLongValues finalOrdCounts;
    int[] finalSortedValues;
    int[] finalOrdMap;
    int[] valueStartPtrs;

    public SortedSetDocValuesWriter(FieldInfo fieldInfo, Counter iwBytesUsed) {
        this.fieldInfo = fieldInfo;
        this.iwBytesUsed = iwBytesUsed;
        this.hash = new BytesRefHash(new ByteBlockPool(new ByteBlockPool.DirectTrackingAllocator(iwBytesUsed)), 16, new BytesRefHash.DirectBytesStartArray(16, iwBytesUsed));
        this.pending = PackedLongValues.packedBuilder(0.0f);
        this.pendingCounts = PackedLongValues.deltaPackedBuilder(0.0f);
        this.bytesUsed = this.pending.ramBytesUsed() + this.pendingCounts.ramBytesUsed();
        iwBytesUsed.addAndGet(this.bytesUsed);
    }

    public void addValue(int docID, BytesRef value) {
        if (value == null) {
            throw new IllegalArgumentException("field \"" + this.fieldInfo.name + "\": null value not allowed");
        }
        if (value.length > 32766) {
            throw new IllegalArgumentException("DocValuesField \"" + this.fieldInfo.name + "\" is too large, must be <= " + 32766);
        }
        if (docID != this.currentDoc) {
            this.finishCurrentDoc();
        }
        while (this.currentDoc < docID) {
            this.pendingCounts.add(0L);
            ++this.currentDoc;
        }
        this.addOneValue(value);
        this.updateBytesUsed();
    }

    private void finishCurrentDoc() {
        Arrays.sort(this.currentValues, 0, this.currentUpto);
        int lastValue = -1;
        int count = 0;
        for (int i = 0; i < this.currentUpto; ++i) {
            int termID = this.currentValues[i];
            if (termID != lastValue) {
                this.pending.add(termID);
                ++count;
            }
            lastValue = termID;
        }
        this.pendingCounts.add(count);
        this.maxCount = Math.max(this.maxCount, count);
        this.currentUpto = 0;
        ++this.currentDoc;
    }

    @Override
    public void finish(int maxDoc) {
        this.finishCurrentDoc();
        for (int i = this.currentDoc; i < maxDoc; ++i) {
            this.pendingCounts.add(0L);
        }
        assert (this.pendingCounts.size() == (long)maxDoc);
        int valueCount = this.hash.size();
        this.finalOrds = this.pending.build();
        this.finalOrdCounts = this.pendingCounts.build();
        this.finalSortedValues = this.hash.sort();
        this.finalOrdMap = new int[valueCount];
        for (int ord = 0; ord < valueCount; ++ord) {
            this.finalOrdMap[this.finalSortedValues[ord]] = ord;
        }
    }

    private void addOneValue(BytesRef value) {
        int termID = this.hash.add(value);
        if (termID < 0) {
            termID = -termID - 1;
        } else {
            this.iwBytesUsed.addAndGet(8L);
        }
        if (this.currentUpto == this.currentValues.length) {
            this.currentValues = ArrayUtil.grow(this.currentValues, this.currentValues.length + 1);
            this.iwBytesUsed.addAndGet((this.currentValues.length - this.currentUpto) * 2 * 4);
        }
        this.currentValues[this.currentUpto] = termID;
        ++this.currentUpto;
    }

    private void updateBytesUsed() {
        long newBytesUsed = this.pending.ramBytesUsed() + this.pendingCounts.ramBytesUsed();
        this.iwBytesUsed.addAndGet(newBytesUsed - this.bytesUsed);
        this.bytesUsed = newBytesUsed;
    }

    @Override
    public void flush(SegmentWriteState state, final Sorter.DocMap sortMap, DocValuesConsumer dvConsumer) throws IOException {
        final int maxDoc = state.segmentInfo.maxDoc();
        final int maxCountPerDoc = this.maxCount;
        final int valueCount = this.hash.size();
        if (this.valueStartPtrs == null) {
            this.valueStartPtrs = new int[maxDoc];
            int ptr = 0;
            int doc = 0;
            PackedLongValues.Iterator it = this.finalOrdCounts.iterator();
            while (it.hasNext()) {
                this.valueStartPtrs[doc++] = ptr;
                ptr = (int)((long)ptr + it.next());
            }
        }
        dvConsumer.addSortedSetField(this.fieldInfo, new Iterable<BytesRef>(){

            @Override
            public Iterator<BytesRef> iterator() {
                return new ValuesIterator(SortedSetDocValuesWriter.this.finalSortedValues, valueCount, SortedSetDocValuesWriter.this.hash);
            }
        }, new Iterable<Number>(){

            @Override
            public Iterator<Number> iterator() {
                if (sortMap == null) {
                    return new OrdCountIterator(maxDoc, SortedSetDocValuesWriter.this.finalOrdCounts);
                }
                return new SortingOrdCountIterator(maxDoc, SortedSetDocValuesWriter.this.finalOrdCounts, sortMap);
            }
        }, new Iterable<Number>(){

            @Override
            public Iterator<Number> iterator() {
                if (sortMap == null) {
                    return new OrdsIterator(SortedSetDocValuesWriter.this.finalOrdMap, maxCountPerDoc, SortedSetDocValuesWriter.this.finalOrds, SortedSetDocValuesWriter.this.finalOrdCounts);
                }
                return new SortingOrdsIterator(SortedSetDocValuesWriter.this.finalOrdMap, maxCountPerDoc, SortedSetDocValuesWriter.this.finalOrds, SortedSetDocValuesWriter.this.finalOrdCounts, sortMap, SortedSetDocValuesWriter.this.valueStartPtrs);
            }
        });
    }

    @Override
    Sorter.DocComparator getDocComparator(int numDoc, SortField sortField) throws IOException {
        assert (sortField instanceof SortedSetSortField);
        SortedSetSortField sf = (SortedSetSortField)sortField;
        this.valueStartPtrs = new int[numDoc];
        int ptr = 0;
        int doc = 0;
        PackedLongValues.Iterator it = this.finalOrdCounts.iterator();
        while (it.hasNext()) {
            this.valueStartPtrs[doc++] = ptr;
            ptr = (int)((long)ptr + it.next());
        }
        int missingOrd = sortField.getMissingValue() == SortField.STRING_LAST ? Integer.MAX_VALUE : Integer.MIN_VALUE;
        final int[] bestOrds = new int[numDoc];
        Arrays.fill(bestOrds, missingOrd);
        block5: for (int docID = 0; docID < numDoc; ++docID) {
            int count = (int)this.finalOrdCounts.get(docID);
            if (count == 0) continue;
            int start = this.valueStartPtrs[docID];
            switch (sf.getSelector()) {
                case MIN: {
                    int min = Integer.MAX_VALUE;
                    for (int i = 0; i < count; ++i) {
                        min = Math.min(this.finalOrdMap[(int)this.finalOrds.get(start + i)], min);
                    }
                    bestOrds[docID] = min;
                    continue block5;
                }
                case MAX: {
                    int max = 0;
                    for (int i = 0; i < count; ++i) {
                        max = Math.max(this.finalOrdMap[(int)this.finalOrds.get(start + i)], max);
                    }
                    bestOrds[docID] = max;
                    continue block5;
                }
                default: {
                    throw new IllegalStateException("unhandled SortedSetSortField.getSelector()=" + (Object)((Object)sf.getSelector()));
                }
            }
        }
        final int reverseMul = sortField.getReverse() ? -1 : 1;
        return new Sorter.DocComparator(){

            @Override
            public int compare(int docID1, int docID2) {
                return reverseMul * Integer.compare(bestOrds[docID1], bestOrds[docID2]);
            }
        };
    }

    private static class SortingOrdCountIterator
    implements Iterator<Number> {
        final PackedLongValues counts;
        final Sorter.DocMap sortMap;
        final int maxDoc;
        int docUpto;

        SortingOrdCountIterator(int maxDoc, PackedLongValues ordCounts, Sorter.DocMap sortMap) {
            this.maxDoc = maxDoc;
            assert (ordCounts.size() == (long)maxDoc);
            this.counts = ordCounts;
            this.sortMap = sortMap;
        }

        @Override
        public boolean hasNext() {
            return this.docUpto < this.maxDoc;
        }

        @Override
        public Number next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int oldUpto = this.sortMap.newToOld(this.docUpto);
            ++this.docUpto;
            return this.counts.get(oldUpto);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class OrdCountIterator
    implements Iterator<Number> {
        final PackedLongValues counts;
        final PackedLongValues.Iterator iter;
        final int maxDoc;
        int docUpto;

        OrdCountIterator(int maxDoc, PackedLongValues ordCounts) {
            this.maxDoc = maxDoc;
            assert (ordCounts.size() == (long)maxDoc);
            this.iter = ordCounts.iterator();
            this.counts = ordCounts;
        }

        @Override
        public boolean hasNext() {
            return this.docUpto < this.maxDoc;
        }

        @Override
        public Number next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.docUpto;
            return this.iter.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class SortingOrdsIterator
    implements Iterator<Number> {
        final PackedLongValues ords;
        final PackedLongValues ordCounts;
        final int[] ordMap;
        final int[] starts;
        final long numOrds;
        final Sorter.DocMap sortMap;
        long ordUpto;
        final int[] currentDoc;
        int docUpto;
        int currentUpto;
        int currentLength;

        SortingOrdsIterator(int[] ordMap, int maxCount, PackedLongValues ords, PackedLongValues ordCounts, Sorter.DocMap sortMap, int[] starts) {
            this.currentDoc = new int[maxCount];
            this.ordMap = ordMap;
            this.numOrds = ords.size();
            this.ords = ords;
            this.ordCounts = ordCounts;
            this.sortMap = sortMap;
            this.starts = starts;
        }

        @Override
        public boolean hasNext() {
            return this.ordUpto < this.numOrds;
        }

        @Override
        public Number next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            while (this.currentUpto == this.currentLength) {
                this.currentUpto = 0;
                int oldUpto = this.sortMap.newToOld(this.docUpto);
                int start = this.starts[oldUpto];
                this.currentLength = (int)this.ordCounts.get(oldUpto);
                for (int i = 0; i < this.currentLength; ++i) {
                    this.currentDoc[i] = this.ordMap[(int)this.ords.get(start + i)];
                }
                Arrays.sort(this.currentDoc, 0, this.currentLength);
                ++this.docUpto;
            }
            int ord = this.currentDoc[this.currentUpto];
            ++this.currentUpto;
            ++this.ordUpto;
            return ord;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class OrdsIterator
    implements Iterator<Number> {
        final PackedLongValues.Iterator iter;
        final PackedLongValues.Iterator iterCounts;
        final int[] ordMap;
        final long numOrds;
        long ordUpto;
        final int[] currentDoc;
        int currentUpto;
        int currentLength;

        OrdsIterator(int[] ordMap, int maxCount, PackedLongValues ords, PackedLongValues ordCounts) {
            this.currentDoc = new int[maxCount];
            this.ordMap = ordMap;
            this.numOrds = ords.size();
            this.iter = ords.iterator();
            this.iterCounts = ordCounts.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.ordUpto < this.numOrds;
        }

        @Override
        public Number next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            while (this.currentUpto == this.currentLength) {
                this.currentUpto = 0;
                this.currentLength = (int)this.iterCounts.next();
                for (int i = 0; i < this.currentLength; ++i) {
                    this.currentDoc[i] = this.ordMap[(int)this.iter.next()];
                }
                Arrays.sort(this.currentDoc, 0, this.currentLength);
            }
            int ord = this.currentDoc[this.currentUpto];
            ++this.currentUpto;
            ++this.ordUpto;
            return ord;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class ValuesIterator
    implements Iterator<BytesRef> {
        final int[] sortedValues;
        final BytesRefHash hash;
        final BytesRef scratch = new BytesRef();
        final int valueCount;
        int ordUpto;

        ValuesIterator(int[] sortedValues, int valueCount, BytesRefHash hash) {
            this.sortedValues = sortedValues;
            this.valueCount = valueCount;
            this.hash = hash;
        }

        @Override
        public boolean hasNext() {
            return this.ordUpto < this.valueCount;
        }

        @Override
        public BytesRef next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.hash.get(this.sortedValues[this.ordUpto], this.scratch);
            ++this.ordUpto;
            return this.scratch;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

