/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.runtime;

import java.net.MalformedURLException;
import java.util.Collection;
import org.eclipse.rdf4j.RDF4JException;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.LinkedHashModel;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.RDFS;
import org.eclipse.rdf4j.repository.config.RepositoryConfig;
import org.eclipse.rdf4j.repository.config.RepositoryConfigException;
import org.eclipse.rdf4j.repository.config.RepositoryConfigSchema;
import org.eclipse.rdf4j.repository.http.config.HTTPRepositoryConfig;
import org.eclipse.rdf4j.repository.http.config.HTTPRepositorySchema;
import org.eclipse.rdf4j.repository.manager.RepositoryManager;
import org.eclipse.rdf4j.repository.sail.config.ProxyRepositorySchema;
import org.eclipse.rdf4j.repository.sail.config.SailRepositorySchema;
import org.eclipse.rdf4j.repository.sparql.config.SPARQLRepositoryConfig;
import org.eclipse.rdf4j.sail.config.SailConfigSchema;
import org.eclipse.rdf4j.sail.federation.config.FederationConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryManagerFederator {
    private static final Logger LOGGER = LoggerFactory.getLogger(RepositoryManagerFederator.class);
    private final RepositoryManager manager;
    private final ValueFactory valueFactory;

    public RepositoryManagerFederator(RepositoryManager manager) {
        this.manager = manager;
        this.valueFactory = SimpleValueFactory.getInstance();
    }

    public void addFed(String fedID, String description, Collection<String> members, boolean readonly, boolean distinct) throws MalformedURLException, RDF4JException {
        if (members.contains(fedID)) {
            throw new RepositoryConfigException("A federation member may not have the same ID as the federation.");
        }
        LinkedHashModel graph = new LinkedHashModel();
        BNode fedRepoNode = this.valueFactory.createBNode();
        LOGGER.debug("Federation repository root node: {}", (Object)fedRepoNode);
        RepositoryManagerFederator.addToGraph((Model)graph, (Resource)fedRepoNode, RDF.TYPE, (Value)RepositoryConfigSchema.REPOSITORY);
        RepositoryManagerFederator.addToGraph((Model)graph, (Resource)fedRepoNode, RepositoryConfigSchema.REPOSITORYID, (Value)this.valueFactory.createLiteral(fedID));
        RepositoryManagerFederator.addToGraph((Model)graph, (Resource)fedRepoNode, RDFS.LABEL, (Value)this.valueFactory.createLiteral(description));
        this.addImplementation(members, (Model)graph, fedRepoNode, readonly, distinct);
        RepositoryConfig fedConfig = RepositoryConfig.create((Model)graph, (Resource)fedRepoNode);
        fedConfig.validate();
        this.manager.addRepositoryConfig(fedConfig);
    }

    private void addImplementation(Collection<String> members, Model graph, BNode fedRepoNode, boolean readonly, boolean distinct) throws RDF4JException, MalformedURLException {
        BNode implRoot = this.valueFactory.createBNode();
        RepositoryManagerFederator.addToGraph(graph, (Resource)fedRepoNode, RepositoryConfigSchema.REPOSITORYIMPL, (Value)implRoot);
        RepositoryManagerFederator.addToGraph(graph, (Resource)implRoot, RepositoryConfigSchema.REPOSITORYTYPE, (Value)this.valueFactory.createLiteral("openrdf:SailRepository"));
        this.addSail(members, graph, implRoot, readonly, distinct);
    }

    private void addSail(Collection<String> members, Model graph, BNode implRoot, boolean readonly, boolean distinct) throws RDF4JException, MalformedURLException {
        BNode sailRoot = this.valueFactory.createBNode();
        RepositoryManagerFederator.addToGraph(graph, (Resource)implRoot, SailRepositorySchema.SAILIMPL, (Value)sailRoot);
        RepositoryManagerFederator.addToGraph(graph, (Resource)sailRoot, SailConfigSchema.SAILTYPE, (Value)this.valueFactory.createLiteral("openrdf:Federation"));
        RepositoryManagerFederator.addToGraph(graph, (Resource)sailRoot, FederationConfig.READ_ONLY, (Value)this.valueFactory.createLiteral(readonly));
        RepositoryManagerFederator.addToGraph(graph, (Resource)sailRoot, FederationConfig.DISTINCT, (Value)this.valueFactory.createLiteral(distinct));
        for (String member : members) {
            this.addMember(graph, sailRoot, member);
        }
    }

    private void addMember(Model graph, BNode sailRoot, String identifier) throws RDF4JException, MalformedURLException {
        LOGGER.debug("Adding member: {}", (Object)identifier);
        BNode memberNode = this.valueFactory.createBNode();
        RepositoryManagerFederator.addToGraph(graph, (Resource)sailRoot, FederationConfig.MEMBER, (Value)memberNode);
        String memberRepoType = this.manager.getRepositoryConfig(identifier).getRepositoryImplConfig().getType();
        if (!"openrdf:SPARQLRepository".equals(memberRepoType) && !"openrdf:HTTPRepository".equals(memberRepoType)) {
            memberRepoType = "openrdf:ProxyRepository";
        }
        RepositoryManagerFederator.addToGraph(graph, (Resource)memberNode, RepositoryConfigSchema.REPOSITORYTYPE, (Value)this.valueFactory.createLiteral(memberRepoType));
        RepositoryManagerFederator.addToGraph(graph, (Resource)memberNode, this.getLocationPredicate(memberRepoType), this.getMemberLocator(identifier, memberRepoType));
        LOGGER.debug("Added member {}: ", (Object)identifier);
    }

    private IRI getLocationPredicate(String memberRepoType) {
        IRI predicate = "openrdf:SPARQLRepository".equals(memberRepoType) ? SPARQLRepositoryConfig.QUERY_ENDPOINT : ("openrdf:HTTPRepository".equals(memberRepoType) ? HTTPRepositorySchema.REPOSITORYURL : ProxyRepositorySchema.PROXIED_ID);
        return predicate;
    }

    private Value getMemberLocator(String identifier, String memberRepoType) throws MalformedURLException, RepositoryConfigException, RDF4JException {
        Object locator = "openrdf:HTTPRepository".equals(memberRepoType) ? this.valueFactory.createIRI(((HTTPRepositoryConfig)this.manager.getRepositoryConfig(identifier).getRepositoryImplConfig()).getURL()) : ("openrdf:SPARQLRepository".equals(memberRepoType) ? this.valueFactory.createIRI(((SPARQLRepositoryConfig)this.manager.getRepositoryConfig(identifier).getRepositoryImplConfig()).getQueryEndpointUrl()) : this.valueFactory.createLiteral(identifier));
        return locator;
    }

    private static void addToGraph(Model graph, Resource subject, IRI predicate, Value object) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(subject + " " + predicate + " " + object);
        }
        graph.add(subject, predicate, object, new Resource[0]);
    }
}

