/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.federation;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.http.client.HttpClient;
import org.eclipse.rdf4j.IsolationLevel;
import org.eclipse.rdf4j.IsolationLevels;
import org.eclipse.rdf4j.RDF4JException;
import org.eclipse.rdf4j.http.client.HttpClientDependent;
import org.eclipse.rdf4j.http.client.HttpClientSessionManager;
import org.eclipse.rdf4j.http.client.SessionManagerDependent;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.algebra.evaluation.EvaluationStrategy;
import org.eclipse.rdf4j.query.algebra.evaluation.TripleSource;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.FederatedServiceResolver;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.FederatedServiceResolverClient;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.RepositoryResolver;
import org.eclipse.rdf4j.repository.RepositoryResolverClient;
import org.eclipse.rdf4j.repository.filters.RepositoryBloomFilter;
import org.eclipse.rdf4j.repository.sparql.federation.SPARQLServiceResolver;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.federation.AbstractFederationConnection;
import org.eclipse.rdf4j.sail.federation.PrefixHashSet;
import org.eclipse.rdf4j.sail.federation.ReadOnlyConnection;
import org.eclipse.rdf4j.sail.federation.WritableConnection;
import org.eclipse.rdf4j.sail.federation.evaluation.FederationStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Federation
implements Sail,
Executor,
FederatedServiceResolverClient,
RepositoryResolverClient,
HttpClientDependent,
SessionManagerDependent {
    private static final Logger LOGGER = LoggerFactory.getLogger(Federation.class);
    private final List<Repository> members = new ArrayList<Repository>();
    private final Map<Repository, RepositoryBloomFilter> bloomFilters = new HashMap<Repository, RepositoryBloomFilter>();
    private final ExecutorService executor = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("rdf4j-federation-%d").build());
    private PrefixHashSet localPropertySpace;
    private boolean distinct;
    private boolean readOnly;
    private File dataDir;
    private volatile FederatedServiceResolver serviceResolver;
    private volatile SPARQLServiceResolver dependentServiceResolver;

    @Override
    public File getDataDir() {
        return this.dataDir;
    }

    @Override
    public void setDataDir(File dataDir) {
        this.dataDir = dataDir;
    }

    @Override
    public ValueFactory getValueFactory() {
        return SimpleValueFactory.getInstance();
    }

    @Override
    public boolean isWritable() throws SailException {
        return !this.isReadOnly();
    }

    public void addMember(Repository member) {
        this.members.add(member);
    }

    protected List<Repository> getMembers() {
        return Collections.unmodifiableList(this.members);
    }

    public void setBloomFilter(Repository member, RepositoryBloomFilter filter) {
        this.bloomFilters.put(member, filter);
    }

    protected Map<Repository, RepositoryBloomFilter> getBloomFilters() {
        return Collections.unmodifiableMap(this.bloomFilters);
    }

    public PrefixHashSet getLocalPropertySpace() {
        return this.localPropertySpace;
    }

    public void setLocalPropertySpace(Collection<String> localPropertySpace) {
        this.localPropertySpace = localPropertySpace.isEmpty() ? null : new PrefixHashSet(localPropertySpace);
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public synchronized FederatedServiceResolver getFederatedServiceResolver() {
        if (this.serviceResolver == null) {
            if (this.dependentServiceResolver == null) {
                this.dependentServiceResolver = new SPARQLServiceResolver();
            }
            this.serviceResolver = this.dependentServiceResolver;
            return this.serviceResolver;
        }
        return this.serviceResolver;
    }

    public synchronized void setFederatedServiceResolver(FederatedServiceResolver resolver) {
        this.serviceResolver = resolver;
        for (Repository member : this.members) {
            if (!(member instanceof FederatedServiceResolverClient)) continue;
            ((FederatedServiceResolverClient)member).setFederatedServiceResolver(resolver);
        }
    }

    public void setRepositoryResolver(RepositoryResolver resolver) {
        for (Repository member : this.members) {
            if (!(member instanceof RepositoryResolverClient)) continue;
            ((RepositoryResolverClient)member).setRepositoryResolver(resolver);
        }
    }

    public HttpClientSessionManager getHttpClientSessionManager() {
        for (Repository member : this.members) {
            HttpClientSessionManager client;
            if (!(member instanceof SessionManagerDependent) || (client = ((SessionManagerDependent)member).getHttpClientSessionManager()) == null) continue;
            return client;
        }
        return null;
    }

    public void setHttpClientSessionManager(HttpClientSessionManager client) {
        for (Repository member : this.members) {
            if (!(member instanceof SessionManagerDependent)) continue;
            ((SessionManagerDependent)member).setHttpClientSessionManager(client);
        }
    }

    public HttpClient getHttpClient() {
        for (Repository member : this.members) {
            HttpClient client;
            if (!(member instanceof HttpClientDependent) || (client = ((HttpClientDependent)member).getHttpClient()) == null) continue;
            return client;
        }
        return null;
    }

    public void setHttpClient(HttpClient client) {
        for (Repository member : this.members) {
            if (!(member instanceof HttpClientDependent)) continue;
            ((HttpClientDependent)member).setHttpClient(client);
        }
    }

    @Override
    @Deprecated
    public void initialize() throws SailException {
        this.init();
    }

    @Override
    public void init() throws SailException {
        for (Repository member : this.members) {
            try {
                member.initialize();
            }
            catch (RepositoryException e) {
                throw new SailException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void shutDown() throws SailException {
        ArrayList<SailException> toThrowExceptions = new ArrayList<SailException>();
        try {
            for (Repository member : this.members) {
                try {
                    member.shutDown();
                }
                catch (SailException e) {
                    toThrowExceptions.add(e);
                }
                catch (RDF4JException e) {
                    toThrowExceptions.add(new SailException(e));
                }
            }
        }
        finally {
            try {
                SPARQLServiceResolver toCloseServiceResolver = this.dependentServiceResolver;
                this.dependentServiceResolver = null;
                if (toCloseServiceResolver != null) {
                    toCloseServiceResolver.shutDown();
                }
            }
            finally {
                try {
                    this.executor.shutdown();
                    this.executor.awaitTermination(10L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                finally {
                    if (!this.executor.isShutdown()) {
                        this.executor.shutdownNow();
                    }
                }
            }
        }
        if (!toThrowExceptions.isEmpty()) {
            throw (SailException)((Object)toThrowExceptions.get(0));
        }
    }

    @Override
    public void execute(Runnable command) {
        this.executor.execute(command);
    }

    @Override
    public SailConnection getConnection() throws SailException {
        ArrayList<RepositoryConnection> connections = new ArrayList<RepositoryConnection>(this.members.size());
        boolean allGood = false;
        try {
            for (Repository member : this.members) {
                connections.add(member.getConnection());
            }
            AbstractFederationConnection result = this.readOnly ? new ReadOnlyConnection(this, connections) : new WritableConnection(this, connections);
            allGood = true;
            AbstractFederationConnection abstractFederationConnection = result;
            return abstractFederationConnection;
        }
        catch (RepositoryException e) {
            throw new SailException(e);
        }
        finally {
            if (!allGood) {
                this.closeAll(connections);
            }
        }
    }

    protected EvaluationStrategy createEvaluationStrategy(TripleSource tripleSource, Dataset dataset, FederatedServiceResolver resolver) {
        return new FederationStrategy(this, tripleSource, dataset, this.getFederatedServiceResolver());
    }

    private void closeAll(Iterable<RepositoryConnection> connections) {
        for (RepositoryConnection con : connections) {
            try {
                con.close();
            }
            catch (RepositoryException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public List<IsolationLevel> getSupportedIsolationLevels() {
        return Arrays.asList(IsolationLevels.NONE);
    }

    @Override
    public IsolationLevel getDefaultIsolationLevel() {
        return IsolationLevels.NONE;
    }
}

