/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.memory.model;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;
import org.eclipse.rdf4j.sail.memory.model.MemLiteral;

public class DecimalMemLiteral
extends MemLiteral {
    private static final long serialVersionUID = 6760727653986046772L;
    private final BigDecimal value;

    public DecimalMemLiteral(Object creator, BigDecimal value) {
        this(creator, value, XMLSchema.DECIMAL);
    }

    public DecimalMemLiteral(Object creator, BigDecimal value, IRI datatype) {
        this(creator, value.toPlainString(), value, datatype);
    }

    public DecimalMemLiteral(Object creator, String label, BigDecimal value, IRI datatype) {
        super(creator, label, datatype);
        this.value = value;
    }

    public byte byteValue() {
        return this.value.byteValue();
    }

    public short shortValue() {
        return this.value.shortValue();
    }

    public int intValue() {
        return this.value.intValue();
    }

    public long longValue() {
        return this.value.longValue();
    }

    public float floatValue() {
        return this.value.floatValue();
    }

    public double doubleValue() {
        return this.value.doubleValue();
    }

    public BigInteger integerValue() {
        return this.value.toBigInteger();
    }

    public BigDecimal decimalValue() {
        return this.value;
    }
}

