/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.spin.function;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.BooleanLiteral;
import org.eclipse.rdf4j.query.Binding;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.BooleanQuery;
import org.eclipse.rdf4j.query.Query;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryPreparer;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.parser.ParsedBooleanQuery;
import org.eclipse.rdf4j.query.parser.ParsedQuery;
import org.eclipse.rdf4j.query.parser.ParsedTupleQuery;
import org.eclipse.rdf4j.spin.Argument;
import org.eclipse.rdf4j.spin.function.AbstractSpinFunction;
import org.eclipse.rdf4j.spin.function.TransientFunction;

public class SpinFunction
extends AbstractSpinFunction
implements TransientFunction {
    private ParsedQuery parsedQuery;
    private final List<Argument> arguments = new ArrayList<Argument>(4);

    public SpinFunction(String uri) {
        super(uri);
    }

    public void setParsedQuery(ParsedQuery query) {
        this.parsedQuery = query;
    }

    public ParsedQuery getParsedQuery() {
        return this.parsedQuery;
    }

    public void addArgument(Argument arg) {
        this.arguments.add(arg);
    }

    public List<Argument> getArguments() {
        return this.arguments;
    }

    public String toString() {
        return this.getURI() + "(" + Joiner.on((String)", ").join(this.arguments) + ")";
    }

    @Override
    public Value evaluate(ValueFactory valueFactory, Value ... args) throws ValueExprEvaluationException {
        BooleanLiteral result;
        QueryPreparer qp = this.getCurrentQueryPreparer();
        if (this.parsedQuery instanceof ParsedBooleanQuery) {
            ParsedBooleanQuery askQuery = (ParsedBooleanQuery)this.parsedQuery;
            BooleanQuery queryOp = qp.prepare(askQuery);
            SpinFunction.addBindings((Query)queryOp, this.arguments, args);
            try {
                result = BooleanLiteral.valueOf((boolean)queryOp.evaluate());
            }
            catch (QueryEvaluationException e) {
                throw new ValueExprEvaluationException(e);
            }
        } else if (this.parsedQuery instanceof ParsedTupleQuery) {
            ParsedTupleQuery selectQuery = (ParsedTupleQuery)this.parsedQuery;
            TupleQuery queryOp = qp.prepare(selectQuery);
            SpinFunction.addBindings((Query)queryOp, this.arguments, args);
            try {
                BindingSet bs;
                TupleQueryResult queryResult = queryOp.evaluate();
                if (queryResult.hasNext()) {
                    bs = (BindingSet)queryResult.next();
                    if (bs.size() != 1) {
                        throw new ValueExprEvaluationException("Only a single result variables is supported: " + bs);
                    }
                } else {
                    throw new ValueExprEvaluationException("No value");
                }
                result = ((Binding)bs.iterator().next()).getValue();
            }
            catch (QueryEvaluationException e) {
                throw new ValueExprEvaluationException(e);
            }
        } else {
            throw new IllegalStateException("Unexpected query: " + this.parsedQuery);
        }
        return result;
    }

    private static void addBindings(Query query, List<Argument> arguments, Value ... args) {
        for (int i = 0; i < args.length; ++i) {
            Argument argument = arguments.get(i);
            query.setBinding(argument.getPredicate().getLocalName(), args[i]);
        }
    }
}

