/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.AST;

import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.sail.shacl.AST.NodeShape;
import org.eclipse.rdf4j.sail.shacl.AST.PathPropertyShape;
import org.eclipse.rdf4j.sail.shacl.AST.StandardisedPlanHelper;
import org.eclipse.rdf4j.sail.shacl.ShaclSailConnection;
import org.eclipse.rdf4j.sail.shacl.SourceConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.planNodes.EnrichWithShape;
import org.eclipse.rdf4j.sail.shacl.planNodes.NodeKindFilter;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeKindPropertyShape
extends PathPropertyShape {
    private final NodeKind nodeKind;
    private static final Logger logger = LoggerFactory.getLogger(NodeKindPropertyShape.class);

    NodeKindPropertyShape(Resource id, SailRepositoryConnection connection, NodeShape nodeShape, Resource nodeKind) {
        super(id, connection, nodeShape);
        this.nodeKind = NodeKind.from(nodeKind);
    }

    @Override
    public PlanNode getPlan(ShaclSailConnection shaclSailConnection, NodeShape nodeShape, boolean printPlans, PlanNode overrideTargetNode) {
        PlanNode invalidValues = StandardisedPlanHelper.getGenericSingleObjectPlan(shaclSailConnection, nodeShape, parent -> new NodeKindFilter(parent, this.nodeKind), this, overrideTargetNode);
        if (printPlans) {
            String planAsGraphvizDot = this.getPlanAsGraphvizDot(invalidValues, shaclSailConnection);
            logger.info(planAsGraphvizDot);
        }
        return new EnrichWithShape(invalidValues, this);
    }

    @Override
    public SourceConstraintComponent getSourceConstraintComponent() {
        return SourceConstraintComponent.NodeKindConstraintComponent;
    }

    public static enum NodeKind {
        BlankNode(SHACL.BLANK_NODE),
        IRI(SHACL.IRI),
        Literal(SHACL.LITERAL),
        BlankNodeOrIRI(SHACL.BLANK_NODE_OR_IRI),
        BlankNodeOrLiteral(SHACL.BLANK_NODE_OR_LITERAL),
        IRIOrLiteral(SHACL.IRI_OR_LITERAL);

        IRI iri;

        private NodeKind(IRI iri) {
            this.iri = iri;
        }

        public static NodeKind from(Resource resource) {
            for (NodeKind value : NodeKind.values()) {
                if (!value.iri.equals(resource)) continue;
                return value;
            }
            throw new IllegalStateException("Unknown nodeKind: " + resource);
        }
    }
}

