/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.AST;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.rdf4j.common.iteration.Iterations;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.sail.NotifyingSailConnection;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.shacl.AST.Path;
import org.eclipse.rdf4j.sail.shacl.AST.PlanGenerator;
import org.eclipse.rdf4j.sail.shacl.AST.PropertyShape;
import org.eclipse.rdf4j.sail.shacl.AST.QueryGenerator;
import org.eclipse.rdf4j.sail.shacl.AST.RequiresEvalutation;
import org.eclipse.rdf4j.sail.shacl.AST.ShaclProperties;
import org.eclipse.rdf4j.sail.shacl.AST.TargetClass;
import org.eclipse.rdf4j.sail.shacl.AST.TargetNode;
import org.eclipse.rdf4j.sail.shacl.RdfsSubClassOfReasoner;
import org.eclipse.rdf4j.sail.shacl.ShaclSail;
import org.eclipse.rdf4j.sail.shacl.ShaclSailConnection;
import org.eclipse.rdf4j.sail.shacl.planNodes.LoggingNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.Select;
import org.eclipse.rdf4j.sail.shacl.planNodes.TrimTuple;

public class NodeShape
implements PlanGenerator,
RequiresEvalutation,
QueryGenerator {
    private Resource id;
    private List<PropertyShape> propertyShapes;

    public NodeShape(Resource id, SailRepositoryConnection connection) {
        this.id = id;
        this.propertyShapes = PropertyShape.Factory.getPropertyShapes(id, connection, this);
    }

    @Override
    public PlanNode getPlan(ShaclSailConnection shaclSailConnection, NodeShape nodeShape, boolean printPlans, PlanNode overrideTargetNode) {
        throw new UnsupportedOperationException();
    }

    @Override
    public PlanNode getPlanAddedStatements(ShaclSailConnection shaclSailConnection, NodeShape nodeShape) {
        PlanNode node = shaclSailConnection.getCachedNodeFor(new Select(shaclSailConnection.getAddedStatements(), this.getQuery("?a", "?c", null)));
        return new TrimTuple(new LoggingNode(node, ""), 0, 1);
    }

    @Override
    public PlanNode getPlanRemovedStatements(ShaclSailConnection shaclSailConnection, NodeShape nodeShape) {
        PlanNode node = shaclSailConnection.getCachedNodeFor(new Select(shaclSailConnection.getRemovedStatements(), this.getQuery("?a", "?c", null)));
        return new TrimTuple(new LoggingNode(node, ""), 0, 1);
    }

    @Override
    public List<Path> getPaths() {
        throw new IllegalStateException();
    }

    public List<PlanNode> generatePlans(ShaclSailConnection shaclSailConnection, NodeShape nodeShape, boolean printPlans) {
        return this.propertyShapes.stream().filter(propertyShape -> propertyShape.requiresEvaluation(shaclSailConnection.getAddedStatements(), shaclSailConnection.getRemovedStatements())).map(propertyShape -> propertyShape.getPlan(shaclSailConnection, nodeShape, printPlans, null)).collect(Collectors.toList());
    }

    @Override
    public boolean requiresEvaluation(SailConnection addedStatements, SailConnection removedStatements) {
        return true;
    }

    @Override
    public String getQuery(String subjectVariable, String objectVariable, RdfsSubClassOfReasoner rdfsSubClassOfReasoner) {
        return subjectVariable + " ?b " + objectVariable;
    }

    public Resource getId() {
        return this.id;
    }

    public String toString() {
        return this.id.toString();
    }

    public PlanNode getTargetFilter(NotifyingSailConnection shaclSailConnection, PlanNode parent) {
        return parent;
    }

    public static class Factory {
        public static List<NodeShape> getShapes(SailRepositoryConnection connection, ShaclSail sail) {
            try (Stream<Statement> stream = Iterations.stream(connection.getStatements(null, RDF.TYPE, (Value)SHACL.NODE_SHAPE, new Resource[0]));){
                List<NodeShape> list = stream.map(Statement::getSubject).map(shapeId -> {
                    ShaclProperties shaclProperties = new ShaclProperties((Resource)shapeId, connection);
                    if (shaclProperties.targetClass != null) {
                        return new TargetClass((Resource)shapeId, connection, shaclProperties.targetClass);
                    }
                    if (!shaclProperties.targetNode.isEmpty()) {
                        return new TargetNode((Resource)shapeId, connection, shaclProperties.targetNode);
                    }
                    if (sail.isUndefinedTargetValidatesAllSubjects()) {
                        return new NodeShape((Resource)shapeId, connection);
                    }
                    return null;
                }).filter(Objects::nonNull).collect(Collectors.toList());
                return list;
            }
        }
    }
}

