/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.rdf4j.common.iteration.Iterations;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.RDFS;
import org.eclipse.rdf4j.sail.shacl.ShaclSailConnection;

public class RdfsSubClassOfReasoner {
    private final Collection<Statement> subClassOfStatements = new ArrayList<Statement>();
    private final Collection<Resource> types = new ArrayList<Resource>();
    private final Map<Resource, Set<Resource>> forwardChainCache = new HashMap<Resource, Set<Resource>>();
    private final Map<Resource, Set<Resource>> backwardsChainCache = new HashMap<Resource, Set<Resource>>();

    public Stream<Statement> forwardChain(Statement statement) {
        if (this.forwardChainCache.isEmpty()) {
            return Stream.of(statement);
        }
        SimpleValueFactory vf = SimpleValueFactory.getInstance();
        if (statement.getPredicate().equals(RDF.TYPE) && this.forwardChainCache.containsKey((Resource)statement.getObject())) {
            return this.forwardChainCache.get(statement.getObject()).stream().map(r -> vf.createStatement(statement.getSubject(), RDF.TYPE, (Value)r, statement.getContext()));
        }
        return Stream.of(statement);
    }

    public Set<Resource> backwardsChain(Resource type) {
        if (this.backwardsChainCache.isEmpty()) {
            return Collections.emptySet();
        }
        Set<Resource> resources = this.backwardsChainCache.get(type);
        if (resources != null) {
            return resources;
        }
        return Collections.emptySet();
    }

    private void addSubClassOfStatement(Statement st) {
        this.subClassOfStatements.add(st);
        this.types.add(st.getSubject());
        this.types.add((Resource)st.getObject());
    }

    private void calculateSubClassOf(Collection<Statement> subClassOfStatements) {
        if (subClassOfStatements.isEmpty()) {
            return;
        }
        this.types.forEach(type -> {
            if (!this.forwardChainCache.containsKey(type)) {
                this.forwardChainCache.put((Resource)type, new HashSet());
            }
            if (!this.backwardsChainCache.containsKey(type)) {
                this.backwardsChainCache.put((Resource)type, new HashSet());
            }
            this.forwardChainCache.get(type).add((Resource)type);
            this.backwardsChainCache.get(type).add((Resource)type);
        });
        subClassOfStatements.forEach(s -> {
            Resource subClass = s.getSubject();
            Resource supClass = (Resource)s.getObject();
            if (!this.forwardChainCache.containsKey(subClass)) {
                this.forwardChainCache.put(subClass, new HashSet());
            }
            if (!this.backwardsChainCache.containsKey(supClass)) {
                this.backwardsChainCache.put(supClass, new HashSet());
            }
            this.forwardChainCache.get(subClass).add((Resource)s.getObject());
            this.backwardsChainCache.get(supClass).add(s.getSubject());
        });
        this.forwardChainUntilFixPoint(this.forwardChainCache);
        this.forwardChainUntilFixPoint(this.backwardsChainCache);
    }

    private void forwardChainUntilFixPoint(Map<Resource, Set<Resource>> forwardChainCache) {
        long prevSize = 0L;
        long[] newSize = new long[]{-1L};
        while (prevSize != newSize[0]) {
            prevSize = newSize[0];
            newSize[0] = 0L;
            forwardChainCache.forEach((key, value) -> {
                ArrayList temp = new ArrayList();
                value.forEach(superClass -> temp.addAll(this.resolveTypes((Resource)superClass, forwardChainCache)));
                value.addAll(temp);
                newSize[0] = newSize[0] + (long)value.size();
            });
        }
    }

    private Set<Resource> resolveTypes(Resource value, Map<Resource, Set<Resource>> forwardChainCache) {
        Set<Resource> iris = forwardChainCache.get(value);
        return iris != null ? iris : Collections.emptySet();
    }

    static RdfsSubClassOfReasoner createReasoner(ShaclSailConnection shaclSailConnection) {
        RdfsSubClassOfReasoner rdfsSubClassOfReasoner = new RdfsSubClassOfReasoner();
        try (Stream<? extends Statement> stream = Iterations.stream(shaclSailConnection.getStatements(null, RDFS.SUBCLASSOF, null, false, new Resource[0]));){
            stream.forEach(rdfsSubClassOfReasoner::addSubClassOfStatement);
        }
        rdfsSubClassOfReasoner.calculateSubClassOf(rdfsSubClassOfReasoner.subClassOfStatements);
        return rdfsSubClassOfReasoner;
    }
}

