/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.planNodes;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringEscapeUtils;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.algebra.BindingSetAssignment;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;
import org.eclipse.rdf4j.query.impl.ListBindingSet;
import org.eclipse.rdf4j.query.impl.MapBindingSet;
import org.eclipse.rdf4j.query.parser.ParsedQuery;
import org.eclipse.rdf4j.query.parser.QueryParserFactory;
import org.eclipse.rdf4j.query.parser.QueryParserRegistry;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.memory.MemoryStoreConnection;
import org.eclipse.rdf4j.sail.shacl.ShaclSailConnection;
import org.eclipse.rdf4j.sail.shacl.planNodes.IteratorData;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.Tuple;
import org.eclipse.rdf4j.sail.shacl.planNodes.TupleHelper;

public class BulkedExternalInnerJoin
implements PlanNode {
    private final SailConnection connection;
    private final PlanNode leftNode;
    private final ParsedQuery parsedQuery;
    private final boolean skipBasedOnPreviousConnection;
    private boolean printed = false;

    public BulkedExternalInnerJoin(PlanNode leftNode, SailConnection connection, String query, boolean skipBasedOnPreviousConnection) {
        this.leftNode = leftNode;
        QueryParserFactory queryParserFactory = (QueryParserFactory)QueryParserRegistry.getInstance().get(QueryLanguage.SPARQL).get();
        this.parsedQuery = queryParserFactory.getParser().parseQuery("select * where { VALUES (?a) {}" + query + "} order by ?a", null);
        this.connection = connection;
        this.skipBasedOnPreviousConnection = skipBasedOnPreviousConnection;
    }

    @Override
    public CloseableIteration<Tuple, SailException> iterator() {
        return new CloseableIteration<Tuple, SailException>(){
            LinkedList<Tuple> left = new LinkedList();
            LinkedList<Tuple> right = new LinkedList();
            CloseableIteration<Tuple, SailException> leftNodeIterator = BulkedExternalInnerJoin.access$000(BulkedExternalInnerJoin.this).iterator();

            private void calculateNext() {
                boolean empty;
                boolean bl = empty = !BulkedExternalInnerJoin.this.connection.hasStatement(null, null, null, true, new Resource[0]);
                if (empty) {
                    return;
                }
                if (!this.left.isEmpty()) {
                    return;
                }
                while (this.left.size() < 200 && this.leftNodeIterator.hasNext()) {
                    this.left.addFirst((Tuple)this.leftNodeIterator.next());
                }
                if (this.left.isEmpty()) {
                    return;
                }
                final List newBindindingset = this.left.stream().map(tuple -> tuple.line.get(0)).map(v -> (Resource)v).filter(r -> {
                    if (!BulkedExternalInnerJoin.this.skipBasedOnPreviousConnection) {
                        return true;
                    }
                    if (BulkedExternalInnerJoin.this.connection instanceof ShaclSailConnection) {
                        return ((ShaclSailConnection)BulkedExternalInnerJoin.this.connection).getPreviousStateConnection().hasStatement((Resource)r, null, null, true, new Resource[0]);
                    }
                    return true;
                }).map(r -> new ListBindingSet(Collections.singletonList("a"), Collections.singletonList(r))).collect(Collectors.toList());
                if (!newBindindingset.isEmpty()) {
                    try {
                        BulkedExternalInnerJoin.this.parsedQuery.getTupleExpr().visitChildren(new AbstractQueryModelVisitor<Exception>(){

                            @Override
                            public void meet(BindingSetAssignment node) throws Exception {
                                node.setBindingSets(newBindindingset);
                            }
                        });
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    try (CloseableIteration<? extends BindingSet, QueryEvaluationException> evaluate = BulkedExternalInnerJoin.this.connection.evaluate(BulkedExternalInnerJoin.this.parsedQuery.getTupleExpr(), BulkedExternalInnerJoin.this.parsedQuery.getDataset(), new MapBindingSet(), true);){
                        while (evaluate.hasNext()) {
                            BindingSet next = (BindingSet)evaluate.next();
                            this.right.addFirst(new Tuple(next));
                        }
                    }
                }
            }

            @Override
            public void close() throws SailException {
                this.leftNodeIterator.close();
            }

            @Override
            public boolean hasNext() throws SailException {
                this.calculateNext();
                return !this.left.isEmpty() && !this.right.isEmpty();
            }

            @Override
            public Tuple next() throws SailException {
                this.calculateNext();
                Tuple joined = null;
                while (joined == null) {
                    Tuple leftPeek = this.left.peekLast();
                    if (this.right.isEmpty()) continue;
                    Tuple rightPeek = this.right.peekLast();
                    if (rightPeek.line.get(0) == leftPeek.line.get(0) || rightPeek.line.get(0).equals(leftPeek.line.get(0))) {
                        joined = TupleHelper.join(leftPeek, rightPeek);
                        this.right.removeLast();
                        Tuple rightPeek2 = this.right.peekLast();
                        if (rightPeek2 != null && rightPeek2.line.get(0).equals(leftPeek.line.get(0))) continue;
                        this.left.removeLast();
                        continue;
                    }
                    int compare = rightPeek.line.get(0).stringValue().compareTo(leftPeek.line.get(0).stringValue());
                    if (compare < 0) {
                        if (this.right.isEmpty()) {
                            throw new IllegalStateException();
                        }
                        this.right.removeLast();
                        continue;
                    }
                    if (this.left.isEmpty()) {
                        throw new IllegalStateException();
                    }
                    this.left.removeLast();
                }
                return joined;
            }

            @Override
            public void remove() throws SailException {
            }
        };
    }

    @Override
    public int depth() {
        return this.leftNode.depth() + 1;
    }

    @Override
    public void getPlanAsGraphvizDot(StringBuilder stringBuilder) {
        if (this.printed) {
            return;
        }
        this.printed = true;
        stringBuilder.append(this.getId() + " [label=\"" + StringEscapeUtils.escapeJava((String)this.toString()) + "\"];").append("\n");
        stringBuilder.append(this.leftNode.getId() + " -> " + this.getId() + " [label=\"left\"]").append("\n");
        if (this.connection instanceof MemoryStoreConnection) {
            stringBuilder.append(System.identityHashCode(((MemoryStoreConnection)this.connection).getSail()) + " -> " + this.getId() + " [label=\"right\"]").append("\n");
        } else {
            stringBuilder.append(System.identityHashCode(this.connection) + " -> " + this.getId() + " [label=\"right\"]").append("\n");
        }
        this.leftNode.getPlanAsGraphvizDot(stringBuilder);
    }

    public String toString() {
        return "BulkedExternalInnerJoin{parsedQuery=" + this.parsedQuery.getSourceString() + '}';
    }

    @Override
    public String getId() {
        return System.identityHashCode(this) + "";
    }

    @Override
    public IteratorData getIteratorDataType() {
        return this.leftNode.getIteratorDataType();
    }

    static /* synthetic */ PlanNode access$000(BulkedExternalInnerJoin x0) {
        return x0.leftNode;
    }
}

