/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.planNodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.shacl.planNodes.IteratorData;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.Tuple;

public class Sort
implements PlanNode {
    private final PlanNode parent;
    private boolean printed = false;

    public Sort(PlanNode parent) {
        this.parent = parent;
    }

    @Override
    public CloseableIteration<Tuple, SailException> iterator() {
        return new CloseableIteration<Tuple, SailException>(){
            CloseableIteration<Tuple, SailException> iterator;
            List<Tuple> sortedTuples;
            Iterator<Tuple> sortedTuplesIterator;
            {
                this.iterator = Sort.this.parent.iterator();
            }

            @Override
            public void close() throws SailException {
                this.iterator.close();
            }

            @Override
            public boolean hasNext() throws SailException {
                this.sortTuples();
                return this.sortedTuplesIterator.hasNext();
            }

            private void sortTuples() {
                if (this.sortedTuples == null) {
                    this.sortedTuples = new ArrayList<Tuple>();
                    while (this.iterator.hasNext()) {
                        this.sortedTuples.add((Tuple)this.iterator.next());
                    }
                    Collections.sort(this.sortedTuples, Comparator.comparing(a -> a.line.get(0).stringValue()));
                    this.sortedTuplesIterator = this.sortedTuples.iterator();
                }
            }

            @Override
            public Tuple next() throws SailException {
                this.sortTuples();
                return this.sortedTuplesIterator.next();
            }

            @Override
            public void remove() throws SailException {
            }
        };
    }

    @Override
    public int depth() {
        return this.parent.depth() + 1;
    }

    @Override
    public void getPlanAsGraphvizDot(StringBuilder stringBuilder) {
        if (this.printed) {
            return;
        }
        this.printed = true;
        stringBuilder.append(this.getId() + " [label=\"" + StringEscapeUtils.escapeJava((String)this.toString()) + "\"];").append("\n");
        stringBuilder.append(this.parent.getId() + " -> " + this.getId()).append("\n");
        this.parent.getPlanAsGraphvizDot(stringBuilder);
    }

    @Override
    public String getId() {
        return System.identityHashCode(this) + "";
    }

    public String toString() {
        return "Sort";
    }

    @Override
    public IteratorData getIteratorDataType() {
        return this.parent.getIteratorDataType();
    }
}

