/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.parser.serql;

import java.util.Iterator;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.algebra.Compare;
import org.eclipse.rdf4j.query.parser.serql.AbstractASTVisitor;
import org.eclipse.rdf4j.query.parser.serql.ast.ASTBooleanConstant;
import org.eclipse.rdf4j.query.parser.serql.ast.ASTBooleanExpr;
import org.eclipse.rdf4j.query.parser.serql.ast.ASTBound;
import org.eclipse.rdf4j.query.parser.serql.ast.ASTCompare;
import org.eclipse.rdf4j.query.parser.serql.ast.ASTNot;
import org.eclipse.rdf4j.query.parser.serql.ast.ASTNull;
import org.eclipse.rdf4j.query.parser.serql.ast.ASTProjectionElem;
import org.eclipse.rdf4j.query.parser.serql.ast.ASTQueryContainer;
import org.eclipse.rdf4j.query.parser.serql.ast.ASTSelect;
import org.eclipse.rdf4j.query.parser.serql.ast.ASTValueExpr;
import org.eclipse.rdf4j.query.parser.serql.ast.ASTVar;
import org.eclipse.rdf4j.query.parser.serql.ast.Node;
import org.eclipse.rdf4j.query.parser.serql.ast.VisitorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NullProcessor {
    NullProcessor() {
    }

    public static void process(ASTQueryContainer qc) throws MalformedQueryException {
        NullVisitor visitor = new NullVisitor();
        try {
            qc.jjtAccept(visitor, null);
        }
        catch (VisitorException e) {
            throw new MalformedQueryException(e.getMessage(), e);
        }
    }

    private static class NullVisitor
    extends AbstractASTVisitor {
        protected final Logger logger = LoggerFactory.getLogger(this.getClass());

        @Override
        public Object visit(ASTSelect selectNode, Object data) throws VisitorException {
            Iterator<Node> iter = selectNode.jjtGetChildren().iterator();
            while (iter.hasNext()) {
                ASTProjectionElem pe = (ASTProjectionElem)iter.next();
                if (!(pe.getValueExpr() instanceof ASTNull)) continue;
                this.logger.warn("Use of NULL values in SeRQL queries has been deprecated");
                iter.remove();
            }
            return null;
        }

        @Override
        public Object visit(ASTCompare compareNode, Object data) throws VisitorException {
            block8: {
                Compare.CompareOp operator;
                boolean rightIsNull;
                boolean leftIsNull;
                block7: {
                    leftIsNull = compareNode.getLeftOperand() instanceof ASTNull;
                    rightIsNull = compareNode.getRightOperand() instanceof ASTNull;
                    operator = compareNode.getOperator().getValue();
                    if (!leftIsNull || !rightIsNull) break block7;
                    switch (operator) {
                        case EQ: {
                            this.logger.warn("Use of NULL values in SeRQL queries has been deprecated, use BOUND(...) instead");
                            compareNode.jjtReplaceWith(new ASTBooleanConstant(true));
                            break block8;
                        }
                        case NE: {
                            this.logger.warn("Use of NULL values in SeRQL queries has been deprecated, use BOUND(...) instead");
                            compareNode.jjtReplaceWith(new ASTBooleanConstant(false));
                            break block8;
                        }
                        default: {
                            throw new VisitorException("Use of NULL values in SeRQL queries has been deprecated, use BOUND(...) instead");
                        }
                    }
                }
                if (leftIsNull || rightIsNull) {
                    ASTValueExpr valueOperand = leftIsNull ? compareNode.getRightOperand() : compareNode.getLeftOperand();
                    if (valueOperand instanceof ASTVar && operator == Compare.CompareOp.EQ || operator == Compare.CompareOp.NE) {
                        ASTBooleanExpr replacementNode = new ASTBound(valueOperand);
                        if (operator == Compare.CompareOp.EQ) {
                            replacementNode = new ASTNot(replacementNode);
                        }
                        compareNode.jjtReplaceWith(replacementNode);
                        return null;
                    }
                    throw new VisitorException("Use of NULL values in SeRQL queries has been deprecated, use BOUND(...) instead");
                }
            }
            return null;
        }

        @Override
        public Object visit(ASTNull nullNode, Object data) throws VisitorException {
            throw new VisitorException("Use of NULL values in SeRQL queries has been deprecated, use BOUND(...) instead");
        }
    }
}

