/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.queryrender.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.algebra.And;
import org.eclipse.rdf4j.query.algebra.BinaryTupleOperator;
import org.eclipse.rdf4j.query.algebra.Distinct;
import org.eclipse.rdf4j.query.algebra.EmptySet;
import org.eclipse.rdf4j.query.algebra.Extension;
import org.eclipse.rdf4j.query.algebra.ExtensionElem;
import org.eclipse.rdf4j.query.algebra.Filter;
import org.eclipse.rdf4j.query.algebra.Join;
import org.eclipse.rdf4j.query.algebra.LeftJoin;
import org.eclipse.rdf4j.query.algebra.MultiProjection;
import org.eclipse.rdf4j.query.algebra.Order;
import org.eclipse.rdf4j.query.algebra.OrderElem;
import org.eclipse.rdf4j.query.algebra.Projection;
import org.eclipse.rdf4j.query.algebra.ProjectionElem;
import org.eclipse.rdf4j.query.algebra.ProjectionElemList;
import org.eclipse.rdf4j.query.algebra.Reduced;
import org.eclipse.rdf4j.query.algebra.Slice;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.UnaryTupleOperator;
import org.eclipse.rdf4j.query.algebra.ValueConstant;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.helpers.StatementPatternCollector;
import org.eclipse.rdf4j.query.algebra.helpers.VarNameCollector;
import org.eclipse.rdf4j.query.impl.SimpleDataset;
import org.eclipse.rdf4j.query.parser.ParsedGraphQuery;
import org.eclipse.rdf4j.query.parser.ParsedQuery;
import org.eclipse.rdf4j.query.parser.ParsedTupleQuery;
import org.eclipse.rdf4j.queryrender.builder.Group;
import org.eclipse.rdf4j.queryrender.builder.GroupBuilder;
import org.eclipse.rdf4j.queryrender.builder.QueryBuilder;

@Deprecated
public class AbstractQueryBuilder<T extends ParsedQuery>
implements QueryBuilder<T> {
    protected List<StatementPattern> mProjectionPatterns = new ArrayList<StatementPattern>();
    protected List<String> mProjectionVars = new ArrayList<String>();
    private List<Group> mQueryAtoms = new ArrayList<Group>();
    private List<OrderElem> mOrderByElems = new ArrayList<OrderElem>();
    private int mLimit = -1;
    private int mOffset = -1;
    private boolean mDistinct = false;
    private boolean mReduced = false;
    private Set<IRI> mFrom = new HashSet<IRI>();
    private Set<IRI> mFromNamed = new HashSet<IRI>();
    private T mQuery;

    AbstractQueryBuilder(T theQuery) {
        this.mQuery = theQuery;
    }

    @Override
    public void reset() {
        this.mReduced = false;
        this.mDistinct = false;
        this.mOffset = -1;
        this.mLimit = -1;
        this.mProjectionVars.clear();
        this.mQueryAtoms.clear();
        this.mProjectionPatterns.clear();
    }

    @Override
    public T query() {
        AbstractQueryModelVisitor aCollector;
        UnaryTupleOperator aRoot = null;
        UnaryTupleOperator aCurr = null;
        if (this.mLimit != -1 || this.mOffset != -1) {
            Slice aSlice = new Slice();
            if (this.mLimit != -1) {
                aSlice.setLimit(this.mLimit);
            }
            if (this.mOffset != -1) {
                aSlice.setOffset(this.mOffset);
            }
            aCurr = aSlice;
            aRoot = aCurr;
        }
        if (this.mOrderByElems != null && !this.mOrderByElems.isEmpty()) {
            Order aOrder = new Order();
            aOrder.addElements(this.mOrderByElems);
            if (aRoot == null) {
                aCurr = aOrder;
                aRoot = aCurr;
            } else {
                aCurr.setArg(aOrder);
                aCurr = aOrder;
            }
        }
        if (this.mDistinct) {
            Distinct aDistinct = new Distinct();
            if (aRoot == null) {
                aCurr = aDistinct;
                aRoot = aCurr;
            } else {
                aCurr.setArg(aDistinct);
                aCurr = aDistinct;
            }
        }
        if (this.mReduced) {
            Reduced aReduced = new Reduced();
            if (aRoot == null) {
                aCurr = aReduced;
                aRoot = aCurr;
            } else {
                aCurr.setArg(aReduced);
                aCurr = aReduced;
            }
        }
        TupleExpr aJoin = this.join();
        if (this.mQuery instanceof ParsedTupleQuery && this.mProjectionVars.isEmpty()) {
            aCollector = new VarNameCollector();
            aJoin.visit(aCollector);
            this.mProjectionVars.addAll(((VarNameCollector)aCollector).getVarNames());
        } else if (this.mQuery instanceof ParsedGraphQuery && this.mProjectionPatterns.isEmpty()) {
            aCollector = new StatementPatternCollector();
            aJoin.visit(aCollector);
            this.mProjectionPatterns.addAll(((StatementPatternCollector)aCollector).getStatementPatterns());
        }
        UnaryTupleOperator aProjection = this.projection();
        if (aRoot == null) {
            aCurr = aProjection;
            aRoot = aCurr;
        } else {
            aCurr.setArg(aProjection);
        }
        aCurr = aProjection.getArg() == null ? aProjection : (UnaryTupleOperator)aProjection.getArg();
        if (aJoin != null) {
            aCurr.setArg(aJoin);
        }
        ((ParsedQuery)this.mQuery).setTupleExpr(aRoot);
        if (!this.mFrom.isEmpty() || !this.mFromNamed.isEmpty()) {
            SimpleDataset aDataset = new SimpleDataset();
            for (IRI aFrom : this.mFrom) {
                aDataset.addDefaultGraph(aFrom);
            }
            for (IRI aFrom : this.mFromNamed) {
                aDataset.addNamedGraph(aFrom);
            }
            ((ParsedQuery)this.mQuery).setDataset(aDataset);
        }
        return this.mQuery;
    }

    @Override
    public QueryBuilder<T> fromNamed(IRI theURI) {
        this.mFromNamed.add(theURI);
        return this;
    }

    @Override
    public QueryBuilder<T> from(IRI theURI) {
        this.mFrom.add(theURI);
        return this;
    }

    @Override
    public QueryBuilder<T> distinct() {
        if (this.isSelect()) {
            this.mDistinct = true;
        }
        return this;
    }

    @Override
    public QueryBuilder<T> reduced() {
        this.mReduced = true;
        return this;
    }

    @Override
    public QueryBuilder<T> addProjectionVar(String ... theNames) {
        if (this.isSelect()) {
            this.mProjectionVars.addAll(Arrays.asList(theNames));
        }
        return this;
    }

    private boolean isConstruct() {
        return this.mQuery instanceof ParsedGraphQuery;
    }

    private boolean isSelect() {
        return this.mQuery instanceof ParsedTupleQuery;
    }

    @Override
    public QueryBuilder<T> addProjectionStatement(String theSubj, String thePred, String theObj) {
        if (this.isConstruct()) {
            this.mProjectionPatterns.add(new StatementPattern(new Var(theSubj), new Var(thePred), new Var(theObj)));
        }
        return this;
    }

    public QueryBuilder<T> addProjectionStatement(String theSubj, Value thePred, Value theObj) {
        if (this.isConstruct()) {
            this.mProjectionPatterns.add(new StatementPattern(new Var(theSubj), GroupBuilder.valueToVar(thePred), GroupBuilder.valueToVar(theObj)));
        }
        return this;
    }

    @Override
    public QueryBuilder<T> addProjectionStatement(String theSubj, String thePred, Value theObj) {
        if (this.isConstruct()) {
            this.mProjectionPatterns.add(new StatementPattern(new Var(theSubj), new Var(thePred), GroupBuilder.valueToVar(theObj)));
        }
        return this;
    }

    @Override
    public QueryBuilder<T> addProjectionStatement(String theSubj, IRI thePred, Value theObj) {
        if (this.isConstruct()) {
            this.mProjectionPatterns.add(new StatementPattern(new Var(theSubj), GroupBuilder.valueToVar(thePred), GroupBuilder.valueToVar(theObj)));
        }
        return this;
    }

    @Override
    public QueryBuilder<T> addProjectionStatement(IRI theSubj, String thePred, String theObj) {
        if (this.isConstruct()) {
            this.mProjectionPatterns.add(new StatementPattern(GroupBuilder.valueToVar(theSubj), new Var(thePred), new Var(theObj)));
        }
        return this;
    }

    @Override
    public QueryBuilder<T> addProjectionStatement(IRI theSubj, IRI thePred, String theObj) {
        if (this.isConstruct()) {
            this.mProjectionPatterns.add(new StatementPattern(GroupBuilder.valueToVar(theSubj), GroupBuilder.valueToVar(thePred), new Var(theObj)));
        }
        return this;
    }

    @Override
    public QueryBuilder<T> addProjectionStatement(String theSubj, IRI thePred, String theObj) {
        if (this.isConstruct()) {
            this.mProjectionPatterns.add(new StatementPattern(new Var(theSubj), GroupBuilder.valueToVar(thePred), new Var(theObj)));
        }
        return this;
    }

    private TupleExpr join() {
        if (this.mQueryAtoms.isEmpty()) {
            throw new RuntimeException("Can't have an empty or missing join.");
        }
        if (this.mQueryAtoms.size() == 1) {
            return this.mQueryAtoms.get(0).expr();
        }
        return this.groupAsJoin(this.mQueryAtoms);
    }

    private UnaryTupleOperator projection() {
        if (!this.mProjectionPatterns.isEmpty()) {
            return this.multiProjection();
        }
        TupleExpr aExt = null;
        ProjectionElemList aList = new ProjectionElemList();
        for (String aVar : this.mProjectionVars) {
            aList.addElement(new ProjectionElem(aVar));
        }
        Projection aProjection = new Projection();
        aProjection.setProjectionElemList(aList);
        if (aExt != null) {
            aProjection.setArg(aExt);
        }
        return aProjection;
    }

    private UnaryTupleOperator multiProjection() {
        MultiProjection aProjection = new MultiProjection();
        Extension aExt = null;
        for (StatementPattern aPattern : this.mProjectionPatterns) {
            ProjectionElemList aList = new ProjectionElemList();
            aList.addElement(new ProjectionElem(aPattern.getSubjectVar().getName(), "subject"));
            aList.addElement(new ProjectionElem(aPattern.getPredicateVar().getName(), "predicate"));
            aList.addElement(new ProjectionElem(aPattern.getObjectVar().getName(), "object"));
            if (aPattern.getSubjectVar().hasValue()) {
                if (aExt == null) {
                    aExt = new Extension();
                }
                aExt.addElements(new ExtensionElem(new ValueConstant(aPattern.getSubjectVar().getValue()), aPattern.getSubjectVar().getName()));
            }
            if (aPattern.getPredicateVar().hasValue()) {
                if (aExt == null) {
                    aExt = new Extension();
                }
                aExt.addElements(new ExtensionElem(new ValueConstant(aPattern.getPredicateVar().getValue()), aPattern.getPredicateVar().getName()));
            }
            if (aPattern.getObjectVar().hasValue()) {
                if (aExt == null) {
                    aExt = new Extension();
                }
                aExt.addElements(new ExtensionElem(new ValueConstant(aPattern.getObjectVar().getValue()), aPattern.getObjectVar().getName()));
            }
            aProjection.addProjection(aList);
        }
        if (aExt != null) {
            aProjection.setArg(aExt);
        }
        return aProjection;
    }

    @Override
    public GroupBuilder<T, QueryBuilder<T>> group() {
        return new GroupBuilder(this, false, null);
    }

    @Override
    public GroupBuilder<T, QueryBuilder<T>> optional() {
        return new GroupBuilder(this, true, null);
    }

    @Override
    public QueryBuilder<T> limit(int theLimit) {
        this.mLimit = theLimit;
        return this;
    }

    @Override
    public QueryBuilder<T> offset(int theOffset) {
        this.mOffset = theOffset;
        return this;
    }

    public QueryBuilder<T> addGroup(Group theGroup) {
        this.mQueryAtoms.add(theGroup);
        return this;
    }

    public QueryBuilder<T> removeGroup(Group theGroup) {
        this.mQueryAtoms.remove(theGroup);
        return this;
    }

    private TupleExpr groupAsJoin(List<Group> theList) {
        BinaryTupleOperator aJoin = new Join();
        UnaryTupleOperator aFilter = null;
        for (Group aGroup : theList) {
            TupleExpr aExpr = aGroup.expr();
            if (aExpr == null) continue;
            if (aExpr instanceof Filter && (((Filter)aExpr).getArg() == null || ((Filter)aExpr).getArg() instanceof EmptySet)) {
                if (aFilter == null) {
                    aFilter = (Filter)aExpr;
                    continue;
                }
                ((Filter)aFilter).setCondition(new And(((Filter)aFilter).getCondition(), ((Filter)aExpr).getCondition()));
                continue;
            }
            if (aFilter != null) {
                aFilter.setArg(aExpr);
                aExpr = aFilter;
                aFilter = null;
            }
            if (aGroup.isOptional()) {
                LeftJoin lj = new LeftJoin();
                TupleExpr aLeft = this.joinOrExpr(aJoin);
                if (aLeft != null) {
                    lj.setLeftArg(aLeft);
                    lj.setRightArg(aExpr);
                    aJoin = lj;
                    continue;
                }
            }
            if (aJoin.getLeftArg() == null) {
                aJoin.setLeftArg(aExpr);
                continue;
            }
            if (aJoin.getRightArg() == null) {
                aJoin.setRightArg(aExpr);
                continue;
            }
            Join aNewJoin = new Join();
            aNewJoin.setLeftArg(aJoin);
            aNewJoin.setRightArg(aExpr);
            aJoin = aNewJoin;
        }
        TupleExpr aExpr = this.joinOrExpr(aJoin);
        if (aFilter != null) {
            aFilter.setArg(aExpr);
            aExpr = aFilter;
        }
        return aExpr;
    }

    private TupleExpr joinOrExpr(BinaryTupleOperator theExpr) {
        if (theExpr.getLeftArg() != null && theExpr.getRightArg() == null) {
            return theExpr.getLeftArg();
        }
        if (theExpr.getLeftArg() == null && theExpr.getRightArg() != null) {
            return theExpr.getRightArg();
        }
        if (theExpr.getLeftArg() == null && theExpr.getRightArg() == null) {
            return null;
        }
        return theExpr;
    }

    @Override
    public QueryBuilder<T> orderBy(String ... theNames) {
        return this.orderByAsc(theNames);
    }

    @Override
    public QueryBuilder<T> orderByAsc(String ... theNames) {
        if (theNames != null) {
            for (String aName : theNames) {
                this.mOrderByElems.add(new OrderElem(new Var(aName), true));
            }
        }
        return this;
    }

    @Override
    public QueryBuilder<T> orderByDesc(String ... theNames) {
        if (theNames != null) {
            for (String aName : theNames) {
                this.mOrderByElems.add(new OrderElem(new Var(aName), false));
            }
        }
        return this;
    }
}

