/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.AST;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.shacl.AST.NodeShape;
import org.eclipse.rdf4j.sail.shacl.AST.PlaneNodeWrapper;
import org.eclipse.rdf4j.sail.shacl.ConnectionsGroup;
import org.eclipse.rdf4j.sail.shacl.RdfsSubClassOfReasoner;
import org.eclipse.rdf4j.sail.shacl.ShaclSail;
import org.eclipse.rdf4j.sail.shacl.Stats;
import org.eclipse.rdf4j.sail.shacl.planNodes.BulkedExternalInnerJoin;
import org.eclipse.rdf4j.sail.shacl.planNodes.EmptyNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.ExternalFilterByQuery;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNodeProvider;
import org.eclipse.rdf4j.sail.shacl.planNodes.Select;
import org.eclipse.rdf4j.sail.shacl.planNodes.Sort;
import org.eclipse.rdf4j.sail.shacl.planNodes.TrimTuple;
import org.eclipse.rdf4j.sail.shacl.planNodes.UnBufferedPlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.UnionNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.Unique;
import org.eclipse.rdf4j.sail.shacl.planNodes.UnorderedSelect;

public class TargetShape
extends NodeShape {
    NodeShape targetShape;
    List<StatementPattern> statementPatternList;
    String query;

    TargetShape(Resource id, ShaclSail shaclSail, SailRepositoryConnection connection, boolean deactivated, Resource targetShape) {
        super(id, shaclSail, connection, deactivated);
        if (connection.hasStatement(targetShape, SHACL.PATH, null, false, new Resource[0])) {
            throw new UnsupportedOperationException("Experimental rsx:targetShape support only supports sh:NodeShape and not sh:PropertyShape");
        }
        this.targetShape = new NodeShape(targetShape, shaclSail, connection, false);
        this.statementPatternList = this.targetShape.getStatementPatterns().collect(Collectors.toList());
        this.query = this.targetShape.buildSparqlValidNodes("?a");
        assert (!this.statementPatternList.isEmpty());
    }

    @Override
    public PlanNode getPlan(ConnectionsGroup connectionsGroup, boolean printPlans, PlanNodeProvider overrideTargetNode, boolean negateThisPlan, boolean negateSubPlans) {
        assert (!negateSubPlans) : "There are no subplans!";
        assert (!negateThisPlan);
        Select select = new Select(connectionsGroup.getBaseConnection(), this.getQuery("?a", null, null), "?a");
        return connectionsGroup.getCachedNodeFor(select);
    }

    @Override
    public PlanNode getPlanAddedStatements(ConnectionsGroup connectionsGroup, PlaneNodeWrapper planeNodeWrapper) {
        assert (planeNodeWrapper == null);
        return this.getInnerPlanRemovedOrAdded(connectionsGroup, connectionsGroup.getAddedStatements());
    }

    @Override
    public PlanNode getPlanRemovedStatements(ConnectionsGroup connectionsGroup, PlaneNodeWrapper planeNodeWrapper) {
        assert (planeNodeWrapper == null);
        return this.getInnerPlanRemovedOrAdded(connectionsGroup, connectionsGroup.getRemovedStatements());
    }

    private PlanNode getInnerPlanRemovedOrAdded(ConnectionsGroup connectionsGroup, SailConnection removedStatements) {
        PlanNode allPotentialTargetsFromTransaction = new EmptyNode();
        for (StatementPattern statementPattern : this.statementPatternList) {
            TrimTuple statementsThatMatchPattern = new TrimTuple(new UnorderedSelect(removedStatements, null, (IRI)statementPattern.getPredicateVar().getValue(), statementPattern.getObjectVar().getValue(), UnorderedSelect.OutputPattern.SubjectPredicateObject), 0, 1);
            allPotentialTargetsFromTransaction = new UnionNode(allPotentialTargetsFromTransaction, statementsThatMatchPattern);
        }
        allPotentialTargetsFromTransaction = new Unique(new Sort(allPotentialTargetsFromTransaction));
        PlanNode allTargetsThatReallyAreTargets = new BulkedExternalInnerJoin(allPotentialTargetsFromTransaction, connectionsGroup.getBaseConnection(), this.query, false, null, "?a");
        allTargetsThatReallyAreTargets = new Unique(new TrimTuple(allTargetsThatReallyAreTargets, 0, 1));
        return allTargetsThatReallyAreTargets;
    }

    @Override
    public boolean requiresEvaluation(SailConnection addedStatements, SailConnection removedStatements, Stats stats) {
        return !stats.isEmpty();
    }

    @Override
    public String getQuery(String subjectVariable, String objectVariable, RdfsSubClassOfReasoner rdfsSubClassOfReasoner) {
        return this.targetShape.buildSparqlValidNodes(subjectVariable);
    }

    @Override
    public PlanNode getTargetFilter(ConnectionsGroup connectionsGroup, PlanNode parent) {
        return new ExternalFilterByQuery(connectionsGroup.getBaseConnection(), parent, 0, this.getQuery("?a", null, null), "?a").getTrueNode(UnBufferedPlanNode.class);
    }

    @Override
    public String toString() {
        return "TargetShape{targetShape=" + this.targetShape + ", id=" + this.id + '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TargetShape that = (TargetShape)o;
        return Objects.equals(this.targetShape, that.targetShape);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.targetShape);
    }
}

