/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.evaluation;

import org.eclipse.rdf4j.federated.EndpointManager;
import org.eclipse.rdf4j.federated.endpoint.Endpoint;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.AbstractFederatedServiceResolver;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.FederatedService;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.FederatedServiceResolver;
import org.eclipse.rdf4j.repository.sparql.federation.RepositoryFederatedService;
import org.eclipse.rdf4j.repository.sparql.federation.SPARQLServiceResolver;

public class DelegateFederatedServiceResolver
extends AbstractFederatedServiceResolver
implements FederatedServiceResolver {
    private final EndpointManager endpointManager;
    private SPARQLServiceResolver defaultImpl;
    private FederatedServiceResolver delegate;

    public DelegateFederatedServiceResolver(EndpointManager endpointManager) {
        this.endpointManager = endpointManager;
    }

    public void initialize() {
        if (this.delegate == null) {
            this.defaultImpl = new SPARQLServiceResolver();
            this.delegate = this.defaultImpl;
        }
    }

    @Override
    public void shutDown() {
        super.shutDown();
        if (this.defaultImpl != null) {
            this.defaultImpl.shutDown();
        }
    }

    public void setDelegate(FederatedServiceResolver federatedServiceResolver) {
        if (this.delegate != null) {
            throw new IllegalStateException("Delegate already initialized.");
        }
        this.delegate = federatedServiceResolver;
    }

    @Override
    public FederatedService getService(String serviceUrl) throws QueryEvaluationException {
        if (this.isFedXEndpoint(serviceUrl)) {
            return super.getService(serviceUrl);
        }
        return this.delegate.getService(serviceUrl);
    }

    @Override
    protected FederatedService createService(String serviceUrl) throws QueryEvaluationException {
        Endpoint ep = this.getFedXEndpoint(serviceUrl);
        if (ep != null) {
            return new RepositoryFederatedService(ep.getRepository(), false);
        }
        throw new IllegalStateException("External service URL should be managed by delegate.");
    }

    protected boolean isFedXEndpoint(String serviceUrl) {
        return this.getFedXEndpoint(serviceUrl) != null;
    }

    private Endpoint getFedXEndpoint(String serviceUri) {
        Endpoint e = this.endpointManager.getEndpointByUrl(serviceUri);
        if (e != null) {
            return e;
        }
        e = this.endpointManager.getEndpointByName(serviceUri);
        return e;
    }
}

