/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.repository;

import java.util.Collection;
import java.util.Set;
import org.eclipse.rdf4j.federated.FedXConfig;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.impl.TreeModel;
import org.eclipse.rdf4j.model.util.ModelException;
import org.eclipse.rdf4j.model.util.Models;
import org.eclipse.rdf4j.repository.config.AbstractRepositoryImplConfig;
import org.eclipse.rdf4j.repository.config.RepositoryConfigException;

public class FedXRepositoryConfig
extends AbstractRepositoryImplConfig {
    private static final ValueFactory vf = SimpleValueFactory.getInstance();
    public static final String NAMESPACE = "http://rdf4j.org/config/federation#";
    public static final IRI DATA_CONFIG = vf.createIRI("http://rdf4j.org/config/federation#", "dataConfig");
    public static final IRI MEMBER = vf.createIRI("http://rdf4j.org/config/federation#", "member");
    @Deprecated
    private String fedxConfig;
    private String dataConfig;
    private Model members;
    private FedXConfig config;

    public FedXRepositoryConfig() {
        super("fedx:FedXRepository");
    }

    @Deprecated
    public String getFedxConfig() {
        return this.fedxConfig;
    }

    @Deprecated
    public void setFedxConfig(String fedxConfig) {
        this.fedxConfig = fedxConfig;
    }

    public String getDataConfig() {
        return this.dataConfig;
    }

    public void setDataConfig(String dataConfig) {
        this.dataConfig = dataConfig;
    }

    public Model getMembers() {
        return this.members;
    }

    public void setMembers(Model members) {
        this.members = members;
    }

    public FedXConfig getConfig() {
        return this.config;
    }

    public void setConfig(FedXConfig config) {
        this.config = config;
    }

    public Resource export(Model m) {
        Resource implNode = super.export(m);
        m.setNamespace("fedx", NAMESPACE);
        if (this.getDataConfig() != null) {
            m.add(implNode, DATA_CONFIG, (Value)vf.createLiteral(this.getDataConfig()), new Resource[0]);
        }
        if (this.getMembers() != null) {
            Model members = this.getMembers();
            Set memberNodes = members.subjects();
            for (Resource memberNode : memberNodes) {
                m.add(implNode, MEMBER, (Value)memberNode, new Resource[0]);
                m.addAll((Collection)members.filter(memberNode, null, null, new Resource[0]));
            }
        }
        return implNode;
    }

    public void validate() throws RepositoryConfigException {
        super.validate();
        if (this.getMembers() == null && this.getDataConfig() == null && this.getFedxConfig() == null) {
            throw new RepositoryConfigException("At least one of fedxConfig or dataConfig needs to be provided to initialize the federation, if no explicit members are defined");
        }
    }

    public void parse(Model m, Resource implNode) throws RepositoryConfigException {
        super.parse(m, implNode);
        try {
            Models.objectLiteral((Iterable)m.getStatements(implNode, DATA_CONFIG, null, new Resource[0])).ifPresent(value -> this.setDataConfig(value.stringValue()));
            Set memberNodes = m.filter(implNode, MEMBER, null, new Resource[0]).objects();
            if (!memberNodes.isEmpty()) {
                TreeModel members = new TreeModel();
                for (Value memberNode : memberNodes) {
                    if (!(memberNode instanceof Resource)) {
                        throw new RepositoryConfigException("Member nodes must be of type resource, was " + memberNode);
                    }
                    members.addAll((Collection)m.filter((Resource)memberNode, null, null, new Resource[0]));
                }
                this.members = members;
            }
        }
        catch (ModelException e) {
            throw new RepositoryConfigException(e.getMessage(), (Throwable)e);
        }
    }
}

