/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.spin;

import org.eclipse.rdf4j.RDF4JException;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.vocabulary.FN;
import org.eclipse.rdf4j.model.vocabulary.SPIF;
import org.eclipse.rdf4j.model.vocabulary.SPIN;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.algebra.FunctionCall;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryOptimizer;
import org.eclipse.rdf4j.query.algebra.evaluation.TripleSource;
import org.eclipse.rdf4j.query.algebra.evaluation.function.Function;
import org.eclipse.rdf4j.query.algebra.evaluation.function.FunctionRegistry;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;
import org.eclipse.rdf4j.spin.SpinParser;
import org.eclipse.rdf4j.spin.function.AskFunction;
import org.eclipse.rdf4j.spin.function.Concat;
import org.eclipse.rdf4j.spin.function.EvalFunction;
import org.eclipse.rdf4j.spin.function.spif.CanInvoke;
import org.eclipse.rdf4j.spin.function.spif.ConvertSpinRDFToString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpinFunctionInterpreter
implements QueryOptimizer {
    private static final Logger logger = LoggerFactory.getLogger(SpinFunctionInterpreter.class);
    private final TripleSource tripleSource;
    private final SpinParser parser;
    private final FunctionRegistry functionRegistry;

    static void registerSpinParsingFunctions(SpinParser parser, FunctionRegistry functionRegistry) {
        if (!(functionRegistry.get((Object)FN.CONCAT.toString()).get() instanceof Concat)) {
            functionRegistry.add((Object)new Concat());
        }
        if (!functionRegistry.has((Object)SPIN.EVAL_FUNCTION.toString())) {
            functionRegistry.add((Object)new EvalFunction(parser));
        }
        if (!functionRegistry.has((Object)SPIN.ASK_FUNCTION.toString())) {
            functionRegistry.add((Object)new AskFunction(parser));
        }
        if (!functionRegistry.has((Object)SPIF.CONVERT_SPIN_RDF_TO_STRING_FUNCTION.toString())) {
            functionRegistry.add((Object)new ConvertSpinRDFToString(parser));
        }
        if (!functionRegistry.has((Object)SPIF.CAN_INVOKE_FUNCTION.toString())) {
            functionRegistry.add((Object)new CanInvoke(parser));
        }
    }

    public SpinFunctionInterpreter(SpinParser parser, TripleSource tripleSource, FunctionRegistry functionRegistry) {
        this.parser = parser;
        this.tripleSource = tripleSource;
        this.functionRegistry = functionRegistry;
    }

    public void optimize(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings) {
        try {
            tupleExpr.visit((QueryModelVisitor)new FunctionScanner());
        }
        catch (RDF4JException e) {
            logger.warn("Failed to parse function");
        }
    }

    private class FunctionScanner
    extends AbstractQueryModelVisitor<RDF4JException> {
        ValueFactory vf;

        private FunctionScanner() {
            this.vf = SpinFunctionInterpreter.this.tripleSource.getValueFactory();
        }

        public void meet(FunctionCall node) throws RDF4JException {
            String name = node.getURI();
            if (!SpinFunctionInterpreter.this.functionRegistry.has((Object)name)) {
                IRI funcUri = this.vf.createIRI(name);
                Function f = SpinFunctionInterpreter.this.parser.parseFunction(funcUri, SpinFunctionInterpreter.this.tripleSource);
                SpinFunctionInterpreter.this.functionRegistry.add((Object)f);
            }
            super.meet(node);
        }
    }
}

