/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.endpoint;

import org.eclipse.rdf4j.federated.FederationContext;
import org.eclipse.rdf4j.federated.endpoint.Endpoint;
import org.eclipse.rdf4j.federated.endpoint.EndpointClassification;
import org.eclipse.rdf4j.federated.endpoint.EndpointConfiguration;
import org.eclipse.rdf4j.federated.endpoint.EndpointType;
import org.eclipse.rdf4j.federated.endpoint.provider.RepositoryInformation;
import org.eclipse.rdf4j.federated.evaluation.TripleSource;
import org.eclipse.rdf4j.federated.evaluation.TripleSourceFactory;
import org.eclipse.rdf4j.federated.exception.FedXRuntimeException;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.base.RepositoryConnectionWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EndpointBase
implements Endpoint {
    protected static final Logger log = LoggerFactory.getLogger(EndpointBase.class);
    protected final RepositoryInformation repoInfo;
    protected final String endpoint;
    protected EndpointClassification endpointClassification;
    protected boolean writable = false;
    private ManagedRepositoryConnection dependentConn = null;
    protected boolean initialized = false;
    protected TripleSource tripleSource;
    protected EndpointConfiguration endpointConfiguration;

    public EndpointBase(RepositoryInformation repoInfo, String endpoint, EndpointClassification endpointClassification) {
        this.repoInfo = repoInfo;
        this.endpoint = endpoint;
        this.writable = repoInfo.isWritable();
        this.endpointClassification = endpointClassification;
    }

    @Override
    public String getName() {
        return this.repoInfo.getName();
    }

    @Override
    public TripleSource getTripleSource() {
        return this.tripleSource;
    }

    @Override
    public EndpointClassification getEndpointClassification() {
        return this.endpointClassification;
    }

    public void setEndpointClassification(EndpointClassification endpointClassification) {
        this.endpointClassification = endpointClassification;
    }

    public boolean isLocal() {
        return this.endpointClassification == EndpointClassification.Local;
    }

    @Override
    public boolean isWritable() {
        return this.writable;
    }

    public RepositoryInformation getRepoInfo() {
        return this.repoInfo;
    }

    public void setWritable(boolean writable) {
        this.writable = writable;
    }

    @Override
    public EndpointConfiguration getEndpointConfiguration() {
        return this.endpointConfiguration;
    }

    public void setEndpointConfiguration(EndpointConfiguration endpointConfiguration) {
        this.endpointConfiguration = endpointConfiguration;
    }

    @Override
    public RepositoryConnection getConnection() {
        if (!this.initialized) {
            throw new FedXRuntimeException("Repository for endpoint " + this.getId() + " not initialized");
        }
        if (this.dependentConn != null) {
            return this.dependentConn;
        }
        return this.getFreshConnection();
    }

    protected RepositoryConnection getFreshConnection() {
        return this.getRepository().getConnection();
    }

    @Override
    public String getId() {
        return this.repoInfo.getId();
    }

    @Override
    public String getEndpoint() {
        return this.endpoint;
    }

    public EndpointType getType() {
        return this.repoInfo.getType();
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public long size() throws RepositoryException {
        try (RepositoryConnection conn = this.getConnection();){
            long l = conn.size(new Resource[0]);
            return l;
        }
    }

    @Override
    public void init(FederationContext federationContext) throws RepositoryException {
        if (this.isInitialized()) {
            return;
        }
        Repository repo = this.getRepository();
        this.tripleSource = TripleSourceFactory.tripleSourceFor(this, this.getType(), federationContext);
        if (this.useSingleConnection()) {
            this.dependentConn = new ManagedRepositoryConnection(repo, repo.getConnection());
        }
        this.initialized = true;
    }

    protected boolean useSingleConnection() {
        return false;
    }

    @Override
    public void shutDown() throws RepositoryException {
        if (!this.isInitialized()) {
            return;
        }
        if (this.dependentConn != null) {
            this.dependentConn.closeManagedConnection();
            this.dependentConn = null;
        }
        this.initialized = false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getId() == null ? 0 : this.getId().hashCode());
        result = 31 * result + (this.getType() == null ? 0 : this.getType().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EndpointBase other = (EndpointBase)obj;
        if (this.getId() == null ? other.getId() != null : !this.getId().equals(other.getId())) {
            return false;
        }
        return !(this.getType() == null ? other.getType() != null : !this.getType().equals((Object)other.getType()));
    }

    public String toString() {
        return "Endpoint [id=" + this.getId() + ", name=" + this.getName() + ", type=" + (Object)((Object)this.getType()) + "]";
    }

    public static class ManagedRepositoryConnection
    extends RepositoryConnectionWrapper {
        public ManagedRepositoryConnection(Repository repository, RepositoryConnection delegate) {
            super(repository, delegate);
        }

        @Override
        public void close() throws RepositoryException {
        }

        public void closeManagedConnection() throws RepositoryException {
            this.getDelegate().close();
        }
    }
}

