/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.AST;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Stream;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.sail.shacl.AST.NodeShape;
import org.eclipse.rdf4j.sail.shacl.AST.Path;
import org.eclipse.rdf4j.sail.shacl.AST.PathPropertyShape;
import org.eclipse.rdf4j.sail.shacl.AST.PlaneNodeWrapper;
import org.eclipse.rdf4j.sail.shacl.ConnectionsGroup;
import org.eclipse.rdf4j.sail.shacl.SourceConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.planNodes.BulkedExternalInnerJoin;
import org.eclipse.rdf4j.sail.shacl.planNodes.EnrichWithShape;
import org.eclipse.rdf4j.sail.shacl.planNodes.ExternalFilterByQuery;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNodeProvider;
import org.eclipse.rdf4j.sail.shacl.planNodes.TrimTuple;
import org.eclipse.rdf4j.sail.shacl.planNodes.TupleMapper;
import org.eclipse.rdf4j.sail.shacl.planNodes.UnBufferedPlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.UnionNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.Unique;
import org.eclipse.rdf4j.sail.shacl.planNodes.ValueInFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HasValuePropertyShape
extends PathPropertyShape {
    private final Value hasValue;
    private static final Logger logger = LoggerFactory.getLogger(HasValuePropertyShape.class);

    HasValuePropertyShape(Resource id, SailRepositoryConnection connection, NodeShape nodeShape, boolean deactivated, PathPropertyShape parent, Resource path, Value hasValue) {
        super(id, connection, nodeShape, deactivated, parent, path);
        if (hasValue instanceof BNode) {
            throw new UnsupportedOperationException("sh:hasValue does not currently support blank nodes");
        }
        this.hasValue = hasValue;
    }

    @Override
    public PlanNode getPlan(ConnectionsGroup connectionsGroup, boolean printPlans, PlanNodeProvider overrideTargetNode, boolean negateThisPlan, boolean negateSubPlans) {
        PlaneNodeWrapper planeNodeWrapper;
        if (this.deactivated) {
            return null;
        }
        assert (!negateSubPlans) : "There are no subplans!";
        if (!this.hasOwnPath()) {
            if (this.getPath() == null) {
                PlanNode addedTargets = this.nodeShape.getPlanAddedStatements(connectionsGroup, null);
                if (overrideTargetNode != null) {
                    addedTargets = overrideTargetNode.getPlanNode();
                }
                PlanNode invalidTargets = new TupleMapper(addedTargets, t -> {
                    List<Value> line = t.getLine();
                    t.getLine().add(line.get(0));
                    return t;
                });
                invalidTargets = negateThisPlan ? new ValueInFilter(invalidTargets, new HashSet<Value>(Collections.singletonList(this.hasValue))).getTrueNode(UnBufferedPlanNode.class) : new ValueInFilter(invalidTargets, new HashSet<Value>(Collections.singletonList(this.hasValue))).getFalseNode(UnBufferedPlanNode.class);
                if (printPlans) {
                    String planAsGraphvizDot = this.getPlanAsGraphvizDot(invalidTargets, connectionsGroup);
                    logger.info(planAsGraphvizDot);
                }
                return new EnrichWithShape(invalidTargets, this);
            }
            PlanNode addedTargets = this.nodeShape.getPlanAddedStatements(connectionsGroup, null);
            PlanNode addedByPath = this.getPath().getPlanAddedStatements(connectionsGroup, null);
            addedTargets = new UnionNode(new TrimTuple(addedByPath, 0, 1), addedTargets);
            addedTargets = new Unique(addedTargets);
            addedTargets = this.nodeShape.getTargetFilter(connectionsGroup, addedTargets);
            if (overrideTargetNode != null) {
                addedTargets = overrideTargetNode.getPlanNode();
            }
            BulkedExternalInnerJoin joined = new BulkedExternalInnerJoin(addedTargets, connectionsGroup.getBaseConnection(), this.getPath().getQuery("?a", "?c", null), false, null, "?a", "?c");
            PlanNode invalidTargets = negateThisPlan ? new ValueInFilter(joined, new HashSet<Value>(Collections.singletonList(this.hasValue))).getTrueNode(UnBufferedPlanNode.class) : new ValueInFilter(joined, new HashSet<Value>(Collections.singletonList(this.hasValue))).getFalseNode(UnBufferedPlanNode.class);
            if (printPlans) {
                String planAsGraphvizDot = this.getPlanAsGraphvizDot(invalidTargets, connectionsGroup);
                logger.info(planAsGraphvizDot);
            }
            return new EnrichWithShape(invalidTargets, this);
        }
        if (overrideTargetNode != null) {
            PlanNode planNode2 = overrideTargetNode.getPlanNode();
            ExternalFilterByQuery externalFilterByQuery = new ExternalFilterByQuery(connectionsGroup.getBaseConnection(), planNode2, 0, this.buildSparqlValidNodes("?this"), "?this");
            planNode2 = negateThisPlan ? externalFilterByQuery.getTrueNode(UnBufferedPlanNode.class) : externalFilterByQuery.getFalseNode(UnBufferedPlanNode.class);
            if (printPlans) {
                String planAsGraphvizDot = this.getPlanAsGraphvizDot(planNode2, connectionsGroup);
                logger.info(planAsGraphvizDot);
            }
            return new EnrichWithShape(planNode2, this);
        }
        PlanNode planAddedStatements = this.nodeShape.getPlanAddedStatements(connectionsGroup, null);
        ExternalFilterByQuery externalFilterByQuery = new ExternalFilterByQuery(connectionsGroup.getBaseConnection(), planAddedStatements, 0, this.buildSparqlValidNodes("?this"), "?this");
        PlanNode invalidValues = negateThisPlan ? externalFilterByQuery.getTrueNode(UnBufferedPlanNode.class) : externalFilterByQuery.getFalseNode(UnBufferedPlanNode.class);
        if (negateThisPlan && connectionsGroup.getStats().hasAdded()) {
            planeNodeWrapper = planNode -> {
                PlanNode targetFilter = this.nodeShape.getTargetFilter(connectionsGroup, planNode);
                return new ExternalFilterByQuery(connectionsGroup.getBaseConnection(), targetFilter, 0, this.buildSparqlValidNodes("?this"), "?this").getTrueNode(UnBufferedPlanNode.class);
            };
            invalidValues = new UnionNode(invalidValues, this.getPlanAddedStatements(connectionsGroup, planeNodeWrapper));
        }
        if (!negateThisPlan && connectionsGroup.getStats().hasRemoved()) {
            planeNodeWrapper = planNode -> {
                PlanNode targetFilter = this.nodeShape.getTargetFilter(connectionsGroup, planNode);
                return new ExternalFilterByQuery(connectionsGroup.getBaseConnection(), targetFilter, 0, this.buildSparqlValidNodes("?this"), "?this").getFalseNode(UnBufferedPlanNode.class);
            };
            invalidValues = new UnionNode(invalidValues, this.getPlanRemovedStatements(connectionsGroup, planeNodeWrapper));
        }
        if (printPlans) {
            String planAsGraphvizDot = this.getPlanAsGraphvizDot(invalidValues, connectionsGroup);
            logger.info(planAsGraphvizDot);
        }
        return new EnrichWithShape(invalidValues, this);
    }

    @Override
    public SourceConstraintComponent getSourceConstraintComponent() {
        return SourceConstraintComponent.HasValueConstraintComponent;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HasValuePropertyShape that = (HasValuePropertyShape)o;
        return this.hasValue.equals(that.hasValue);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.hasValue);
    }

    public String toString() {
        return "HasValuePropertyShape{hasValue=" + this.hasValue + ", path=" + this.getPath() + ", id=" + this.id + '}';
    }

    public Value getHasValue() {
        return this.hasValue;
    }

    @Override
    public String buildSparqlValidNodes(String targetVar) {
        if (this.hasOwnPath()) {
            String objectVar = "?hasValue_" + UUID.randomUUID().toString().replace("-", "");
            if (this.hasValue instanceof IRI) {
                return "BIND(<" + this.hasValue + "> as " + objectVar + ")\n" + this.getPath().getQuery(targetVar, objectVar, null);
            }
            if (this.hasValue instanceof Literal) {
                return "BIND(" + this.hasValue.toString() + " as " + objectVar + ")\n" + this.getPath().getQuery(targetVar, objectVar, null);
            }
        } else {
            if (this.hasValue instanceof IRI) {
                return targetVar + " = <" + this.hasValue + ">";
            }
            if (this.hasValue instanceof Literal) {
                return targetVar + " = " + this.hasValue.toString();
            }
        }
        throw new UnsupportedOperationException("hasValue was unsupported type: " + this.hasValue.getClass().getSimpleName());
    }

    @Override
    public Stream<StatementPattern> getStatementPatterns() {
        return this.getPath().getStatementsPatterns(new Var("?this"), new Var(UUID.randomUUID().toString(), this.hasValue));
    }

    @Override
    public PlanNode getAllTargetsPlan(ConnectionsGroup connectionsGroup, boolean negated) {
        PlanNode plan = this.nodeShape.getPlanAddedStatements(connectionsGroup, null);
        plan = new UnionNode(plan, this.nodeShape.getPlanRemovedStatements(connectionsGroup, null));
        Path path = this.getPath();
        if (path != null) {
            plan = new UnionNode(plan, this.getPlanAddedStatements(connectionsGroup, null));
            plan = new UnionNode(plan, this.getPlanRemovedStatements(connectionsGroup, null));
        }
        plan = new Unique(new TrimTuple(plan, 0, 1));
        return this.nodeShape.getTargetFilter(connectionsGroup, plan);
    }
}

