/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.planNodes;

import java.util.Objects;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.impl.MapBindingSet;
import org.eclipse.rdf4j.query.parser.ParsedQuery;
import org.eclipse.rdf4j.query.parser.QueryParserFactory;
import org.eclipse.rdf4j.query.parser.QueryParserRegistry;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.memory.MemoryStoreConnection;
import org.eclipse.rdf4j.sail.shacl.planNodes.IteratorData;
import org.eclipse.rdf4j.sail.shacl.planNodes.LoggingCloseableIteration;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.Tuple;
import org.eclipse.rdf4j.sail.shacl.planNodes.ValidationExecutionLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Select
implements PlanNode {
    private static final Logger logger = LoggerFactory.getLogger(Select.class);
    private final SailConnection connection;
    private final String query;
    private final String[] variables;
    private boolean printed = false;
    private ValidationExecutionLogger validationExecutionLogger;

    public Select(SailConnection connection, String query, String ... variables) {
        assert (variables.length > 0);
        this.connection = connection;
        if (query.trim().equals("")) {
            logger.error("Query is empty", new Throwable("This throwable is just to log the stack trace"));
            query = "?a <http://fjiewojfiwejfioewhgurh8924y.com/f289h8fhn> ?c. \nFILTER (NOT EXISTS {?a <http://fjiewojfiwejfioewhgurh8924y.com/f289h8fhn> ?c}) \n";
        }
        this.query = "select " + String.join((CharSequence)" ", variables) + " where { \n" + query.replaceAll("(?m)^", "\t") + "\n} order by ?a";
        this.variables = variables;
    }

    @Override
    public CloseableIteration<Tuple, SailException> iterator() {
        return new LoggingCloseableIteration(this, this.validationExecutionLogger){
            final CloseableIteration<? extends BindingSet, QueryEvaluationException> bindingSet;
            {
                QueryParserFactory queryParserFactory = (QueryParserFactory)QueryParserRegistry.getInstance().get((Object)QueryLanguage.SPARQL).get();
                try {
                    ParsedQuery parsedQuery = queryParserFactory.getParser().parseQuery(Select.this.query, null);
                    this.bindingSet = Select.this.connection.evaluate(parsedQuery.getTupleExpr(), parsedQuery.getDataset(), (BindingSet)new MapBindingSet(), true);
                }
                catch (MalformedQueryException e) {
                    logger.error("Malformed query: \n{}", (Object)Select.this.query);
                    throw e;
                }
            }

            public void close() throws SailException {
                this.bindingSet.close();
            }

            @Override
            boolean localHasNext() throws SailException {
                return this.bindingSet.hasNext();
            }

            @Override
            Tuple loggingNext() throws SailException {
                return new Tuple((BindingSet)this.bindingSet.next(), Select.this.variables);
            }

            public void remove() throws SailException {
            }
        };
    }

    @Override
    public int depth() {
        return 0;
    }

    @Override
    public void getPlanAsGraphvizDot(StringBuilder stringBuilder) {
        if (this.printed) {
            return;
        }
        this.printed = true;
        stringBuilder.append(this.getId() + " [label=\"" + StringEscapeUtils.escapeJava((String)this.toString()) + "\"];").append("\n");
        if (this.connection instanceof MemoryStoreConnection) {
            stringBuilder.append(System.identityHashCode(((MemoryStoreConnection)this.connection).getSail()) + " -> " + this.getId()).append("\n");
        } else {
            stringBuilder.append(System.identityHashCode(this.connection) + " -> " + this.getId()).append("\n");
        }
    }

    @Override
    public String getId() {
        return System.identityHashCode(this) + "";
    }

    @Override
    public IteratorData getIteratorDataType() {
        return IteratorData.tripleBased;
    }

    public String toString() {
        return "Select{query='" + this.query.replace("\n", "  ") + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Select select = (Select)o;
        return Objects.equals(this.connection instanceof MemoryStoreConnection ? ((MemoryStoreConnection)this.connection).getSail() : this.connection, select.connection instanceof MemoryStoreConnection ? ((MemoryStoreConnection)select.connection).getSail() : select.connection) && this.query.equals(select.query);
    }

    public int hashCode() {
        if (this.connection instanceof MemoryStoreConnection) {
            return Objects.hash(System.identityHashCode(((MemoryStoreConnection)this.connection).getSail()), this.query);
        }
        return Objects.hash(System.identityHashCode(this.connection), this.query);
    }

    @Override
    public void receiveLogger(ValidationExecutionLogger validationExecutionLogger) {
        this.validationExecutionLogger = validationExecutionLogger;
    }
}

