/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.model.impl;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Triple;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.datatypes.XMLDatatypeUtil;
import org.eclipse.rdf4j.model.impl.BooleanLiteral;
import org.eclipse.rdf4j.model.impl.ContextStatement;
import org.eclipse.rdf4j.model.impl.DecimalLiteral;
import org.eclipse.rdf4j.model.impl.IntegerLiteral;
import org.eclipse.rdf4j.model.impl.NumericLiteral;
import org.eclipse.rdf4j.model.impl.SimpleBNode;
import org.eclipse.rdf4j.model.impl.SimpleIRI;
import org.eclipse.rdf4j.model.impl.SimpleLiteral;
import org.eclipse.rdf4j.model.impl.SimpleStatement;
import org.eclipse.rdf4j.model.impl.SimpleTriple;
import org.eclipse.rdf4j.model.vocabulary.XSD;

@Deprecated
public abstract class AbstractValueFactory
implements ValueFactory {
    private static long lastBNodePrefixUID = 0L;
    private static final DatatypeFactory datatypeFactory;
    private int nextBNodeID;
    private String bnodePrefix;

    private static synchronized long getNextBNodePrefixUid() {
        lastBNodePrefixUID = Math.max(System.currentTimeMillis(), lastBNodePrefixUID + 1L);
        return lastBNodePrefixUID;
    }

    protected AbstractValueFactory() {
        this.initBNodeParams();
    }

    public IRI createIRI(String iri) {
        return new SimpleIRI(iri);
    }

    public IRI createIRI(String namespace, String localName) {
        return this.createIRI(namespace + localName);
    }

    public BNode createBNode(String nodeID) {
        return new SimpleBNode(nodeID);
    }

    public Literal createLiteral(String value) {
        return new SimpleLiteral(value, XSD.Datatype.STRING);
    }

    public Literal createLiteral(String value, String language) {
        return new SimpleLiteral(value, language);
    }

    public Literal createLiteral(boolean b) {
        return b ? BooleanLiteral.TRUE : BooleanLiteral.FALSE;
    }

    public Literal createLiteral(String value, IRI datatype) {
        return new SimpleLiteral(value, datatype);
    }

    public Statement createStatement(Resource subject, IRI predicate, Value object) {
        return new SimpleStatement(subject, predicate, object);
    }

    public Statement createStatement(Resource subject, IRI predicate, Value object, Resource context) {
        return new ContextStatement(subject, predicate, object, context);
    }

    public Triple createTriple(Resource subject, IRI predicate, Value object) {
        return new SimpleTriple(subject, predicate, object);
    }

    protected void initBNodeParams() {
        this.bnodePrefix = "node" + Long.toString(AbstractValueFactory.getNextBNodePrefixUid(), 32) + "x";
        this.nextBNodeID = 1;
    }

    public synchronized BNode createBNode() {
        int id = this.nextBNodeID++;
        BNode result = this.createBNode(this.bnodePrefix + id);
        if (id == Integer.MAX_VALUE) {
            this.initBNodeParams();
        }
        return result;
    }

    public Literal createLiteral(byte value) {
        return this.createIntegerLiteral((Number)value, XSD.Datatype.BYTE);
    }

    public Literal createLiteral(short value) {
        return this.createIntegerLiteral((Number)value, XSD.Datatype.SHORT);
    }

    public Literal createLiteral(int value) {
        return this.createIntegerLiteral((Number)value, XSD.Datatype.INT);
    }

    public Literal createLiteral(long value) {
        return this.createIntegerLiteral((Number)value, XSD.Datatype.LONG);
    }

    protected Literal createIntegerLiteral(Number value, IRI datatype) {
        return this.createNumericLiteral(value, datatype);
    }

    protected Literal createIntegerLiteral(Number value, XSD.Datatype datatype) {
        return this.createNumericLiteral(value, datatype);
    }

    public Literal createLiteral(float value) {
        return this.createFPLiteral((Number)Float.valueOf(value), XSD.Datatype.FLOAT);
    }

    public Literal createLiteral(double value) {
        return this.createFPLiteral((Number)value, XSD.Datatype.DOUBLE);
    }

    public Literal createLiteral(BigInteger bigInteger) {
        return this.createIntegerLiteral((Number)bigInteger, XSD.INTEGER);
    }

    public Literal createLiteral(BigDecimal bigDecimal) {
        return this.createNumericLiteral((Number)bigDecimal, XSD.DECIMAL);
    }

    protected Literal createFPLiteral(Number value, IRI datatype) {
        return this.createNumericLiteral(value, datatype);
    }

    protected Literal createFPLiteral(Number value, XSD.Datatype datatype) {
        return this.createNumericLiteral(value, datatype);
    }

    protected Literal createNumericLiteral(Number number, IRI datatype) {
        if (number instanceof BigDecimal) {
            return new DecimalLiteral((BigDecimal)number, datatype);
        }
        if (number instanceof BigInteger) {
            return new IntegerLiteral((BigInteger)number, datatype);
        }
        return new NumericLiteral(number, datatype);
    }

    protected Literal createNumericLiteral(Number number, XSD.Datatype datatype) {
        if (number instanceof BigDecimal) {
            return new DecimalLiteral((BigDecimal)number, datatype);
        }
        if (number instanceof BigInteger) {
            return new IntegerLiteral((BigInteger)number, datatype);
        }
        return new NumericLiteral(number, datatype);
    }

    public Literal createLiteral(XMLGregorianCalendar calendar) {
        return this.createLiteral(calendar.toXMLFormat(), XMLDatatypeUtil.qnameToURI(calendar.getXMLSchemaType()));
    }

    public Literal createLiteral(Date date) {
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(date);
        XMLGregorianCalendar xmlGregCalendar = datatypeFactory.newXMLGregorianCalendar(c);
        return this.createLiteral(xmlGregCalendar);
    }

    static {
        try {
            datatypeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            throw new Error("Could not instantiate javax.xml.datatype.DatatypeFactory", e);
        }
    }
}

