/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra;

import java.util.List;
import java.util.ListIterator;
import org.eclipse.rdf4j.query.algebra.GraphPatternGroupable;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.VariableScopeChange;
import org.eclipse.rdf4j.query.algebra.helpers.QueryModelTreePrinter;

public abstract class AbstractQueryModelNode
implements QueryModelNode,
VariableScopeChange,
GraphPatternGroupable {
    private static final long serialVersionUID = 3006199552086476178L;
    private QueryModelNode parent;
    private boolean isVariableScopeChange;
    private double resultSizeEstimate = -1.0;
    private long resultSizeActual = -1L;
    private double costEstimate = -1.0;
    private long totalTimeNanosActual = -1L;

    @Override
    public QueryModelNode getParentNode() {
        return this.parent;
    }

    @Override
    public void setParentNode(QueryModelNode parent) {
        this.parent = parent;
    }

    @Override
    public boolean isVariableScopeChange() {
        return this.isVariableScopeChange;
    }

    @Override
    public void setVariableScopeChange(boolean isVariableScopeChange) {
        this.isVariableScopeChange = isVariableScopeChange;
    }

    @Override
    @Deprecated
    public boolean isGraphPatternGroup() {
        return this.isVariableScopeChange();
    }

    @Override
    @Deprecated
    public void setGraphPatternGroup(boolean isGraphPatternGroup) {
        this.setVariableScopeChange(isGraphPatternGroup);
    }

    @Override
    public <X extends Exception> void visitChildren(QueryModelVisitor<X> visitor) throws X {
    }

    @Override
    public void replaceChildNode(QueryModelNode current, QueryModelNode replacement) {
        throw new IllegalArgumentException("Node is not a child node: " + current);
    }

    @Override
    public void replaceWith(QueryModelNode replacement) {
        if (this.parent == null) {
            throw new IllegalStateException("Node has no parent");
        }
        this.parent.replaceChildNode(this, replacement);
    }

    @Override
    public String getSignature() {
        return this.getClass().getSimpleName();
    }

    @Override
    public String toString() {
        QueryModelTreePrinter treePrinter = new QueryModelTreePrinter();
        this.visit(treePrinter);
        return treePrinter.getTreeString();
    }

    @Override
    public AbstractQueryModelNode clone() {
        try {
            AbstractQueryModelNode clone = (AbstractQueryModelNode)super.clone();
            clone.setVariableScopeChange(this.isVariableScopeChange());
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Query model nodes are required to be cloneable", e);
        }
    }

    protected <T extends QueryModelNode> boolean replaceNodeInList(List<T> list, QueryModelNode current, QueryModelNode replacement) {
        ListIterator<T> iter = list.listIterator();
        while (iter.hasNext()) {
            if (iter.next() != current) continue;
            iter.set(replacement);
            replacement.setParentNode(this);
            return true;
        }
        return false;
    }

    protected boolean nullEquals(Object o1, Object o2) {
        return o1 == o2 || o1 != null && o1.equals(o2);
    }

    @Override
    public double getResultSizeEstimate() {
        return this.resultSizeEstimate;
    }

    @Override
    public void setResultSizeEstimate(double resultSizeEstimate) {
        this.resultSizeEstimate = resultSizeEstimate;
    }

    @Override
    public long getResultSizeActual() {
        return this.resultSizeActual;
    }

    @Override
    public void setResultSizeActual(long resultSizeActual) {
        this.resultSizeActual = resultSizeActual;
    }

    @Override
    public double getCostEstimate() {
        return this.costEstimate;
    }

    @Override
    public void setCostEstimate(double costEstimate) {
        this.costEstimate = costEstimate;
    }

    @Override
    public long getTotalTimeNanosActual() {
        return this.totalTimeNanosActual;
    }

    @Override
    public void setTotalTimeNanosActual(long totalTimeNanosActual) {
        this.totalTimeNanosActual = totalTimeNanosActual;
    }

    static String toHumanReadbleNumber(double number) {
        String humanReadbleString = number == Double.POSITIVE_INFINITY ? "\u221e" : (number > 1000000.0 ? (double)Math.round(number / 100000.0) / 10.0 + "M" : (number > 1000.0 ? (double)Math.round(number / 100.0) / 10.0 + "K" : (number >= 0.0 ? Math.round(number) + "" : "UNKNOWN")));
        return humanReadbleString;
    }
}

