/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.common.iteration;

import java.util.NoSuchElementException;
import java.util.Objects;
import org.eclipse.rdf4j.common.iteration.AbstractCloseableIteration;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.common.iteration.Iterations;

public abstract class ConvertingIteration<S, T, X extends Exception>
extends AbstractCloseableIteration<T, X> {
    private final Iteration<? extends S, ? extends X> iter;

    protected ConvertingIteration(Iteration<? extends S, ? extends X> iter) {
        this.iter = Objects.requireNonNull(iter, "The iterator was null");
    }

    protected abstract T convert(S var1) throws X;

    @Override
    public boolean hasNext() throws X {
        if (this.isClosed()) {
            return false;
        }
        boolean result = this.iter.hasNext();
        if (!result) {
            this.close();
        }
        return result;
    }

    @Override
    public T next() throws X {
        if (this.isClosed()) {
            throw new NoSuchElementException("The iteration has been closed.");
        }
        return this.convert(this.iter.next());
    }

    @Override
    public void remove() throws X {
        if (this.isClosed()) {
            throw new IllegalStateException("The iteration has been closed.");
        }
        this.iter.remove();
    }

    @Override
    protected void handleClose() throws X {
        try {
            super.handleClose();
        }
        finally {
            Iterations.closeCloseable(this.iter);
        }
    }
}

