/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.paths;

import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.sail.shacl.ConnectionsGroup;
import org.eclipse.rdf4j.sail.shacl.ast.Exportable;
import org.eclipse.rdf4j.sail.shacl.ast.Identifiable;
import org.eclipse.rdf4j.sail.shacl.ast.ShaclUnsupportedException;
import org.eclipse.rdf4j.sail.shacl.ast.Targetable;
import org.eclipse.rdf4j.sail.shacl.ast.paths.AlternativePath;
import org.eclipse.rdf4j.sail.shacl.ast.paths.InversePath;
import org.eclipse.rdf4j.sail.shacl.ast.paths.OneOrMorePath;
import org.eclipse.rdf4j.sail.shacl.ast.paths.SequencePath;
import org.eclipse.rdf4j.sail.shacl.ast.paths.SimplePath;
import org.eclipse.rdf4j.sail.shacl.ast.paths.ZeroOrMorePath;
import org.eclipse.rdf4j.sail.shacl.ast.paths.ZeroOrOnePath;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNodeWrapper;

public abstract class Path
implements Identifiable,
Exportable,
Targetable {
    Resource id;

    public Path(Resource id) {
        this.id = id;
    }

    @Override
    public Resource getId() {
        return this.id;
    }

    public static Path buildPath(RepositoryConnection connection, Resource id) {
        if (id == null) {
            return null;
        }
        if (id.isBNode()) {
            List collect = connection.getStatements(id, null, null, true, new Resource[0]).stream().collect(Collectors.toList());
            for (Statement statement : collect) {
                IRI pathType = statement.getPredicate();
                switch (pathType.toString()) {
                    case "http://www.w3.org/ns/shacl#inversePath": {
                        return new InversePath(id, (Resource)statement.getObject(), connection);
                    }
                    case "http://www.w3.org/ns/shacl#alternativePath": {
                        return new AlternativePath(id, (Resource)statement.getObject(), connection);
                    }
                    case "http://www.w3.org/ns/shacl#zeroOrMorePath": {
                        return new ZeroOrMorePath(id, (Resource)statement.getObject(), connection);
                    }
                    case "http://www.w3.org/ns/shacl#oneOrMorePath": {
                        return new OneOrMorePath(id, (Resource)statement.getObject(), connection);
                    }
                    case "http://www.w3.org/ns/shacl#zeroOrOnePath": {
                        return new ZeroOrOnePath(id, (Resource)statement.getObject(), connection);
                    }
                    case "http://www.w3.org/1999/02/22-rdf-syntax-ns#first": {
                        return new SequencePath(id, connection);
                    }
                }
            }
            throw new ShaclUnsupportedException();
        }
        return new SimplePath((IRI)id);
    }

    public abstract PlanNode getAdded(ConnectionsGroup var1, PlanNodeWrapper var2);
}

