/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.targets;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.impl.MapBindingSet;
import org.eclipse.rdf4j.query.parser.ParsedQuery;
import org.eclipse.rdf4j.query.parser.QueryParserFactory;
import org.eclipse.rdf4j.query.parser.QueryParserRegistry;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.shacl.ConnectionsGroup;
import org.eclipse.rdf4j.sail.shacl.ast.StatementMatcher;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationExecutionLogger;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TargetChainRetriever
implements PlanNode {
    private static final Logger logger = LoggerFactory.getLogger(TargetChainRetriever.class);
    private final ConnectionsGroup connectionsGroup;
    private final List<StatementMatcher> statementPatterns;
    private final List<StatementMatcher> removedStatementMatchers;
    private final String query;
    private final QueryParserFactory queryParserFactory;
    private final ConstraintComponent.Scope scope;
    private final StackTraceElement[] stackTrace;

    public TargetChainRetriever(ConnectionsGroup connectionsGroup, List<StatementMatcher> statementPatterns, List<StatementMatcher> removedStatementMatchers, String query, List<StatementMatcher.Variable> vars, ConstraintComponent.Scope scope) {
        this.connectionsGroup = connectionsGroup;
        this.statementPatterns = statementPatterns;
        this.scope = scope;
        String sparqlProjection = vars.stream().map(s -> "?" + s.getName()).reduce((a, b) -> a + " " + b).orElseThrow(IllegalStateException::new);
        this.query = "select " + sparqlProjection + " where {" + query + "}";
        this.stackTrace = Thread.currentThread().getStackTrace();
        this.queryParserFactory = (QueryParserFactory)QueryParserRegistry.getInstance().get(QueryLanguage.SPARQL).get();
        List<StatementMatcher> list = this.removedStatementMatchers = removedStatementMatchers != null ? removedStatementMatchers : Collections.emptyList();
        assert (this.removedStatementMatchers.size() <= 1);
    }

    @Override
    public CloseableIteration<? extends ValidationTuple, SailException> iterator() {
        return new CloseableIteration<ValidationTuple, SailException>(){
            final Iterator<StatementMatcher> statementPatternIterator;
            final Iterator<StatementMatcher> removedStatementIterator;
            StatementMatcher currentStatementMatcher;
            CloseableIteration<? extends Statement, SailException> statements;
            ValidationTuple next;
            CloseableIteration<? extends BindingSet, QueryEvaluationException> results;
            ParsedQuery parsedQuery;
            {
                this.statementPatternIterator = TargetChainRetriever.this.statementPatterns.iterator();
                this.removedStatementIterator = TargetChainRetriever.this.removedStatementMatchers.iterator();
            }

            public void calculateNextStatementMatcher() {
                if (this.statements != null && this.statements.hasNext()) {
                    return;
                }
                if (!this.statementPatternIterator.hasNext() && !this.removedStatementIterator.hasNext()) {
                    if (this.statements != null) {
                        this.statements.close();
                    }
                    return;
                }
                do {
                    SailConnection connection;
                    if (this.statements != null) {
                        this.statements.close();
                    }
                    if (!this.statementPatternIterator.hasNext() && !this.removedStatementIterator.hasNext()) break;
                    if (this.statementPatternIterator.hasNext()) {
                        this.currentStatementMatcher = this.statementPatternIterator.next();
                        connection = TargetChainRetriever.this.connectionsGroup.getAddedStatements();
                    } else {
                        this.currentStatementMatcher = this.removedStatementIterator.next();
                        connection = TargetChainRetriever.this.connectionsGroup.getRemovedStatements();
                    }
                    this.statements = connection.getStatements(this.currentStatementMatcher.getSubjectValue(), this.currentStatementMatcher.getPredicateValue(), this.currentStatementMatcher.getObjectValue(), false, new Resource[0]);
                } while (!this.statements.hasNext());
            }

            private void calculateNextResult() {
                if (this.next != null) {
                    return;
                }
                while (this.results == null || !this.results.hasNext()) {
                    try {
                        if (this.results != null) {
                            this.results.close();
                        }
                        MapBindingSet bindings = new MapBindingSet();
                        if (this.statements == null || !this.statements.hasNext()) {
                            this.calculateNextStatementMatcher();
                            if (this.statements == null || !this.statements.hasNext()) {
                                return;
                            }
                        }
                        if (this.parsedQuery == null) {
                            this.parsedQuery = TargetChainRetriever.this.queryParserFactory.getParser().parseQuery(TargetChainRetriever.this.query, null);
                        }
                        Statement next = (Statement)this.statements.next();
                        if (this.currentStatementMatcher.getSubjectValue() == null && !this.currentStatementMatcher.subjectIsWildcard()) {
                            bindings.addBinding(this.currentStatementMatcher.getSubjectName(), next.getSubject());
                        }
                        if (this.currentStatementMatcher.getPredicateValue() == null && !this.currentStatementMatcher.predicateIsWildcard()) {
                            bindings.addBinding(this.currentStatementMatcher.getPredicateName(), next.getPredicate());
                        }
                        if (this.currentStatementMatcher.getObjectValue() == null && !this.currentStatementMatcher.objectIsWildcard()) {
                            bindings.addBinding(this.currentStatementMatcher.getObjectName(), next.getObject());
                        }
                        this.results = TargetChainRetriever.this.connectionsGroup.getBaseConnection().evaluate(this.parsedQuery.getTupleExpr(), this.parsedQuery.getDataset(), bindings, true);
                    }
                    catch (MalformedQueryException e) {
                        logger.error("Malformed query: \n{}", (Object)TargetChainRetriever.this.query);
                        throw e;
                    }
                }
                if (this.results.hasNext()) {
                    BindingSet nextBinding = (BindingSet)this.results.next();
                    ArrayDeque collect = nextBinding.getBindingNames().stream().sorted().map(nextBinding::getValue).collect(Collectors.toCollection(ArrayDeque::new));
                    this.next = new ValidationTuple(collect, TargetChainRetriever.this.scope, false);
                }
            }

            @Override
            public void close() throws SailException {
            }

            @Override
            public boolean hasNext() throws SailException {
                this.calculateNextResult();
                return this.next != null;
            }

            @Override
            public ValidationTuple next() throws SailException {
                this.calculateNextResult();
                ValidationTuple temp = this.next;
                this.next = null;
                return temp;
            }

            @Override
            public void remove() throws SailException {
            }
        };
    }

    @Override
    public int depth() {
        return 0;
    }

    @Override
    public void getPlanAsGraphvizDot(StringBuilder stringBuilder) {
    }

    @Override
    public String getId() {
        return null;
    }

    @Override
    public void receiveLogger(ValidationExecutionLogger validationExecutionLogger) {
    }

    @Override
    public boolean producesSorted() {
        return false;
    }

    @Override
    public boolean requiresSorted() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TargetChainRetriever that = (TargetChainRetriever)o;
        return this.statementPatterns.equals(that.statementPatterns) && this.removedStatementMatchers.equals(that.removedStatementMatchers) && this.query.equals(that.query) && this.scope == that.scope;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.statementPatterns, this.removedStatementMatchers, this.query, this.scope});
    }

    public String toString() {
        return "TargetChainRetriever{statementPatterns=" + this.statementPatterns + ", removedStatementMatchers=" + this.removedStatementMatchers + ", query='" + this.query + '\'' + ", scope=" + (Object)((Object)this.scope) + '}';
    }
}

