/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.model.util;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.rdf4j.common.annotation.Experimental;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.ModelFactory;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Triple;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.DynamicModelFactory;
import org.eclipse.rdf4j.model.impl.LinkedHashModel;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.util.GraphComparisons;
import org.eclipse.rdf4j.model.util.ModelCollector;
import org.eclipse.rdf4j.model.util.ModelException;
import org.eclipse.rdf4j.model.util.Statements;
import org.eclipse.rdf4j.model.util.SynchronizedModel;
import org.eclipse.rdf4j.model.vocabulary.RDF;

public class Models {
    protected Models() {
    }

    public static Optional<Value> object(Iterable<Statement> statements) {
        return StreamSupport.stream(statements.spliterator(), false).map(st -> st.getObject()).findAny();
    }

    public static Optional<Value> object(Model m) {
        return Models.object((Iterable<Statement>)m);
    }

    public static Optional<Literal> objectLiteral(Iterable<Statement> statements) {
        return StreamSupport.stream(statements.spliterator(), false).map(st -> st.getObject()).filter(o -> o instanceof Literal).map(l -> (Literal)l).findAny();
    }

    public static Optional<Literal> objectLiteral(Model m) {
        return Models.objectLiteral((Iterable<Statement>)m);
    }

    public static Set<Literal> objectLiterals(Iterable<Statement> statements) {
        return StreamSupport.stream(statements.spliterator(), false).map(st -> st.getObject()).filter(o -> o instanceof Literal).map(l -> (Literal)l).collect(Collectors.toSet());
    }

    public static Set<Literal> objectLiterals(Model m) {
        return Models.objectLiterals((Iterable<Statement>)m);
    }

    public static Optional<Resource> objectResource(Iterable<Statement> statements) {
        return StreamSupport.stream(statements.spliterator(), false).map(st -> st.getObject()).filter(o -> o instanceof Resource).map(r -> (Resource)r).findAny();
    }

    public static Optional<Resource> objectResource(Model m) {
        return Models.objectResource((Iterable<Statement>)m);
    }

    public static Set<Resource> objectResources(Iterable<Statement> statements) {
        return StreamSupport.stream(statements.spliterator(), false).map(st -> st.getObject()).filter(o -> o instanceof Resource).map(r -> (Resource)r).collect(Collectors.toSet());
    }

    public static Set<Resource> objectResources(Model m) {
        return Models.objectResources((Iterable<Statement>)m);
    }

    public static Optional<IRI> objectIRI(Iterable<Statement> statements) {
        return StreamSupport.stream(statements.spliterator(), false).map(st -> st.getObject()).filter(o -> o instanceof IRI).map(r -> (IRI)r).findAny();
    }

    public static Optional<IRI> objectIRI(Model m) {
        return Models.objectIRI((Iterable<Statement>)m);
    }

    public static Set<IRI> objectIRIs(Iterable<Statement> statements) {
        return StreamSupport.stream(statements.spliterator(), false).map(st -> st.getObject()).filter(o -> o instanceof IRI).map(r -> (IRI)r).collect(Collectors.toSet());
    }

    public static Set<IRI> objectIRIs(Model m) {
        return Models.objectIRIs((Iterable<Statement>)m);
    }

    public static Optional<String> objectString(Iterable<Statement> statements) {
        return StreamSupport.stream(statements.spliterator(), false).map(st -> st.getObject().stringValue()).findAny();
    }

    public static Optional<String> objectString(Model m) {
        return Models.objectString((Iterable<Statement>)m);
    }

    public static Set<String> objectStrings(Iterable<Statement> statements) {
        return StreamSupport.stream(statements.spliterator(), false).map(st -> st.getObject().stringValue()).collect(Collectors.toSet());
    }

    public static Set<String> objectStrings(Model m) {
        return Models.objectStrings((Iterable<Statement>)m);
    }

    public static Optional<Resource> subject(Iterable<Statement> statements) {
        return StreamSupport.stream(statements.spliterator(), false).map(st -> st.getSubject()).findAny();
    }

    public static Optional<Resource> subject(Model m) {
        return Models.subject((Iterable<Statement>)m);
    }

    public static Optional<IRI> subjectIRI(Iterable<Statement> statements) {
        return StreamSupport.stream(statements.spliterator(), false).map(st -> st.getSubject()).filter(s -> s instanceof IRI).map(s -> (IRI)s).findAny();
    }

    public static Optional<IRI> subjectIRI(Model m) {
        return Models.subjectIRI((Iterable<Statement>)m);
    }

    public static Set<IRI> subjectIRIs(Iterable<Statement> statements) {
        return StreamSupport.stream(statements.spliterator(), false).map(st -> st.getSubject()).filter(o -> o instanceof IRI).map(r -> (IRI)r).collect(Collectors.toSet());
    }

    public static Set<IRI> subjectIRIs(Model m) {
        return Models.subjectIRIs((Iterable<Statement>)m);
    }

    public static Optional<BNode> subjectBNode(Iterable<Statement> statements) {
        return StreamSupport.stream(statements.spliterator(), false).map(st -> st.getSubject()).filter(s -> s instanceof BNode).map(s -> (BNode)s).findAny();
    }

    public static Optional<BNode> subjectBNode(Model m) {
        return Models.subjectBNode((Iterable<Statement>)m);
    }

    public static Set<BNode> subjectBNodes(Iterable<Statement> statements) {
        return StreamSupport.stream(statements.spliterator(), false).map(st -> st.getSubject()).filter(o -> o instanceof BNode).map(r -> (BNode)r).collect(Collectors.toSet());
    }

    public static Set<BNode> subjectBNodes(Model m) {
        return Models.subjectBNodes((Iterable<Statement>)m);
    }

    public static Optional<IRI> predicate(Iterable<Statement> statements) {
        return StreamSupport.stream(statements.spliterator(), false).map(st -> st.getPredicate()).findAny();
    }

    public static Optional<IRI> predicate(Model m) {
        return Models.predicate((Iterable<Statement>)m);
    }

    public static Model setProperty(Model m, Resource subject, IRI property, Value value, Resource ... contexts) {
        Objects.requireNonNull(m, "model may not be null");
        Objects.requireNonNull(subject, "subject may not be null");
        Objects.requireNonNull(property, "property may not be null");
        Objects.requireNonNull(value, "value may not be null");
        if (m.contains(subject, property, null, contexts)) {
            m.remove(subject, property, null, contexts);
        }
        m.add(subject, property, value, contexts);
        return m;
    }

    public static Optional<Value> getProperty(Model m, Resource subject, IRI property, Resource ... contexts) {
        Objects.requireNonNull(m, "model may not be null");
        Objects.requireNonNull(subject, "subject may not be null");
        Objects.requireNonNull(property, "property may not be null");
        return Models.object(m.getStatements(subject, property, null, contexts));
    }

    public static Set<Value> getProperties(Model m, Resource subject, IRI property, Resource ... contexts) {
        Objects.requireNonNull(m, "model may not be null");
        Objects.requireNonNull(subject, "subject may not be null");
        Objects.requireNonNull(property, "property may not be null");
        return m.filter(subject, property, null, contexts).objects();
    }

    public static Optional<Resource> getPropertyResource(Model m, Resource subject, IRI property, Resource ... contexts) {
        Objects.requireNonNull(m, "model may not be null");
        Objects.requireNonNull(subject, "subject may not be null");
        Objects.requireNonNull(property, "property may not be null");
        return Models.objectResource(m.getStatements(subject, property, null, contexts));
    }

    public static Set<Resource> getPropertyResources(Model m, Resource subject, IRI property, Resource ... contexts) {
        Objects.requireNonNull(m, "model may not be null");
        Objects.requireNonNull(subject, "subject may not be null");
        Objects.requireNonNull(property, "property may not be null");
        return Models.objectResources(m.getStatements(subject, property, null, contexts));
    }

    public static Optional<IRI> getPropertyIRI(Model m, Resource subject, IRI property, Resource ... contexts) {
        Objects.requireNonNull(m, "model may not be null");
        Objects.requireNonNull(subject, "subject may not be null");
        Objects.requireNonNull(property, "property may not be null");
        return Models.objectIRI(m.getStatements(subject, property, null, contexts));
    }

    public static Set<IRI> getPropertyIRIs(Model m, Resource subject, IRI property, Resource ... contexts) {
        Objects.requireNonNull(m, "model may not be null");
        Objects.requireNonNull(subject, "subject may not be null");
        Objects.requireNonNull(property, "property may not be null");
        return Models.objectIRIs(m.getStatements(subject, property, null, contexts));
    }

    public static Optional<Literal> getPropertyLiteral(Model m, Resource subject, IRI property, Resource ... contexts) {
        Objects.requireNonNull(m, "model may not be null");
        Objects.requireNonNull(subject, "subject may not be null");
        Objects.requireNonNull(property, "property may not be null");
        return Models.objectLiteral(m.getStatements(subject, property, null, contexts));
    }

    public static Set<Literal> getPropertyLiterals(Model m, Resource subject, IRI property, Resource ... contexts) {
        Objects.requireNonNull(m, "model may not be null");
        Objects.requireNonNull(subject, "subject may not be null");
        Objects.requireNonNull(property, "property may not be null");
        return Models.objectLiterals(m.getStatements(subject, property, null, contexts));
    }

    public static Optional<String> getPropertyString(Model m, Resource subject, IRI property, Resource ... contexts) {
        Objects.requireNonNull(m, "model may not be null");
        Objects.requireNonNull(subject, "subject may not be null");
        Objects.requireNonNull(property, "property may not be null");
        return Models.objectString(m.getStatements(subject, property, null, contexts));
    }

    public static Set<String> getPropertyStrings(Model m, Resource subject, IRI property, Resource ... contexts) {
        Objects.requireNonNull(m, "model may not be null");
        Objects.requireNonNull(subject, "subject may not be null");
        Objects.requireNonNull(property, "property may not be null");
        return Models.objectStrings(m.getStatements(subject, property, null, contexts));
    }

    public static boolean isomorphic(Iterable<? extends Statement> model1, Iterable<? extends Statement> model2) {
        if (model1 == model2) {
            return true;
        }
        Model set1 = Models.toModel(model1);
        Model set2 = Models.toModel(model2);
        return GraphComparisons.isomorphic(set1, set2);
    }

    @Experimental
    @Deprecated
    public static boolean legacyIsomorphic(Iterable<? extends Statement> model1, Iterable<? extends Statement> model2) {
        if (model1 == model2) {
            return true;
        }
        Set<Statement> set1 = Models.toSet(model1);
        Model set2 = Models.toModel(model2);
        if (set1.size() != set2.size()) {
            return false;
        }
        return Models.isSubsetInternal(set1, set2);
    }

    public static boolean isSubset(Iterable<? extends Statement> model1, Iterable<? extends Statement> model2) {
        Set<Statement> set1 = Models.toSet(model1);
        Model set2 = Models.toModel(model2);
        return Models.isSubset(set1, set2);
    }

    public static boolean isSubset(Set<? extends Statement> model1, Set<? extends Statement> model2) {
        if (model1.size() > model2.size()) {
            return false;
        }
        return Models.isSubsetInternal(Models.toSet(model1), Models.toModel(model2));
    }

    public static Model stripContexts(Model model, Resource ... contexts) {
        List<Resource> contextList = Arrays.asList(contexts);
        return model.stream().map(st -> {
            if (contextList.isEmpty() || contextList.contains(st.getContext())) {
                return Statements.stripContext(st);
            }
            return st;
        }).collect(ModelCollector.toModel());
    }

    public static Supplier<ModelException> modelException(String message) {
        return () -> new ModelException(message);
    }

    public static Model synchronizedModel(Model toSynchronize) {
        return new SynchronizedModel(toSynchronize);
    }

    @Experimental
    public static void convertRDFStarToReification(ValueFactory vf, Model model, Consumer<Statement> consumer) {
        model.forEach(st -> Statements.convertRDFStarToReification(vf, st, consumer));
    }

    @Experimental
    public static void convertRDFStarToReification(Model model, Consumer<Statement> consumer) {
        Models.convertRDFStarToReification((ValueFactory)SimpleValueFactory.getInstance(), model, consumer);
    }

    @Experimental
    public static Model convertRDFStarToReification(ValueFactory vf, Model model) {
        LinkedHashModel reificationModel = new LinkedHashModel();
        Models.convertRDFStarToReification(vf, model, reificationModel::add);
        return reificationModel;
    }

    @Experimental
    public static Model convertRDFStarToReification(ValueFactory vf, Model model, ModelFactory modelFactory) {
        Model reificationModel = modelFactory.createEmptyModel();
        Models.convertRDFStarToReification(vf, model, reificationModel::add);
        return reificationModel;
    }

    @Experimental
    public static Model convertRDFStarToReification(Model model) {
        return Models.convertRDFStarToReification(SimpleValueFactory.getInstance(), model);
    }

    @Experimental
    public static void convertReificationToRDFStar(ValueFactory vf, Model model, Consumer<Statement> consumer) {
        HashMap convertedStatements = new HashMap();
        model.filter(null, RDF.TYPE, (Value)RDF.STATEMENT, new Resource[0]).forEach(s -> {
            Value subject = Models.object(model.filter(s.getSubject(), RDF.SUBJECT, null, new Resource[0])).orElse(null);
            if (!(subject instanceof IRI) && !(subject instanceof BNode)) {
                return;
            }
            Value predicate = Models.object(model.filter(s.getSubject(), RDF.PREDICATE, null, new Resource[0])).orElse(null);
            if (!(predicate instanceof IRI)) {
                return;
            }
            Value object = Models.object(model.filter(s.getSubject(), RDF.OBJECT, null, new Resource[0])).orElse(null);
            if (!(object instanceof Value)) {
                return;
            }
            Triple t = vf.createTriple((Resource)subject, (IRI)predicate, object);
            convertedStatements.put(s.getSubject(), t);
        });
        for (Map.Entry entry : convertedStatements.entrySet()) {
            Triple t = (Triple)entry.getValue();
            Resource subject = (Resource)convertedStatements.get(t.getSubject());
            Resource object = (Resource)convertedStatements.get(t.getObject());
            if (subject == null && object == null) continue;
            Triple nt = vf.createTriple(subject != null ? subject : t.getSubject(), t.getPredicate(), object != null ? object : t.getObject());
            entry.setValue(nt);
        }
        model.forEach(s -> {
            Resource subject = s.getSubject();
            IRI predicate = s.getPredicate();
            Value object = s.getObject();
            Triple subjectTriple = (Triple)convertedStatements.get(subject);
            Triple objectTriple = (Triple)convertedStatements.get(object);
            if (subjectTriple == null && objectTriple == null) {
                consumer.accept((Statement)s);
            } else if (!(subjectTriple != null && (RDF.TYPE.equals(predicate) && RDF.STATEMENT.equals(object) || RDF.SUBJECT.equals(predicate) || RDF.PREDICATE.equals(predicate) || RDF.OBJECT.equals(predicate)))) {
                Statement ns = vf.createStatement(subjectTriple != null ? subjectTriple : s.getSubject(), s.getPredicate(), objectTriple != null ? objectTriple : s.getObject(), s.getContext());
                consumer.accept(ns);
            }
        });
    }

    @Experimental
    public static void convertReificationToRDFStar(Model model, Consumer<Statement> consumer) {
        Models.convertReificationToRDFStar((ValueFactory)SimpleValueFactory.getInstance(), model, consumer);
    }

    @Experimental
    public static Model convertReificationToRDFStar(ValueFactory vf, Model model, ModelFactory modelFactory) {
        Model rdfStarModel = modelFactory.createEmptyModel();
        Models.convertReificationToRDFStar(vf, model, rdfStarModel::add);
        return rdfStarModel;
    }

    @Experimental
    public static Model convertReificationToRDFStar(ValueFactory vf, Model model) {
        return Models.convertReificationToRDFStar(vf, model, new DynamicModelFactory());
    }

    @Experimental
    public static Model convertReificationToRDFStar(Model model) {
        return Models.convertReificationToRDFStar(SimpleValueFactory.getInstance(), model);
    }

    private static boolean isSubsetInternal(Set<Statement> model1, Model model2) {
        return Models.matchModels(model1, model2);
    }

    private static boolean matchModels(Set<Statement> model1, Model model2) {
        ArrayList<Statement> model1BNodes = new ArrayList<Statement>(model1.size());
        for (Statement st : model1) {
            if (Models.isBlank(st.getSubject()) || Models.isBlank(st.getObject()) || Models.isBlank(st.getContext())) {
                model1BNodes.add(st);
                continue;
            }
            if (model2.contains(st)) continue;
            return false;
        }
        return Models.matchModels(Collections.unmodifiableList(model1BNodes), model2);
    }

    private static boolean matchModels(List<? extends Statement> model1, Model model2) {
        ArrayDeque<Iterator> iterators = new ArrayDeque<Iterator>();
        ArrayDeque<Map<Resource, Resource>> bNodeMappings = new ArrayDeque<Map<Resource, Resource>>();
        Map<Resource, Resource> bNodeMapping = Collections.emptyMap();
        int idx = 0;
        Iterator iterator = null;
        while (idx < model1.size()) {
            Statement st1 = model1.get(idx);
            if (iterator == null) {
                List<Statement> matchingStats = Models.findMatchingStatements(st1, model2, bNodeMapping);
                iterator = matchingStats.iterator();
            }
            if (iterator.hasNext()) {
                Statement st2 = (Statement)iterator.next();
                Map<Resource, Resource> newBNodeMapping = Models.createNewBnodeMapping(bNodeMapping, st1, st2);
                iterators.addLast(iterator);
                bNodeMappings.addLast(bNodeMapping);
                iterator = null;
                bNodeMapping = newBNodeMapping;
                ++idx;
            }
            if (iterator == null) continue;
            if (--idx < 0) {
                return false;
            }
            iterator = (Iterator)iterators.removeLast();
            bNodeMapping = (Map<Resource, Resource>)bNodeMappings.removeLast();
        }
        return true;
    }

    private static Map<Resource, Resource> createNewBnodeMapping(Map<Resource, Resource> bNodeMapping, Statement st1, Statement st2) {
        HashMap<Resource, Resource> newBNodeMapping = new HashMap<Resource, Resource>(bNodeMapping);
        if (Models.isBlank(st1.getSubject()) && Models.isBlank(st2.getSubject())) {
            newBNodeMapping.put(st1.getSubject(), st2.getSubject());
        }
        if (Models.isBlank(st1.getObject()) && Models.isBlank(st2.getObject())) {
            newBNodeMapping.put((Resource)st1.getObject(), (Resource)st2.getObject());
        }
        if (Models.isBlank(st1.getContext()) && Models.isBlank(st2.getContext())) {
            newBNodeMapping.put(st1.getContext(), st2.getContext());
        }
        return newBNodeMapping;
    }

    private static List<Statement> findMatchingStatements(Statement st, Model model, Map<Resource, Resource> bNodeMapping) {
        Resource[] resourceArray;
        Value o;
        Resource s = Models.isBlank(st.getSubject()) ? null : st.getSubject();
        IRI p = st.getPredicate();
        Value value = o = Models.isBlank(st.getObject()) ? null : st.getObject();
        if (Models.isBlank(st.getContext())) {
            resourceArray = new Resource[]{};
        } else {
            Resource[] resourceArray2 = new Resource[1];
            resourceArray = resourceArray2;
            resourceArray2[0] = st.getContext();
        }
        Resource[] g = resourceArray;
        ArrayList<Statement> result = new ArrayList<Statement>();
        for (Statement modelSt : model.filter(s, p, o, g)) {
            if (!Models.statementsMatch(st, modelSt, bNodeMapping)) continue;
            result.add(modelSt);
        }
        return Collections.unmodifiableList(result);
    }

    private static boolean statementsMatch(Statement st1, Statement st2, Map<Resource, Resource> bNodeMapping) {
        Value obj2;
        Resource subj2;
        IRI pred2;
        IRI pred1 = st1.getPredicate();
        if (!pred1.equals(pred2 = st2.getPredicate())) {
            return false;
        }
        Resource subj1 = st1.getSubject();
        if (Models.bnodeValueMatching(bNodeMapping, subj1, subj2 = st2.getSubject())) {
            return false;
        }
        Value obj1 = st1.getObject();
        if (Models.bnodeValueMatching(bNodeMapping, obj1, obj2 = st2.getObject())) {
            return false;
        }
        Resource context1 = st1.getContext();
        Resource context2 = st2.getContext();
        if (context1 == null) {
            return context2 == null;
        }
        if (context2 == null) {
            return false;
        }
        return !Models.bnodeValueMatching(bNodeMapping, context1, context2);
    }

    private static boolean bnodeValueMatching(Map<Resource, Resource> bNodeMapping, Value obj1, Value obj2) {
        if (Models.isBlank(obj1) && Models.isBlank(obj2)) {
            Resource mappedBNode = bNodeMapping.get(obj1);
            if (mappedBNode != null) {
                return !obj2.equals(mappedBNode);
            }
            return bNodeMapping.containsValue(obj2);
        }
        return !obj1.equals(obj2);
    }

    private static boolean isBlank(Value value) {
        if (value instanceof BNode) {
            return true;
        }
        if (value instanceof IRI) {
            boolean skolemizedBNode = value.stringValue().contains("/.well-known/genid/");
            return skolemizedBNode;
        }
        return false;
    }

    private static Model toModel(Iterable<? extends Statement> iterable) {
        LinkedHashModel set;
        if (iterable instanceof Model) {
            return (Model)iterable;
        }
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            set = new LinkedHashModel(size);
        } else {
            set = new LinkedHashModel();
        }
        StreamSupport.stream(iterable.spliterator(), false).filter(Objects::nonNull).forEach(set::add);
        return set;
    }

    private static Set<Statement> toSet(Iterable<? extends Statement> iterable) {
        if (iterable instanceof Set) {
            return (Set)iterable;
        }
        if (iterable instanceof Collection) {
            return new HashSet<Statement>((Collection)iterable);
        }
        HashSet<Statement> statements = new HashSet<Statement>();
        StreamSupport.stream(iterable.spliterator(), false).filter(Objects::nonNull).forEach(statements::add);
        return statements;
    }
}

