/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.planNodes;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.LoggingCloseableIteration;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationExecutionLogger;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;

class OnlyNonUnique
extends LoggingCloseableIteration {
    private ValidationTuple next;
    private ValidationTuple previous;
    private Set<String> seenLanguages = new HashSet<String>();
    private final CloseableIteration<? extends ValidationTuple, SailException> parentIterator;

    OnlyNonUnique(PlanNode parent, ValidationExecutionLogger validationExecutionLogger) {
        super(parent, validationExecutionLogger);
        this.parentIterator = parent.iterator();
    }

    private void calculateNext() {
        if (this.next != null) {
            return;
        }
        while (this.next == null && this.parentIterator.hasNext()) {
            this.next = (ValidationTuple)this.parentIterator.next();
            if (this.previous != null && !this.previous.sameTargetAs(this.next)) {
                this.seenLanguages = new HashSet<String>();
            }
            this.previous = this.next;
            Value value = this.next.getValue();
            if (value.isLiteral()) {
                Optional<String> lang = ((Literal)value).getLanguage();
                if (!lang.isPresent()) {
                    this.next = null;
                    continue;
                }
                if (this.seenLanguages.contains(lang.get())) continue;
                this.seenLanguages.add(lang.get());
                this.next = null;
                continue;
            }
            this.next = null;
        }
    }

    @Override
    public void close() throws SailException {
        this.parentIterator.close();
    }

    @Override
    boolean localHasNext() throws SailException {
        this.calculateNext();
        return this.next != null;
    }

    @Override
    ValidationTuple loggingNext() throws SailException {
        this.calculateNext();
        ValidationTuple temp = this.next;
        this.next = null;
        return temp;
    }

    @Override
    public void remove() throws SailException {
        throw new UnsupportedOperationException();
    }
}

