/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.solr;

import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.Map;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.sail.lucene.DocumentScore;
import org.eclipse.rdf4j.sail.lucene.SearchFields;
import org.eclipse.rdf4j.sail.lucene.SearchQuery;
import org.eclipse.rdf4j.sail.solr.SolrDocumentScore;
import org.eclipse.rdf4j.sail.solr.SolrIndex;
import org.eclipse.rdf4j.sail.solr.SolrSearchDocument;

@Deprecated
public class SolrSearchQuery
implements SearchQuery {
    private final SolrQuery query;
    private SolrIndex index;

    public SolrSearchQuery(SolrQuery q, SolrIndex index) {
        this.query = q;
        this.index = index;
    }

    @Override
    public Iterable<? extends DocumentScore> query(Resource resource) throws IOException {
        QueryResponse response;
        if (this.query.getHighlight()) {
            this.query.addField("*");
        } else {
            this.query.addField("uri");
        }
        this.query.addField("score");
        try {
            response = resource != null ? this.index.search(resource, this.query) : this.index.search(this.query);
        }
        catch (SolrServerException e) {
            throw new IOException(e);
        }
        SolrDocumentList results = response.getResults();
        Map highlighting = response.getHighlighting();
        return Iterables.transform((Iterable)results, document -> {
            SolrSearchDocument doc = new SolrSearchDocument((SolrDocument)document);
            Map docHighlighting = highlighting != null ? (Map)highlighting.get(doc.getId()) : null;
            return new SolrDocumentScore(doc, docHighlighting);
        });
    }

    @Override
    public void highlight(IRI property) {
        this.query.setHighlight(true);
        String field = property != null ? SearchFields.getPropertyField(property) : "*";
        this.query.addHighlightField(field);
        this.query.setHighlightSimplePre("<B>");
        this.query.setHighlightSimplePost("</B>");
        this.query.setHighlightSnippets(2);
    }
}

