/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.resultio.sparqlxml;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.rdf4j.common.xml.SimpleSAXAdapter;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.XSD;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryResultHandler;
import org.eclipse.rdf4j.query.TupleQueryResultHandlerException;
import org.eclipse.rdf4j.query.impl.MapBindingSet;
import org.eclipse.rdf4j.query.resultio.QueryResultParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

class SPARQLResultsSAXParser
extends SimpleSAXAdapter {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private List<String> bindingNames;
    private String currentBindingName;
    private Value currentValue;
    private MapBindingSet currentSolution;
    private ValueFactory valueFactory;
    private QueryResultHandler handler;
    private Deque<TripleContainer> tripleStack = new ArrayDeque<TripleContainer>();

    public SPARQLResultsSAXParser(ValueFactory valueFactory, QueryResultHandler handler) {
        this.valueFactory = valueFactory;
        this.handler = handler;
    }

    public void startDocument() throws SAXException {
        this.bindingNames = new ArrayList<String>();
        this.currentValue = null;
    }

    public void endDocument() throws SAXException {
        try {
            if (this.handler != null) {
                this.handler.endQueryResult();
            }
        }
        catch (TupleQueryResultHandlerException e) {
            throw new SAXException((Exception)((Object)e));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void startTag(String tagName, Map<String, String> atts, String text) throws SAXException {
        if ("binding".equals(tagName)) {
            this.currentBindingName = atts.get("name");
            if (this.currentBindingName != null) return;
            throw new SAXException("name attribute missing for binding element");
        }
        if ("triple".equals(tagName) || "statement".equals(tagName)) {
            this.tripleStack.push(new TripleContainer());
            return;
        }
        if ("uri".equals(tagName)) {
            try {
                this.currentValue = this.valueFactory.createIRI(text);
                return;
            }
            catch (IllegalArgumentException e) {
                throw new SAXException(e.getMessage(), e);
            }
        }
        if ("bnode".equals(tagName)) {
            this.currentValue = this.valueFactory.createBNode(text);
            return;
        }
        if ("literal".equals(tagName)) {
            String xmlLang = atts.get("xml:lang");
            String datatype = atts.get("datatype");
            if (xmlLang != null) {
                this.currentValue = this.valueFactory.createLiteral(text, xmlLang);
                return;
            }
            if (datatype != null) {
                IRI datatypeIri;
                try {
                    datatypeIri = this.valueFactory.createIRI(datatype);
                }
                catch (IllegalArgumentException e) {
                    throw new SAXException(e.getMessage(), e);
                }
                if (RDF.LANGSTRING.equals((Object)datatypeIri) && xmlLang == null) {
                    this.logger.debug("rdf:langString typed literal missing language tag: '{}'. Falling back to xsd:string.", (Object)StringUtils.abbreviate((String)text, (int)10));
                    datatypeIri = XSD.STRING;
                }
                this.currentValue = this.valueFactory.createLiteral(text, datatypeIri);
                return;
            }
            this.currentValue = this.valueFactory.createLiteral(text);
            return;
        }
        if ("result".equals(tagName)) {
            this.currentSolution = new MapBindingSet(this.bindingNames.size());
            return;
        } else if ("variable".equals(tagName)) {
            String varName = atts.get("name");
            if (varName == null) {
                throw new SAXException("name missing for variable element");
            }
            this.bindingNames.add(varName);
            return;
        } else if ("results".equals(tagName)) {
            try {
                if (this.handler == null) return;
                this.handler.startQueryResult(this.bindingNames);
                return;
            }
            catch (TupleQueryResultHandlerException e) {
                throw new SAXException((Exception)((Object)e));
            }
        } else {
            if (!"boolean".equals(tagName)) return;
            QueryResultParseException realException = new QueryResultParseException("Found boolean results in tuple parser");
            throw new SAXException((Exception)((Object)realException));
        }
    }

    public void endTag(String tagName) throws SAXException {
        switch (tagName) {
            case "binding": {
                if (this.currentValue == null) {
                    throw new SAXException("Value missing for binding element");
                }
                this.currentSolution.addBinding(this.currentBindingName, this.currentValue);
                this.currentBindingName = null;
                this.currentValue = null;
                break;
            }
            case "subject": 
            case "s": {
                TripleContainer currentTriple = this.tripleStack.peek();
                if (currentTriple.getSubject() != null) {
                    throw new SAXException("RDF* triple subject defined twice");
                }
                if (this.currentValue instanceof Resource) {
                    currentTriple.setSubject((Resource)this.currentValue);
                    break;
                }
                throw new SAXException("unexpected value type for subject: " + this.currentValue);
            }
            case "predicate": 
            case "p": {
                TripleContainer currentTriple = this.tripleStack.peek();
                if (currentTriple.getPredicate() != null) {
                    throw new SAXException("RDF* triple predicate defined twice");
                }
                if (this.currentValue instanceof IRI) {
                    currentTriple.setPredicate((IRI)this.currentValue);
                    break;
                }
                throw new SAXException("unexpected value type for predicate: " + this.currentValue);
            }
            case "object": 
            case "o": {
                TripleContainer currentTriple = this.tripleStack.peek();
                if (currentTriple.getObject() != null) {
                    throw new SAXException("RDF* triple object defined twice");
                }
                currentTriple.setObject(this.currentValue);
                break;
            }
            case "triple": 
            case "statement": {
                TripleContainer currentTriple = this.tripleStack.pop();
                this.currentValue = this.valueFactory.createTriple(currentTriple.getSubject(), currentTriple.getPredicate(), currentTriple.getObject());
                break;
            }
            case "result": {
                try {
                    if (this.handler != null) {
                        this.handler.handleSolution((BindingSet)this.currentSolution);
                    }
                    this.currentSolution = null;
                    break;
                }
                catch (TupleQueryResultHandlerException e) {
                    throw new SAXException((Exception)((Object)e));
                }
            }
        }
    }

    private static class TripleContainer {
        private Resource subject;
        private IRI predicate;
        private Value object;

        private TripleContainer() {
        }

        public Resource getSubject() {
            return this.subject;
        }

        public void setSubject(Resource subject) {
            this.subject = subject;
        }

        public IRI getPredicate() {
            return this.predicate;
        }

        public void setPredicate(IRI predicate) {
            this.predicate = predicate;
        }

        public Value getObject() {
            return this.object;
        }

        public void setObject(Value object) {
            this.object = object;
        }
    }
}

