/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.http;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.http.client.HttpClient;
import org.eclipse.rdf4j.OpenRDFUtil;
import org.eclipse.rdf4j.RDF4JException;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.CloseableIteratorIteration;
import org.eclipse.rdf4j.common.transaction.TransactionSetting;
import org.eclipse.rdf4j.http.client.HttpClientDependent;
import org.eclipse.rdf4j.http.client.RDF4JProtocolSession;
import org.eclipse.rdf4j.http.protocol.Protocol;
import org.eclipse.rdf4j.http.protocol.transaction.operations.AddStatementOperation;
import org.eclipse.rdf4j.http.protocol.transaction.operations.ClearNamespacesOperation;
import org.eclipse.rdf4j.http.protocol.transaction.operations.ClearOperation;
import org.eclipse.rdf4j.http.protocol.transaction.operations.RemoveNamespaceOperation;
import org.eclipse.rdf4j.http.protocol.transaction.operations.RemoveStatementsOperation;
import org.eclipse.rdf4j.http.protocol.transaction.operations.SPARQLUpdateOperation;
import org.eclipse.rdf4j.http.protocol.transaction.operations.SetNamespaceOperation;
import org.eclipse.rdf4j.http.protocol.transaction.operations.TransactionOperation;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.LinkedHashModel;
import org.eclipse.rdf4j.model.impl.SimpleNamespace;
import org.eclipse.rdf4j.model.vocabulary.SESAME;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.BooleanQuery;
import org.eclipse.rdf4j.query.GraphQuery;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.Query;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryInterruptedException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.Update;
import org.eclipse.rdf4j.query.parser.QueryParserUtil;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.RepositoryResult;
import org.eclipse.rdf4j.repository.UnknownTransactionStateException;
import org.eclipse.rdf4j.repository.base.AbstractRepositoryConnection;
import org.eclipse.rdf4j.repository.http.HTTPBooleanQuery;
import org.eclipse.rdf4j.repository.http.HTTPGraphQuery;
import org.eclipse.rdf4j.repository.http.HTTPRepository;
import org.eclipse.rdf4j.repository.http.HTTPTupleQuery;
import org.eclipse.rdf4j.repository.http.HTTPUpdate;
import org.eclipse.rdf4j.repository.http.helpers.HTTPRepositorySettings;
import org.eclipse.rdf4j.rio.ParserConfig;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.RDFParserRegistry;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.rio.helpers.BasicParserSettings;
import org.eclipse.rdf4j.rio.helpers.StatementCollector;

class HTTPRepositoryConnection
extends AbstractRepositoryConnection
implements HttpClientDependent {
    private List<TransactionOperation> txn = Collections.synchronizedList(new ArrayList());
    private final RDF4JProtocolSession client;
    private boolean active;
    private Model toAdd;
    private Model toRemove;

    public HTTPRepositoryConnection(HTTPRepository repository, RDF4JProtocolSession client) {
        super((Repository)repository);
        this.client = client;
        this.setParserConfig(new ParserConfig());
        this.getParserConfig().set(BasicParserSettings.VERIFY_DATATYPE_VALUES, (Object)true);
        this.getParserConfig().set(BasicParserSettings.PRESERVE_BNODE_IDS, (Object)true);
        this.getParserConfig().set(HTTPRepositorySettings.MAX_STATEMENT_BUFFER_SIZE, HTTPRepositorySettings.MAX_STATEMENT_BUFFER_SIZE.getDefaultValue());
    }

    public HttpClient getHttpClient() {
        return this.client.getHttpClient();
    }

    public void setHttpClient(HttpClient httpClient) {
        this.client.setHttpClient(httpClient);
    }

    public void setParserConfig(ParserConfig parserConfig) {
        super.setParserConfig(parserConfig);
    }

    public HTTPRepository getRepository() {
        return (HTTPRepository)super.getRepository();
    }

    public void begin() throws RepositoryException {
        this.verifyIsOpen();
        this.verifyNotTxnActive("Connection already has an active transaction");
        if (this.getRepository().useCompatibleMode()) {
            this.active = true;
            return;
        }
        try {
            this.client.beginTransaction(this.getIsolationLevel());
            this.active = true;
        }
        catch (RepositoryException e) {
            throw e;
        }
        catch (IOException | IllegalStateException | RDF4JException e) {
            throw new RepositoryException(e);
        }
    }

    public void begin(TransactionSetting ... settings) {
        this.verifyIsOpen();
        this.verifyNotTxnActive("Connection already has an active transaction");
        if (this.getRepository().useCompatibleMode()) {
            this.active = true;
            return;
        }
        try {
            this.client.beginTransaction(settings);
            this.active = true;
        }
        catch (RepositoryException e) {
            throw e;
        }
        catch (IOException | IllegalStateException | RDF4JException e) {
            throw new RepositoryException(e);
        }
    }

    public Query prepareQuery(QueryLanguage ql, String queryString, String baseURI) {
        if (QueryLanguage.SPARQL.equals((Object)ql)) {
            String strippedQuery = QueryParserUtil.removeSPARQLQueryProlog((String)queryString).toUpperCase();
            if (strippedQuery.startsWith("SELECT")) {
                return this.prepareTupleQuery(ql, queryString, baseURI);
            }
            if (strippedQuery.startsWith("ASK")) {
                return this.prepareBooleanQuery(ql, queryString, baseURI);
            }
            return this.prepareGraphQuery(ql, queryString, baseURI);
        }
        if (QueryLanguage.SERQL.equals((Object)ql)) {
            String strippedQuery = queryString;
            strippedQuery = strippedQuery.replace('(', ' ');
            if ((strippedQuery = strippedQuery.trim()).toUpperCase().startsWith("SELECT")) {
                return this.prepareTupleQuery(ql, queryString, baseURI);
            }
            return this.prepareGraphQuery(ql, queryString, baseURI);
        }
        throw new UnsupportedOperationException("Operation not supported for query language " + ql);
    }

    public TupleQuery prepareTupleQuery(QueryLanguage ql, String queryString, String baseURI) {
        return new HTTPTupleQuery(this, ql, queryString, baseURI);
    }

    public GraphQuery prepareGraphQuery(QueryLanguage ql, String queryString, String baseURI) {
        return new HTTPGraphQuery(this, ql, queryString, baseURI);
    }

    public BooleanQuery prepareBooleanQuery(QueryLanguage ql, String queryString, String baseURI) {
        return new HTTPBooleanQuery(this, ql, queryString, baseURI);
    }

    public RepositoryResult<Resource> getContextIDs() throws RepositoryException {
        try {
            ArrayList<Resource> contextList = new ArrayList<Resource>();
            try (TupleQueryResult contextIDs = this.client.getContextIDs();){
                while (contextIDs.hasNext()) {
                    BindingSet bindingSet = (BindingSet)contextIDs.next();
                    Value context = bindingSet.getValue("contextID");
                    if (!(context instanceof Resource)) continue;
                    contextList.add((Resource)context);
                }
            }
            return this.createRepositoryResult(contextList);
        }
        catch (IOException | QueryEvaluationException e) {
            throw new RepositoryException(e);
        }
    }

    public RepositoryResult<Statement> getStatements(Resource subj, IRI pred, Value obj, boolean includeInferred, Resource ... contexts) throws RepositoryException {
        try {
            StatementCollector collector = new StatementCollector();
            this.exportStatements(subj, pred, obj, includeInferred, (RDFHandler)collector, contexts);
            return this.createRepositoryResult(collector.getStatements());
        }
        catch (RDFHandlerException e) {
            throw new RuntimeException(e);
        }
    }

    public void exportStatements(Resource subj, IRI pred, Value obj, boolean includeInferred, RDFHandler handler, Resource ... contexts) throws RDFHandlerException, RepositoryException {
        this.flushTransactionState(Protocol.Action.GET);
        try {
            this.client.getStatements(subj, pred, obj, includeInferred, handler, contexts);
        }
        catch (IOException | QueryInterruptedException e) {
            throw new RepositoryException(e);
        }
    }

    public long size(Resource ... contexts) throws RepositoryException {
        this.flushTransactionState(Protocol.Action.SIZE);
        try {
            return this.client.size(contexts);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public void prepare() throws RepositoryException {
        if (this.getRepository().getServerProtocolVersion() < 12) {
            this.logger.warn("Prepare operation not supported by server (requires protocol version 12)");
            return;
        }
        this.flushTransactionState(Protocol.Action.PREPARE);
        try {
            this.client.prepareTransaction();
        }
        catch (RepositoryException e) {
            throw e;
        }
        catch (IOException | IllegalStateException | RDF4JException e) {
            throw new RepositoryException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws RepositoryException {
        if (this.getRepository().useCompatibleMode()) {
            List<TransactionOperation> list = this.txn;
            synchronized (list) {
                if (this.txn.size() > 0) {
                    try {
                        this.client.sendTransaction(this.txn);
                        this.txn.clear();
                    }
                    catch (IOException e) {
                        throw new RepositoryException((Throwable)e);
                    }
                }
                this.active = false;
            }
            return;
        }
        this.flushTransactionState(Protocol.Action.COMMIT);
        try {
            this.client.commitTransaction();
            this.active = false;
        }
        catch (RepositoryException e) {
            throw e;
        }
        catch (IOException | IllegalStateException | RDF4JException e) {
            throw new RepositoryException(e);
        }
    }

    public void rollback() throws RepositoryException {
        if (this.getRepository().useCompatibleMode()) {
            this.txn.clear();
            this.active = false;
            return;
        }
        this.flushTransactionState(Protocol.Action.ROLLBACK);
        try {
            this.client.rollbackTransaction();
            this.active = false;
        }
        catch (RepositoryException e) {
            throw e;
        }
        catch (IOException | IllegalStateException | RDF4JException e) {
            throw new RepositoryException(e);
        }
    }

    public void close() throws RepositoryException {
        try {
            if (this.isActive()) {
                this.logger.warn("Rolling back transaction due to connection close", new Throwable());
                this.rollback();
            }
        }
        finally {
            super.close();
            this.client.close();
        }
    }

    public void add(File file, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        if (baseURI == null) {
            baseURI = file.toURI().toString();
        }
        if (dataFormat == null) {
            dataFormat = (RDFFormat)Rio.getParserFormatForFileName((String)file.getName()).orElseThrow(Rio.unsupportedFormat((String)file.getName()));
        }
        try (FileInputStream in = new FileInputStream(file);){
            this.add(in, baseURI, dataFormat, contexts);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(URL url, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        if (baseURI == null) {
            baseURI = url.toExternalForm();
        }
        URLConnection con = url.openConnection();
        if (dataFormat != null) {
            for (String mimeType : dataFormat.getMIMETypes()) {
                con.addRequestProperty("Accept", mimeType);
            }
        } else {
            Set rdfFormats = RDFParserRegistry.getInstance().getKeys();
            List acceptParams = RDFFormat.getAcceptParams((Iterable)rdfFormats, (boolean)true, null);
            for (String acceptParam : acceptParams) {
                con.addRequestProperty("Accept", acceptParam);
            }
        }
        InputStream in = con.getInputStream();
        if (dataFormat == null) {
            String mimeType;
            mimeType = con.getContentType();
            int semiColonIdx = mimeType.indexOf(59);
            if (semiColonIdx >= 0) {
                mimeType = mimeType.substring(0, semiColonIdx);
            }
            dataFormat = (RDFFormat)Rio.getParserFormatForMIMEType((String)mimeType).orElse(Rio.getParserFormatForFileName((String)url.getPath()).orElseThrow(Rio.unsupportedFormat((String)mimeType)));
        }
        try {
            this.add(in, baseURI, dataFormat, contexts);
        }
        finally {
            in.close();
        }
    }

    public void add(InputStream in, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        if (this.getRepository().useCompatibleMode()) {
            dataFormat = this.getBackwardCompatibleFormat(dataFormat);
            if (!this.isActive()) {
                this.client.upload(in, baseURI, dataFormat, false, false, contexts);
            } else {
                super.add(in, baseURI, dataFormat, contexts);
            }
            return;
        }
        this.flushTransactionState(Protocol.Action.ADD);
        this.client.upload(in, baseURI, dataFormat, false, false, contexts);
    }

    private RDFFormat getBackwardCompatibleFormat(RDFFormat format) {
        if (RDFFormat.NTRIPLES.equals((Object)format)) {
            return new RDFFormat(RDFFormat.NTRIPLES.getName(), Arrays.asList("text/plain"), RDFFormat.NTRIPLES.getCharset(), (Collection)RDFFormat.NTRIPLES.getFileExtensions(), RDFFormat.NTRIPLES.supportsNamespaces(), RDFFormat.NTRIPLES.supportsContexts(), RDFFormat.NTRIPLES.supportsRDFStar());
        }
        return format;
    }

    public void add(Reader reader, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        if (this.getRepository().useCompatibleMode()) {
            dataFormat = this.getBackwardCompatibleFormat(dataFormat);
            if (!this.isActive()) {
                this.client.upload(reader, baseURI, dataFormat, false, false, contexts);
            } else {
                super.add(reader, baseURI, dataFormat, contexts);
            }
            return;
        }
        this.flushTransactionState(Protocol.Action.ADD);
        this.client.upload(reader, baseURI, dataFormat, false, false, contexts);
    }

    public void add(Statement st, Resource ... contexts) throws RepositoryException {
        if (!this.isActive()) {
            OpenRDFUtil.verifyContextNotNull((Resource[])contexts);
            LinkedHashModel m = new LinkedHashModel();
            if (contexts.length == 0) {
                m.add(st.getSubject(), st.getPredicate(), st.getObject(), new Resource[]{st.getContext()});
            } else {
                m.add(st.getSubject(), st.getPredicate(), st.getObject(), contexts);
            }
            this.addModel((Model)m);
        } else {
            super.add(st, contexts);
        }
    }

    public void add(Resource subject, IRI predicate, Value object, Resource ... contexts) throws RepositoryException {
        if (!this.isActive()) {
            this.logger.debug("adding statement directly: {} {} {} {}", new Object[]{subject, predicate, object, contexts});
            OpenRDFUtil.verifyContextNotNull((Resource[])contexts);
            LinkedHashModel m = new LinkedHashModel();
            m.add(subject, predicate, object, contexts);
            this.addModel((Model)m);
        } else {
            this.logger.debug("adding statement in txn: {} {} {} {}", new Object[]{subject, predicate, object, contexts});
            super.add(subject, predicate, object, contexts);
        }
    }

    protected void addWithoutCommit(Resource subject, IRI predicate, Value object, Resource ... contexts) throws RepositoryException {
        if (this.getRepository().useCompatibleMode()) {
            this.txn.add((TransactionOperation)new AddStatementOperation(subject, predicate, object, contexts));
            return;
        }
        this.flushTransactionState(Protocol.Action.ADD);
        if (this.toAdd == null) {
            this.toAdd = new LinkedHashModel();
        }
        this.toAdd.add(subject, predicate, object, contexts);
    }

    private void addModel(Model m) throws RepositoryException {
        RDFFormat format = RDFFormat.BINARY;
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Rio.write((Iterable)m, (OutputStream)out, (RDFFormat)format);
            ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
            this.client.addData((InputStream)in, null, format, new Resource[0]);
        }
        catch (RDFHandlerException e) {
            throw new RepositoryException("error while writing statement", (Throwable)e);
        }
        catch (IOException | RDFParseException e) {
            throw new RepositoryException(e);
        }
    }

    private void removeModel(Model m) throws RepositoryException {
        RDFFormat format = RDFFormat.BINARY;
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Rio.write((Iterable)m, (OutputStream)out, (RDFFormat)format);
            ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
            this.client.removeData((InputStream)in, null, format, new Resource[0]);
        }
        catch (RDFHandlerException e) {
            throw new RepositoryException("error while writing statement", (Throwable)e);
        }
        catch (IOException | RDFParseException e) {
            throw new RepositoryException(e);
        }
    }

    protected void flushTransactionState(Protocol.Action action) throws RepositoryException {
        if (this.getRepository().useCompatibleMode()) {
            return;
        }
        if (this.isActive()) {
            int maxBufferSize = (Integer)this.getParserConfig().get(HTTPRepositorySettings.MAX_STATEMENT_BUFFER_SIZE);
            switch (action) {
                case ADD: {
                    if (this.toRemove != null) {
                        this.removeModel(this.toRemove);
                        this.toRemove = null;
                    }
                    if (this.toAdd == null || maxBufferSize > this.toAdd.size()) break;
                    this.addModel(this.toAdd);
                    this.toAdd = null;
                    break;
                }
                case DELETE: {
                    if (this.toAdd != null) {
                        this.addModel(this.toAdd);
                        this.toAdd = null;
                    }
                    if (this.toRemove == null || maxBufferSize > this.toRemove.size()) break;
                    this.removeModel(this.toRemove);
                    this.toRemove = null;
                    break;
                }
                case GET: 
                case UPDATE: 
                case COMMIT: 
                case PREPARE: 
                case QUERY: 
                case SIZE: {
                    if (this.toAdd != null) {
                        this.addModel(this.toAdd);
                        this.toAdd = null;
                    }
                    if (this.toRemove == null) break;
                    this.removeModel(this.toRemove);
                    this.toRemove = null;
                    break;
                }
                case ROLLBACK: {
                    this.toAdd = null;
                    this.toRemove = null;
                }
            }
        }
    }

    protected void removeWithoutCommit(Resource subject, IRI predicate, Value object, Resource ... contexts) throws RepositoryException {
        if (this.getRepository().useCompatibleMode()) {
            this.txn.add((TransactionOperation)new RemoveStatementsOperation(subject, predicate, object, contexts));
            return;
        }
        this.flushTransactionState(Protocol.Action.DELETE);
        if (this.toRemove == null) {
            this.toRemove = new LinkedHashModel();
        }
        if (subject == null) {
            subject = SESAME.WILDCARD;
        }
        if (predicate == null) {
            predicate = SESAME.WILDCARD;
        }
        if (object == null) {
            object = SESAME.WILDCARD;
        }
        this.toRemove.add(subject, predicate, object, contexts);
    }

    public void clear(Resource ... contexts) throws RepositoryException {
        boolean localTransaction = this.startLocalTransaction();
        if (this.getRepository().useCompatibleMode()) {
            this.txn.add((TransactionOperation)new ClearOperation(contexts));
        } else {
            this.remove(null, null, null, contexts);
        }
        this.conditionalCommit(localTransaction);
    }

    public void removeNamespace(String prefix) throws RepositoryException {
        if (prefix == null) {
            throw new NullPointerException("prefix must not be null");
        }
        boolean localTransaction = this.startLocalTransaction();
        try {
            if (this.getRepository().useCompatibleMode()) {
                this.txn.add((TransactionOperation)new RemoveNamespaceOperation(prefix));
            } else {
                this.client.removeNamespacePrefix(prefix);
            }
            this.conditionalCommit(localTransaction);
        }
        catch (IOException e) {
            this.conditionalRollback(localTransaction);
            throw new RepositoryException((Throwable)e);
        }
    }

    public void clearNamespaces() throws RepositoryException {
        if (this.getRepository().useCompatibleMode()) {
            boolean localTransaction = this.startLocalTransaction();
            this.txn.add((TransactionOperation)new ClearNamespacesOperation());
            this.conditionalCommit(localTransaction);
            return;
        }
        try {
            this.client.clearNamespaces();
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public void setNamespace(String prefix, String name) throws RepositoryException {
        if (prefix == null) {
            throw new NullPointerException("prefix must not be null");
        }
        if (name == null) {
            throw new NullPointerException("name must not be null");
        }
        if (this.getRepository().useCompatibleMode()) {
            boolean localTransaction = this.startLocalTransaction();
            this.txn.add((TransactionOperation)new SetNamespaceOperation(prefix, name));
            this.conditionalCommit(localTransaction);
            return;
        }
        try {
            this.client.setNamespacePrefix(prefix, name);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public RepositoryResult<Namespace> getNamespaces() throws RepositoryException {
        try {
            ArrayList<SimpleNamespace> namespaceList = new ArrayList<SimpleNamespace>();
            try (TupleQueryResult namespaces = this.client.getNamespaces();){
                while (namespaces.hasNext()) {
                    BindingSet bindingSet = (BindingSet)namespaces.next();
                    Value prefix = bindingSet.getValue("prefix");
                    Value namespace = bindingSet.getValue("namespace");
                    if (!(prefix instanceof Literal) || !(namespace instanceof Literal)) continue;
                    String prefixStr = ((Literal)prefix).getLabel();
                    String namespaceStr = ((Literal)namespace).getLabel();
                    namespaceList.add(new SimpleNamespace(prefixStr, namespaceStr));
                }
            }
            return this.createRepositoryResult(namespaceList);
        }
        catch (IOException | QueryEvaluationException e) {
            throw new RepositoryException(e);
        }
    }

    public String getNamespace(String prefix) throws RepositoryException {
        if (prefix == null) {
            throw new NullPointerException("prefix must not be null");
        }
        try {
            return this.client.getNamespace(prefix);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    protected void scheduleUpdate(HTTPUpdate update) {
        SPARQLUpdateOperation op = new SPARQLUpdateOperation();
        op.setUpdateString(update.getQueryString());
        op.setBaseURI(update.getBaseURI());
        op.setBindings(update.getBindingsArray());
        op.setIncludeInferred(update.getIncludeInferred());
        op.setDataset(update.getDataset());
        this.txn.add((TransactionOperation)op);
    }

    protected <E> RepositoryResult<E> createRepositoryResult(Iterable<? extends E> elements) {
        return new RepositoryResult((CloseableIteration)new CloseableIteratorIteration(elements.iterator()));
    }

    public Update prepareUpdate(QueryLanguage ql, String update, String baseURI) throws RepositoryException, MalformedQueryException {
        return new HTTPUpdate(this, ql, update, baseURI);
    }

    protected void verifyIsOpen() throws RepositoryException {
        if (!this.isOpen()) {
            throw new RepositoryException("Connection has been closed");
        }
    }

    protected void verifyTxnActive() throws RepositoryException {
        if (!this.isActive()) {
            throw new RepositoryException("Connection does not have an active transaction");
        }
    }

    protected void verifyNotTxnActive(String msg) throws RepositoryException {
        if (this.isActive()) {
            throw new RepositoryException(msg);
        }
    }

    public boolean isActive() throws UnknownTransactionStateException, RepositoryException {
        return this.active;
    }

    protected RDF4JProtocolSession getSesameSession() {
        return this.client;
    }
}

