/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.queryrender.serql;

import org.eclipse.rdf4j.query.algebra.And;
import org.eclipse.rdf4j.query.algebra.BNodeGenerator;
import org.eclipse.rdf4j.query.algebra.BinaryValueOperator;
import org.eclipse.rdf4j.query.algebra.Bound;
import org.eclipse.rdf4j.query.algebra.Compare;
import org.eclipse.rdf4j.query.algebra.CompareAll;
import org.eclipse.rdf4j.query.algebra.CompareAny;
import org.eclipse.rdf4j.query.algebra.Count;
import org.eclipse.rdf4j.query.algebra.Datatype;
import org.eclipse.rdf4j.query.algebra.Exists;
import org.eclipse.rdf4j.query.algebra.FunctionCall;
import org.eclipse.rdf4j.query.algebra.In;
import org.eclipse.rdf4j.query.algebra.IsBNode;
import org.eclipse.rdf4j.query.algebra.IsLiteral;
import org.eclipse.rdf4j.query.algebra.IsResource;
import org.eclipse.rdf4j.query.algebra.IsURI;
import org.eclipse.rdf4j.query.algebra.Label;
import org.eclipse.rdf4j.query.algebra.Lang;
import org.eclipse.rdf4j.query.algebra.LangMatches;
import org.eclipse.rdf4j.query.algebra.Like;
import org.eclipse.rdf4j.query.algebra.LocalName;
import org.eclipse.rdf4j.query.algebra.MathExpr;
import org.eclipse.rdf4j.query.algebra.Max;
import org.eclipse.rdf4j.query.algebra.Min;
import org.eclipse.rdf4j.query.algebra.Namespace;
import org.eclipse.rdf4j.query.algebra.Not;
import org.eclipse.rdf4j.query.algebra.Or;
import org.eclipse.rdf4j.query.algebra.Regex;
import org.eclipse.rdf4j.query.algebra.SameTerm;
import org.eclipse.rdf4j.query.algebra.Str;
import org.eclipse.rdf4j.query.algebra.UnaryValueOperator;
import org.eclipse.rdf4j.query.algebra.ValueConstant;
import org.eclipse.rdf4j.query.algebra.ValueExpr;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;
import org.eclipse.rdf4j.queryrender.BaseTupleExprRenderer;
import org.eclipse.rdf4j.queryrender.RenderUtils;

class SerqlValueExprRenderer
extends AbstractQueryModelVisitor<Exception> {
    private StringBuffer mBuffer = new StringBuffer();

    SerqlValueExprRenderer() {
    }

    public void reset() {
        this.mBuffer = new StringBuffer();
    }

    public String render(ValueExpr theExpr) throws Exception {
        this.reset();
        theExpr.visit(this);
        return this.mBuffer.toString();
    }

    @Override
    public void meet(Bound theOp) throws Exception {
        this.mBuffer.append(" bound(");
        theOp.getArg().visit(this);
        this.mBuffer.append(")");
    }

    @Override
    public void meet(Var theVar) throws Exception {
        if (theVar.isAnonymous() && !theVar.hasValue()) {
            this.mBuffer.append(BaseTupleExprRenderer.scrubVarName(theVar.getName().substring(1)));
        } else if (theVar.hasValue()) {
            this.mBuffer.append(RenderUtils.getSerqlQueryString(theVar.getValue()));
        } else {
            this.mBuffer.append(theVar.getName());
        }
    }

    @Override
    public void meet(BNodeGenerator theGen) throws Exception {
        this.mBuffer.append(theGen.getSignature());
    }

    @Override
    public void meet(MathExpr theOp) throws Exception {
        this.mBuffer.append("(");
        theOp.getLeftArg().visit(this);
        this.mBuffer.append(" ").append(theOp.getOperator().getSymbol()).append(" ");
        theOp.getRightArg().visit(this);
        this.mBuffer.append(")");
    }

    @Override
    public void meet(Compare theOp) throws Exception {
        this.mBuffer.append("(");
        theOp.getLeftArg().visit(this);
        this.mBuffer.append(" ").append(theOp.getOperator().getSymbol()).append(" ");
        theOp.getRightArg().visit(this);
        this.mBuffer.append(")");
    }

    @Override
    public void meet(Exists theOp) throws Exception {
        this.mBuffer.append(" exists(");
        theOp.getSubQuery().visit(this);
        this.mBuffer.append(")");
    }

    @Override
    public void meet(In theOp) throws Exception {
        theOp.getArg().visit(this);
        this.mBuffer.append(" in ");
        this.mBuffer.append("(");
        theOp.getSubQuery().visit(this);
        this.mBuffer.append(")");
    }

    @Override
    public void meet(CompareAll theOp) throws Exception {
        this.mBuffer.append("(");
        theOp.getArg().visit(this);
        this.mBuffer.append(" ").append(theOp.getOperator().getSymbol()).append(" all ");
        this.mBuffer.append("(");
        theOp.getSubQuery().visit(this);
        this.mBuffer.append(")");
        this.mBuffer.append(")");
    }

    @Override
    public void meet(ValueConstant theVal) throws Exception {
        this.mBuffer.append(RenderUtils.getSerqlQueryString(theVal.getValue()));
    }

    @Override
    public void meet(FunctionCall theOp) throws Exception {
        this.mBuffer.append(theOp.getURI()).append("(");
        boolean aFirst = true;
        for (ValueExpr aArg : theOp.getArgs()) {
            if (!aFirst) {
                this.mBuffer.append(", ");
            } else {
                aFirst = false;
            }
            aArg.visit(this);
        }
        this.mBuffer.append(")");
    }

    @Override
    public void meet(CompareAny theOp) throws Exception {
        this.mBuffer.append("(");
        theOp.getArg().visit(this);
        this.mBuffer.append(" ").append(theOp.getOperator().getSymbol()).append(" any ");
        this.mBuffer.append("(");
        theOp.getSubQuery().visit(this);
        this.mBuffer.append(")");
        this.mBuffer.append(")");
    }

    @Override
    public void meet(Regex theOp) throws Exception {
        this.mBuffer.append(" regex(");
        theOp.getArg().visit(this);
        this.mBuffer.append(", ");
        theOp.getPatternArg().visit(this);
        if (theOp.getFlagsArg() != null) {
            this.mBuffer.append(",");
            theOp.getFlagsArg().visit(this);
        }
        this.mBuffer.append(")");
    }

    @Override
    public void meet(LangMatches theOp) throws Exception {
        this.mBuffer.append(" langMatches(");
        theOp.getLeftArg().visit(this);
        this.mBuffer.append(", ");
        theOp.getRightArg().visit(this);
        this.mBuffer.append(")");
    }

    @Override
    public void meet(SameTerm theOp) throws Exception {
        this.mBuffer.append(" sameTerm(");
        theOp.getLeftArg().visit(this);
        this.mBuffer.append(", ");
        theOp.getRightArg().visit(this);
        this.mBuffer.append(")");
    }

    @Override
    public void meet(And theAnd) throws Exception {
        this.binaryMeet("and", theAnd);
    }

    @Override
    public void meet(Or theOr) throws Exception {
        this.binaryMeet("or", theOr);
    }

    @Override
    public void meet(Not theNot) throws Exception {
        this.unaryMeet("not", theNot);
    }

    @Override
    public void meet(Count theOp) throws Exception {
        this.unaryMeet("count", theOp);
    }

    @Override
    public void meet(Datatype theOp) throws Exception {
        this.unaryMeet("datatype", theOp);
    }

    @Override
    public void meet(IsBNode theOp) throws Exception {
        this.unaryMeet("isBNode", theOp);
    }

    @Override
    public void meet(IsLiteral theOp) throws Exception {
        this.unaryMeet("isLiteral", theOp);
    }

    @Override
    public void meet(IsResource theOp) throws Exception {
        this.unaryMeet("isResource", theOp);
    }

    @Override
    public void meet(IsURI theOp) throws Exception {
        this.unaryMeet("isURI", theOp);
    }

    @Override
    public void meet(Label theOp) throws Exception {
        this.unaryMeet("label", theOp);
    }

    @Override
    public void meet(Lang theOp) throws Exception {
        this.unaryMeet("lang", theOp);
    }

    @Override
    public void meet(Like theOp) throws Exception {
        theOp.getArg().visit(this);
        this.mBuffer.append(" like \"").append(theOp.getPattern()).append("\"");
        if (!theOp.isCaseSensitive()) {
            this.mBuffer.append(" ignore case");
        }
    }

    @Override
    public void meet(LocalName theOp) throws Exception {
        this.unaryMeet("localName", theOp);
    }

    @Override
    public void meet(Min theOp) throws Exception {
        this.unaryMeet("min", theOp);
    }

    @Override
    public void meet(Max theOp) throws Exception {
        this.unaryMeet("max", theOp);
    }

    @Override
    public void meet(Namespace theOp) throws Exception {
        this.unaryMeet("namespace", theOp);
    }

    @Override
    public void meet(Str theOp) throws Exception {
        this.unaryMeet("str", theOp);
    }

    private void binaryMeet(String theOpStr, BinaryValueOperator theOp) throws Exception {
        this.mBuffer.append(" (");
        theOp.getLeftArg().visit(this);
        this.mBuffer.append(" ").append(theOpStr).append(" ");
        theOp.getRightArg().visit(this);
        this.mBuffer.append(")");
    }

    private void unaryMeet(String theOpStr, UnaryValueOperator theOp) throws Exception {
        this.mBuffer.append(" ").append(theOpStr).append("(");
        theOp.getArg().visit(this);
        this.mBuffer.append(")");
    }
}

