/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.ConvertingIteration;
import org.eclipse.rdf4j.common.iteration.FilterIteration;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.BooleanQuery;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.GraphQuery;
import org.eclipse.rdf4j.query.GraphQueryResult;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryResultHandler;
import org.eclipse.rdf4j.query.QueryResults;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.TupleQueryResultHandler;
import org.eclipse.rdf4j.query.TupleQueryResultHandlerException;
import org.eclipse.rdf4j.query.Update;
import org.eclipse.rdf4j.query.UpdateExecutionException;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.UpdateExpr;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryPreparer;
import org.eclipse.rdf4j.query.algebra.evaluation.TripleSource;
import org.eclipse.rdf4j.query.explanation.Explanation;
import org.eclipse.rdf4j.query.impl.IteratingGraphQueryResult;
import org.eclipse.rdf4j.query.impl.IteratingTupleQueryResult;
import org.eclipse.rdf4j.query.parser.ParsedBooleanQuery;
import org.eclipse.rdf4j.query.parser.ParsedGraphQuery;
import org.eclipse.rdf4j.query.parser.ParsedQuery;
import org.eclipse.rdf4j.query.parser.ParsedTupleQuery;
import org.eclipse.rdf4j.query.parser.ParsedUpdate;
import org.eclipse.rdf4j.query.parser.impl.AbstractParserQuery;
import org.eclipse.rdf4j.query.parser.impl.AbstractParserUpdate;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;

public abstract class AbstractQueryPreparer
implements QueryPreparer {
    private final TripleSource tripleSource;

    public AbstractQueryPreparer(TripleSource tripleSource) {
        this.tripleSource = tripleSource;
    }

    @Override
    public BooleanQuery prepare(ParsedBooleanQuery q) {
        return new BooleanQueryImpl(q);
    }

    @Override
    public TupleQuery prepare(ParsedTupleQuery q) {
        return new TupleQueryImpl(q);
    }

    @Override
    public GraphQuery prepare(ParsedGraphQuery q) {
        return new GraphQueryImpl(q);
    }

    @Override
    public Update prepare(ParsedUpdate u) {
        return new UpdateImpl(u);
    }

    @Override
    public TripleSource getTripleSource() {
        return this.tripleSource;
    }

    protected abstract CloseableIteration<? extends BindingSet, QueryEvaluationException> evaluate(TupleExpr var1, Dataset var2, BindingSet var3, boolean var4, int var5) throws QueryEvaluationException;

    protected abstract void execute(UpdateExpr var1, Dataset var2, BindingSet var3, boolean var4, int var5) throws UpdateExecutionException;

    class UpdateImpl
    extends AbstractParserUpdate {
        UpdateImpl(ParsedUpdate update) {
            super(update);
        }

        public void execute() throws UpdateExecutionException {
            ParsedUpdate parsedUpdate = this.getParsedUpdate();
            List updateExprs = parsedUpdate.getUpdateExprs();
            Map datasetMapping = parsedUpdate.getDatasetMapping();
            for (UpdateExpr updateExpr : updateExprs) {
                Dataset activeDataset = this.getMergedDataset((Dataset)datasetMapping.get(updateExpr));
                try {
                    AbstractQueryPreparer.this.execute(updateExpr, activeDataset, this.getBindings(), this.getIncludeInferred(), this.getMaxExecutionTime());
                }
                catch (UpdateExecutionException e) {
                    if (updateExpr.isSilent()) continue;
                    throw e;
                }
            }
        }
    }

    class GraphQueryImpl
    extends AbstractParserQuery
    implements GraphQuery {
        GraphQueryImpl(ParsedGraphQuery query) {
            super((ParsedQuery)query);
        }

        public ParsedGraphQuery getParsedQuery() {
            return (ParsedGraphQuery)super.getParsedQuery();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public GraphQueryResult evaluate() throws QueryEvaluationException {
            CloseableIteration<? extends BindingSet, QueryEvaluationException> bindingsIter1 = null;
            FilterIteration<BindingSet, QueryEvaluationException> bindingsIter2 = null;
            CloseableIteration bindingsIter3 = null;
            ConvertingIteration<BindingSet, Statement, QueryEvaluationException> stIter = null;
            IteratingGraphQueryResult result = null;
            boolean allGood = false;
            try {
                TupleExpr tupleExpr = this.getParsedQuery().getTupleExpr();
                bindingsIter1 = AbstractQueryPreparer.this.evaluate(tupleExpr, this.getActiveDataset(), this.getBindings(), this.getIncludeInferred(), this.getMaxExecutionTime());
                bindingsIter2 = new FilterIteration<BindingSet, QueryEvaluationException>(bindingsIter1){

                    protected boolean accept(BindingSet bindingSet) {
                        Value context = bindingSet.getValue("context");
                        return bindingSet.getValue("subject") instanceof Resource && bindingSet.getValue("predicate") instanceof IRI && bindingSet.getValue("object") instanceof Value && (context == null || context instanceof Resource);
                    }
                };
                bindingsIter3 = this.enforceMaxQueryTime((CloseableIteration)bindingsIter2);
                stIter = new ConvertingIteration<BindingSet, Statement, QueryEvaluationException>((Iteration)bindingsIter3){
                    private final ValueFactory vf;
                    {
                        this.vf = AbstractQueryPreparer.this.tripleSource.getValueFactory();
                    }

                    protected Statement convert(BindingSet bindingSet) {
                        Resource subject = (Resource)bindingSet.getValue("subject");
                        IRI predicate = (IRI)bindingSet.getValue("predicate");
                        Value object = bindingSet.getValue("object");
                        Resource context = (Resource)bindingSet.getValue("context");
                        if (context == null) {
                            return this.vf.createStatement(subject, predicate, object);
                        }
                        return this.vf.createStatement(subject, predicate, object, context);
                    }
                };
                result = new IteratingGraphQueryResult(this.getParsedQuery().getQueryNamespaces(), (CloseableIteration)stIter);
                allGood = true;
                IteratingGraphQueryResult iteratingGraphQueryResult = result;
                return iteratingGraphQueryResult;
            }
            finally {
                if (!allGood) {
                    try {
                        if (result != null) {
                            result.close();
                        }
                    }
                    finally {
                        try {
                            if (stIter != null) {
                                stIter.close();
                            }
                        }
                        finally {
                            try {
                                if (bindingsIter3 != null) {
                                    bindingsIter3.close();
                                }
                            }
                            finally {
                                try {
                                    if (bindingsIter2 != null) {
                                        bindingsIter2.close();
                                    }
                                }
                                finally {
                                    if (bindingsIter1 != null) {
                                        bindingsIter1.close();
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }

        public void evaluate(RDFHandler handler) throws QueryEvaluationException, RDFHandlerException {
            GraphQueryResult queryResult = this.evaluate();
            QueryResults.report((GraphQueryResult)queryResult, (RDFHandler)handler);
        }

        public Explanation explain(Explanation.Level level) {
            throw new UnsupportedOperationException();
        }
    }

    class TupleQueryImpl
    extends AbstractParserQuery
    implements TupleQuery {
        TupleQueryImpl(ParsedTupleQuery query) {
            super((ParsedQuery)query);
        }

        public ParsedTupleQuery getParsedQuery() {
            return (ParsedTupleQuery)super.getParsedQuery();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TupleQueryResult evaluate() throws QueryEvaluationException {
            CloseableIteration<? extends BindingSet, QueryEvaluationException> bindingsIter1 = null;
            CloseableIteration bindingsIter2 = null;
            IteratingTupleQueryResult result = null;
            boolean allGood = false;
            try {
                TupleExpr tupleExpr = this.getParsedQuery().getTupleExpr();
                bindingsIter1 = AbstractQueryPreparer.this.evaluate(tupleExpr, this.getActiveDataset(), this.getBindings(), this.getIncludeInferred(), this.getMaxExecutionTime());
                bindingsIter2 = this.enforceMaxQueryTime(bindingsIter1);
                result = new IteratingTupleQueryResult(new ArrayList(tupleExpr.getBindingNames()), bindingsIter2);
                allGood = true;
                IteratingTupleQueryResult iteratingTupleQueryResult = result;
                return iteratingTupleQueryResult;
            }
            finally {
                if (!allGood) {
                    try {
                        if (result != null) {
                            result.close();
                        }
                    }
                    finally {
                        try {
                            if (bindingsIter2 != null) {
                                bindingsIter2.close();
                            }
                        }
                        finally {
                            if (bindingsIter1 != null) {
                                bindingsIter1.close();
                            }
                        }
                    }
                }
            }
        }

        public void evaluate(TupleQueryResultHandler handler) throws QueryEvaluationException, TupleQueryResultHandlerException {
            TupleQueryResult queryResult = this.evaluate();
            QueryResults.report((TupleQueryResult)queryResult, (QueryResultHandler)handler);
        }

        public Explanation explain(Explanation.Level level) {
            throw new UnsupportedOperationException();
        }
    }

    class BooleanQueryImpl
    extends AbstractParserQuery
    implements BooleanQuery {
        BooleanQueryImpl(ParsedBooleanQuery query) {
            super((ParsedQuery)query);
        }

        public ParsedBooleanQuery getParsedQuery() {
            return (ParsedBooleanQuery)super.getParsedQuery();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean evaluate() throws QueryEvaluationException {
            CloseableIteration<? extends BindingSet, QueryEvaluationException> bindingsIter1 = null;
            CloseableIteration bindingsIter2 = null;
            try {
                ParsedBooleanQuery parsedBooleanQuery = this.getParsedQuery();
                TupleExpr tupleExpr = parsedBooleanQuery.getTupleExpr();
                Dataset dataset = this.getDataset();
                if (dataset == null) {
                    dataset = parsedBooleanQuery.getDataset();
                }
                bindingsIter1 = AbstractQueryPreparer.this.evaluate(tupleExpr, dataset, this.getBindings(), this.getIncludeInferred(), this.getMaxExecutionTime());
                bindingsIter2 = this.enforceMaxQueryTime(bindingsIter1);
                boolean bl = bindingsIter2.hasNext();
                return bl;
            }
            finally {
                try {
                    if (bindingsIter2 != null) {
                        bindingsIter2.close();
                    }
                }
                finally {
                    if (bindingsIter1 != null) {
                        bindingsIter1.close();
                    }
                }
            }
        }

        public Explanation explain(Explanation.Level level) {
            throw new UnsupportedOperationException();
        }
    }
}

