/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents;

import java.math.BigInteger;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.util.Values;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.sail.shacl.SourceConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.SimpleAbstractConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.FilterPlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.MaxLengthFilter;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;

public class MaxLengthConstraintComponent
extends SimpleAbstractConstraintComponent {
    long maxLength;

    public MaxLengthConstraintComponent(long maxLength) {
        this.maxLength = maxLength;
    }

    @Override
    public void toModel(Resource subject, IRI predicate, Model model, Set<Resource> cycleDetection) {
        model.add(subject, SHACL.MAX_LENGTH, (Value)Values.literal(BigInteger.valueOf(this.maxLength)), new Resource[0]);
    }

    @Override
    String getSparqlFilterExpression(String varName, boolean negated) {
        if (negated) {
            return "STRLEN(STR(?" + varName + ")) <= " + this.maxLength;
        }
        return "STRLEN(STR(?" + varName + ")) > " + this.maxLength;
    }

    @Override
    Function<PlanNode, FilterPlanNode> getFilterAttacher() {
        return parent -> new MaxLengthFilter((PlanNode)parent, this.maxLength);
    }

    @Override
    public SourceConstraintComponent getConstraintComponent() {
        return SourceConstraintComponent.MaxLengthConstraintComponent;
    }

    @Override
    public ConstraintComponent deepClone() {
        return new MaxLengthConstraintComponent(this.maxLength);
    }
}

