/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.planNodes;

import java.util.ArrayDeque;
import java.util.Objects;
import java.util.function.Function;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.parser.ParsedQuery;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.memory.MemoryStoreConnection;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.AbstractBulkJoinPlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.LoggingCloseableIteration;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNodeHelper;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationExecutionLogger;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTupleHelper;

public class BulkedExternalLeftOuterJoin
extends AbstractBulkJoinPlanNode {
    private final SailConnection connection;
    private final PlanNode leftNode;
    private ParsedQuery parsedQuery;
    private final boolean skipBasedOnPreviousConnection;
    private final SailConnection previousStateConnection;
    private final String query;
    private boolean printed = false;

    public BulkedExternalLeftOuterJoin(PlanNode leftNode, SailConnection connection, String query, boolean skipBasedOnPreviousConnection, SailConnection previousStateConnection, Function<BindingSet, ValidationTuple> mapper) {
        this.leftNode = leftNode = PlanNodeHelper.handleSorting(this, leftNode);
        this.query = query;
        this.connection = connection;
        this.skipBasedOnPreviousConnection = skipBasedOnPreviousConnection;
        this.previousStateConnection = previousStateConnection;
        this.mapper = mapper;
    }

    @Override
    public CloseableIteration<? extends ValidationTuple, SailException> iterator() {
        return new LoggingCloseableIteration(this, this.validationExecutionLogger){
            final ArrayDeque<ValidationTuple> left;
            final ArrayDeque<ValidationTuple> right;
            final CloseableIteration<? extends ValidationTuple, SailException> leftNodeIterator;
            {
                this.left = new ArrayDeque();
                this.right = new ArrayDeque();
                this.leftNodeIterator = BulkedExternalLeftOuterJoin.this.leftNode.iterator();
            }

            private void calculateNext() {
                if (!this.left.isEmpty()) {
                    return;
                }
                while (this.left.size() < 200 && this.leftNodeIterator.hasNext()) {
                    this.left.addFirst((ValidationTuple)this.leftNodeIterator.next());
                }
                if (this.left.isEmpty()) {
                    return;
                }
                if (BulkedExternalLeftOuterJoin.this.parsedQuery == null) {
                    BulkedExternalLeftOuterJoin.this.parsedQuery = BulkedExternalLeftOuterJoin.this.parseQuery(BulkedExternalLeftOuterJoin.this.query);
                }
                BulkedExternalLeftOuterJoin.this.runQuery(this.left, this.right, BulkedExternalLeftOuterJoin.this.connection, BulkedExternalLeftOuterJoin.this.parsedQuery, BulkedExternalLeftOuterJoin.this.skipBasedOnPreviousConnection, BulkedExternalLeftOuterJoin.this.previousStateConnection, BulkedExternalLeftOuterJoin.this.mapper);
            }

            public void close() throws SailException {
                this.leftNodeIterator.close();
            }

            @Override
            protected boolean localHasNext() throws SailException {
                this.calculateNext();
                return !this.left.isEmpty();
            }

            @Override
            protected ValidationTuple loggingNext() throws SailException {
                this.calculateNext();
                if (!this.left.isEmpty()) {
                    ValidationTuple rightPeek;
                    ValidationTuple leftPeek = this.left.peekLast();
                    ValidationTuple joined = null;
                    if (!this.right.isEmpty() && (rightPeek = this.right.peekLast()).sameTargetAs(leftPeek)) {
                        joined = ValidationTupleHelper.join(leftPeek, rightPeek);
                        this.right.removeLast();
                        ValidationTuple rightPeek2 = this.right.peekLast();
                        if (rightPeek2 == null || !rightPeek2.sameTargetAs(leftPeek)) {
                            this.left.removeLast();
                        }
                    }
                    if (joined != null) {
                        return joined;
                    }
                    this.left.removeLast();
                    return leftPeek;
                }
                return null;
            }
        };
    }

    @Override
    public int depth() {
        return this.leftNode.depth() + 1;
    }

    @Override
    public void getPlanAsGraphvizDot(StringBuilder stringBuilder) {
        if (this.printed) {
            return;
        }
        this.printed = true;
        stringBuilder.append(this.getId() + " [label=\"" + StringEscapeUtils.escapeJava((String)this.toString()) + "\"];").append("\n");
        this.leftNode.getPlanAsGraphvizDot(stringBuilder);
        if (this.connection instanceof MemoryStoreConnection) {
            stringBuilder.append(System.identityHashCode(((MemoryStoreConnection)this.connection).getSail()) + " -> " + this.getId() + " [label=\"right\"]").append("\n");
        } else {
            stringBuilder.append(System.identityHashCode(this.connection) + " -> " + this.getId() + " [label=\"right\"]").append("\n");
        }
        if (this.skipBasedOnPreviousConnection) {
            stringBuilder.append(System.identityHashCode(this.previousStateConnection) + " -> " + this.getId() + " [label=\"skip if not present\"]").append("\n");
        }
        stringBuilder.append(this.leftNode.getId() + " -> " + this.getId() + " [label=\"left\"]").append("\n");
    }

    public String toString() {
        return "BulkedExternalLeftOuterJoin{query=" + this.query.replace("\n", "  ") + '}';
    }

    @Override
    public String getId() {
        return System.identityHashCode(this) + "";
    }

    @Override
    public void receiveLogger(ValidationExecutionLogger validationExecutionLogger) {
        this.validationExecutionLogger = validationExecutionLogger;
        this.leftNode.receiveLogger(validationExecutionLogger);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BulkedExternalLeftOuterJoin that = (BulkedExternalLeftOuterJoin)o;
        return this.skipBasedOnPreviousConnection == that.skipBasedOnPreviousConnection && this.connection.equals(that.connection) && this.leftNode.equals(that.leftNode) && Objects.equals(this.previousStateConnection, that.previousStateConnection) && this.query.equals(that.query);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.connection, this.leftNode, this.skipBasedOnPreviousConnection, this.previousStateConnection, this.query);
    }
}

