/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.planNodes;

import java.util.Objects;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.LoggingCloseableIteration;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNodeHelper;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationExecutionLogger;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTupleHelper;

public class EqualsJoinValue
implements PlanNode {
    private final PlanNode left;
    private final PlanNode right;
    private final boolean useAsFilter;
    private StackTraceElement[] stackTrace;
    private boolean printed = false;
    private ValidationExecutionLogger validationExecutionLogger;

    public EqualsJoinValue(PlanNode left, PlanNode right, boolean useAsFilter) {
        left = PlanNodeHelper.handleSorting(this, left);
        right = PlanNodeHelper.handleSorting(this, right);
        this.left = left;
        this.right = right;
        this.useAsFilter = useAsFilter;
    }

    @Override
    public CloseableIteration<? extends ValidationTuple, SailException> iterator() {
        return new LoggingCloseableIteration(this, this.validationExecutionLogger){
            final CloseableIteration<? extends ValidationTuple, SailException> leftIterator;
            final CloseableIteration<? extends ValidationTuple, SailException> rightIterator;
            ValidationTuple next;
            ValidationTuple nextLeft;
            ValidationTuple nextRight;
            {
                this.leftIterator = EqualsJoinValue.this.left.iterator();
                this.rightIterator = EqualsJoinValue.this.right.iterator();
            }

            void calculateNext() {
                if (this.next != null) {
                    return;
                }
                if (this.nextLeft == null && this.leftIterator.hasNext()) {
                    this.nextLeft = (ValidationTuple)this.leftIterator.next();
                }
                if (this.nextRight == null && this.rightIterator.hasNext()) {
                    this.nextRight = (ValidationTuple)this.rightIterator.next();
                }
                if (this.nextLeft == null) {
                    return;
                }
                while (this.next == null) {
                    if (this.nextRight != null) {
                        if (this.nextLeft.sameTargetAs(this.nextRight) && this.nextLeft.getValue().equals(this.nextRight.getValue())) {
                            this.next = EqualsJoinValue.this.useAsFilter ? this.nextLeft : ValidationTupleHelper.join(this.nextLeft, this.nextRight);
                            this.nextRight = null;
                            continue;
                        }
                        int compareTo = this.nextLeft.compareActiveTarget(this.nextRight);
                        if (compareTo == 0) {
                            compareTo = this.nextLeft.compareValue(this.nextRight);
                        }
                        if (compareTo < 0) {
                            if (this.leftIterator.hasNext()) {
                                this.nextLeft = (ValidationTuple)this.leftIterator.next();
                                continue;
                            }
                            this.nextLeft = null;
                            break;
                        }
                        if (this.rightIterator.hasNext()) {
                            this.nextRight = (ValidationTuple)this.rightIterator.next();
                            continue;
                        }
                        this.nextRight = null;
                        break;
                    }
                    return;
                }
            }

            @Override
            public void close() throws SailException {
                this.leftIterator.close();
                this.rightIterator.close();
            }

            @Override
            protected boolean localHasNext() throws SailException {
                this.calculateNext();
                return this.next != null;
            }

            @Override
            protected ValidationTuple loggingNext() throws SailException {
                this.calculateNext();
                ValidationTuple temp = this.next;
                this.next = null;
                return temp;
            }
        };
    }

    @Override
    public int depth() {
        return Math.max(this.left.depth(), this.right.depth()) + 1;
    }

    @Override
    public void getPlanAsGraphvizDot(StringBuilder stringBuilder) {
        if (this.printed) {
            return;
        }
        this.printed = true;
        this.left.getPlanAsGraphvizDot(stringBuilder);
        stringBuilder.append(this.getId() + " [label=\"" + StringEscapeUtils.escapeJava((String)this.toString()) + "\"];").append("\n");
        stringBuilder.append(this.left.getId() + " -> " + this.getId() + " [label=\"left\"];").append("\n");
        stringBuilder.append(this.right.getId() + " -> " + this.getId() + " [label=\"right\"];").append("\n");
        this.right.getPlanAsGraphvizDot(stringBuilder);
    }

    @Override
    public String getId() {
        return System.identityHashCode(this) + "";
    }

    public String toString() {
        return "EqualsJoin{useAsFilter=" + this.useAsFilter + '}';
    }

    @Override
    public void receiveLogger(ValidationExecutionLogger validationExecutionLogger) {
        this.validationExecutionLogger = validationExecutionLogger;
        this.left.receiveLogger(validationExecutionLogger);
        this.right.receiveLogger(validationExecutionLogger);
    }

    @Override
    public boolean producesSorted() {
        return true;
    }

    @Override
    public boolean requiresSorted() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EqualsJoinValue that = (EqualsJoinValue)o;
        return this.useAsFilter == that.useAsFilter && this.left.equals(that.left) && this.right.equals(that.right);
    }

    public int hashCode() {
        return Objects.hash(this.left, this.right, this.useAsFilter);
    }
}

