/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.planNodes;

import java.util.ArrayDeque;
import java.util.Objects;
import java.util.function.Function;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.algebra.evaluation.util.ValueComparator;
import org.eclipse.rdf4j.query.parser.ParsedQuery;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.memory.MemoryStoreConnection;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.AbstractBulkJoinPlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.LoggingCloseableIteration;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNodeHelper;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationExecutionLogger;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTupleHelper;

public class BulkedExternalInnerJoin
extends AbstractBulkJoinPlanNode {
    private static final ValueComparator VALUE_COMPARATOR = new ValueComparator();
    private final SailConnection connection;
    private final PlanNode leftNode;
    private ParsedQuery parsedQuery = null;
    private final boolean skipBasedOnPreviousConnection;
    private final SailConnection previousStateConnection;
    private final String query;
    private boolean printed = false;

    public BulkedExternalInnerJoin(PlanNode leftNode, SailConnection connection, String query, boolean skipBasedOnPreviousConnection, SailConnection previousStateConnection, Function<BindingSet, ValidationTuple> mapper) {
        this.leftNode = leftNode = PlanNodeHelper.handleSorting(this, leftNode);
        this.query = query;
        this.connection = connection;
        this.skipBasedOnPreviousConnection = skipBasedOnPreviousConnection;
        this.mapper = mapper;
        this.previousStateConnection = previousStateConnection;
    }

    @Override
    public CloseableIteration<? extends ValidationTuple, SailException> iterator() {
        return new LoggingCloseableIteration(this, this.validationExecutionLogger){
            final ArrayDeque<ValidationTuple> left;
            final ArrayDeque<ValidationTuple> right;
            final ArrayDeque<ValidationTuple> joined;
            final CloseableIteration<? extends ValidationTuple, SailException> leftNodeIterator;
            {
                this.left = new ArrayDeque();
                this.right = new ArrayDeque();
                this.joined = new ArrayDeque();
                this.leftNodeIterator = BulkedExternalInnerJoin.this.leftNode.iterator();
            }

            private void calculateNext() {
                if (!this.joined.isEmpty()) {
                    return;
                }
                while (this.joined.isEmpty() && this.leftNodeIterator.hasNext()) {
                    while (this.left.size() < 200 && this.leftNodeIterator.hasNext()) {
                        this.left.addFirst((ValidationTuple)this.leftNodeIterator.next());
                    }
                    if (BulkedExternalInnerJoin.this.parsedQuery == null) {
                        BulkedExternalInnerJoin.this.parsedQuery = BulkedExternalInnerJoin.this.parseQuery(BulkedExternalInnerJoin.this.query);
                    }
                    BulkedExternalInnerJoin.this.runQuery(this.left, this.right, BulkedExternalInnerJoin.this.connection, BulkedExternalInnerJoin.this.parsedQuery, BulkedExternalInnerJoin.this.skipBasedOnPreviousConnection, BulkedExternalInnerJoin.this.previousStateConnection, BulkedExternalInnerJoin.this.mapper);
                    while (!this.right.isEmpty()) {
                        ValidationTuple leftPeek = this.left.peekLast();
                        ValidationTuple rightPeek = this.right.peekLast();
                        assert (leftPeek != null);
                        assert (rightPeek != null);
                        assert (leftPeek.getActiveTarget() != null);
                        assert (rightPeek.getActiveTarget() != null);
                        if (rightPeek.sameTargetAs(leftPeek)) {
                            this.joined.addLast(ValidationTupleHelper.join(leftPeek, rightPeek));
                            this.right.removeLast();
                            ValidationTuple rightPeek2 = this.right.peekLast();
                            if (rightPeek2 != null && rightPeek2.sameTargetAs(leftPeek)) continue;
                            this.left.removeLast();
                            continue;
                        }
                        int compare = rightPeek.compareActiveTarget(leftPeek);
                        if (compare < 0) {
                            if (this.right.isEmpty()) {
                                throw new IllegalStateException();
                            }
                            this.right.removeLast();
                            continue;
                        }
                        if (this.left.isEmpty()) {
                            throw new IllegalStateException();
                        }
                        this.left.removeLast();
                    }
                    this.left.clear();
                }
            }

            @Override
            public void localClose() throws SailException {
                this.leftNodeIterator.close();
            }

            @Override
            protected boolean localHasNext() throws SailException {
                this.calculateNext();
                return !this.joined.isEmpty();
            }

            @Override
            protected ValidationTuple loggingNext() throws SailException {
                this.calculateNext();
                return this.joined.removeFirst();
            }
        };
    }

    @Override
    public int depth() {
        return this.leftNode.depth() + 1;
    }

    @Override
    public void getPlanAsGraphvizDot(StringBuilder stringBuilder) {
        if (this.printed) {
            return;
        }
        this.printed = true;
        stringBuilder.append(this.getId() + " [label=\"" + StringEscapeUtils.escapeJava((String)this.toString()) + "\"];").append("\n");
        stringBuilder.append(this.leftNode.getId() + " -> " + this.getId() + " [label=\"left\"]").append("\n");
        if (this.connection instanceof MemoryStoreConnection) {
            stringBuilder.append(System.identityHashCode(((MemoryStoreConnection)this.connection).getSail()) + " -> " + this.getId() + " [label=\"right\"]").append("\n");
        } else {
            stringBuilder.append(System.identityHashCode(this.connection) + " -> " + this.getId() + " [label=\"right\"]").append("\n");
        }
        if (this.skipBasedOnPreviousConnection) {
            stringBuilder.append(System.identityHashCode(this.previousStateConnection) + " -> " + this.getId() + " [label=\"skip if not present\"]").append("\n");
        }
        this.leftNode.getPlanAsGraphvizDot(stringBuilder);
    }

    public String toString() {
        return "BulkedExternalInnerJoin{query=" + this.query.replace("\n", "") + '}';
    }

    @Override
    public String getId() {
        return System.identityHashCode(this) + "";
    }

    @Override
    public void receiveLogger(ValidationExecutionLogger validationExecutionLogger) {
        this.validationExecutionLogger = validationExecutionLogger;
        this.leftNode.receiveLogger(validationExecutionLogger);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BulkedExternalInnerJoin that = (BulkedExternalInnerJoin)o;
        return this.skipBasedOnPreviousConnection == that.skipBasedOnPreviousConnection && this.connection.equals(that.connection) && this.leftNode.equals(that.leftNode) && Objects.equals(this.previousStateConnection, that.previousStateConnection) && this.query.equals(that.query);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.connection, this.leftNode, this.skipBasedOnPreviousConnection, this.previousStateConnection, this.query);
    }
}

