/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.iterator;

import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.ConvertingIteration;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.MultiProjection;
import org.eclipse.rdf4j.query.algebra.Projection;
import org.eclipse.rdf4j.query.algebra.ProjectionElem;
import org.eclipse.rdf4j.query.algebra.ProjectionElemList;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryBindingSet;

public class ProjectionIterator
extends ConvertingIteration<BindingSet, BindingSet, QueryEvaluationException> {
    private final Projection projection;
    private final BindingSet parentBindings;
    private final boolean isOuterProjection;

    public ProjectionIterator(Projection projection, CloseableIteration<BindingSet, QueryEvaluationException> iter, BindingSet parentBindings) throws QueryEvaluationException {
        super(iter);
        this.projection = projection;
        this.parentBindings = parentBindings;
        this.isOuterProjection = this.determineOuterProjection();
    }

    private final boolean determineOuterProjection() {
        Projection ancestor = this.projection;
        while (ancestor.getParentNode() != null) {
            if (!((ancestor = ancestor.getParentNode()) instanceof Projection) && !(ancestor instanceof MultiProjection)) continue;
            return false;
        }
        return true;
    }

    protected BindingSet convert(BindingSet sourceBindings) throws QueryEvaluationException {
        return ProjectionIterator.project(this.projection.getProjectionElemList(), sourceBindings, this.parentBindings, !this.isOuterProjection);
    }

    public static BindingSet project(ProjectionElemList projElemList, BindingSet sourceBindings, BindingSet parentBindings) {
        return ProjectionIterator.project(projElemList, sourceBindings, parentBindings, false);
    }

    public static BindingSet project(ProjectionElemList projElemList, BindingSet sourceBindings, BindingSet parentBindings, boolean includeAllParentBindings) {
        QueryBindingSet resultBindings = new QueryBindingSet();
        if (includeAllParentBindings) {
            resultBindings.addAll(parentBindings);
        }
        for (ProjectionElem pe : projElemList.getElements()) {
            Value targetValue = sourceBindings.getValue(pe.getSourceName());
            if (!includeAllParentBindings && targetValue == null) {
                targetValue = parentBindings.getValue(pe.getSourceName());
            }
            if (targetValue == null) continue;
            resultBindings.setBinding(pe.getTargetName(), targetValue);
        }
        return resultBindings;
    }
}

