/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.console.setting;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.console.setting.ConsoleSetting;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.impl.SimpleNamespace;
import org.eclipse.rdf4j.model.util.Namespaces;
import org.eclipse.rdf4j.model.util.URIUtil;
import org.eclipse.rdf4j.model.vocabulary.ROV;

public class Prefixes
extends ConsoleSetting<Set<Namespace>> {
    public static final String NAME = "prefixes";
    public static final Set<Namespace> DEFAULT = new HashSet<Namespace>(Namespaces.DEFAULT_RDFA11);

    @Override
    public String getHelpLong() {
        return "set prefixes=<default>         Set the prefixes to a default list of prefixes\n    prefixes=<none>            Remove all namespace prefixes\n\tprefixes=prefix ns-url     Set prefix for namespace\n\tprefixes=prefix <none>     Remove namespace prefix\n";
    }

    public Prefixes() {
        super(new HashSet<Namespace>(DEFAULT));
    }

    public Prefixes(Set<Namespace> initValue) {
        super(initValue);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void clear() {
        ((Set)this.get()).clear();
    }

    private void clearNamespace(String prefix) {
        ((Set)this.get()).removeIf(ns -> ns.getPrefix().equals(prefix));
    }

    @Override
    public String getAsString() {
        return ((Set)this.get()).stream().map(ns -> ns.getPrefix() + " " + ns.getName()).sorted().collect(Collectors.joining(","));
    }

    private void setNamespace(String namespace) {
        String[] parts = namespace.split(" ");
        if (parts.length != 2) {
            throw new IllegalArgumentException("Error parsing namespace: " + namespace);
        }
        if (parts[1].equals("<none>")) {
            this.clearNamespace(parts[0]);
            return;
        }
        if (!URIUtil.isValidURIReference((String)parts[1])) {
            throw new IllegalArgumentException("Error parsing namespace URI: " + parts[1]);
        }
        ((Set)this.get()).add(new SimpleNamespace(parts[0], parts[1]));
    }

    @Override
    public void setFromString(String value) throws IllegalArgumentException {
        String[] namespaces;
        if (value == null || value.isEmpty()) {
            throw new IllegalArgumentException("Empty or null namespace value");
        }
        if (value.equals("<none>")) {
            this.clear();
            return;
        }
        if (value.equals("<default>")) {
            this.set(new HashSet<Namespace>(DEFAULT));
            return;
        }
        for (String namespace : namespaces = value.split(",")) {
            this.setNamespace(namespace);
        }
    }

    static {
        DEFAULT.add(ROV.NS);
    }
}

