/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.common.iteration;

import java.util.NoSuchElementException;
import org.eclipse.rdf4j.common.iteration.AbstractCloseableIteration;

public abstract class LookAheadIteration<E, X extends Exception>
extends AbstractCloseableIteration<E, X> {
    private volatile E nextElement;

    protected LookAheadIteration() {
    }

    protected abstract E getNextElement() throws X;

    @Override
    public final boolean hasNext() throws X {
        boolean result;
        if (this.isClosed()) {
            return false;
        }
        boolean bl = result = this.lookAhead() != null;
        if (!result) {
            this.close();
        }
        return result;
    }

    @Override
    public final E next() throws X {
        if (this.isClosed()) {
            throw new NoSuchElementException("The iteration has been closed.");
        }
        E result = this.lookAhead();
        if (result != null) {
            this.nextElement = null;
            return result;
        }
        this.close();
        throw new NoSuchElementException();
    }

    private E lookAhead() throws X {
        E checkElement = this.nextElement;
        if (checkElement == null && !this.isClosed() && (checkElement = (this.nextElement = this.getNextElement())) == null) {
            this.close();
        }
        return checkElement;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void handleClose() throws X {
        try {
            super.handleClose();
        }
        finally {
            this.nextElement = null;
        }
    }
}

