/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.impl;

import com.google.common.base.Stopwatch;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.CloseableIteratorIteration;
import org.eclipse.rdf4j.common.iteration.ConvertingIteration;
import org.eclipse.rdf4j.common.iteration.DelayedIteration;
import org.eclipse.rdf4j.common.iteration.DistinctIteration;
import org.eclipse.rdf4j.common.iteration.EmptyIteration;
import org.eclipse.rdf4j.common.iteration.FilterIteration;
import org.eclipse.rdf4j.common.iteration.IntersectIteration;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.common.iteration.IterationWrapper;
import org.eclipse.rdf4j.common.iteration.LimitIteration;
import org.eclipse.rdf4j.common.iteration.LookAheadIteration;
import org.eclipse.rdf4j.common.iteration.OffsetIteration;
import org.eclipse.rdf4j.common.iteration.ReducedIteration;
import org.eclipse.rdf4j.common.iteration.SingletonIteration;
import org.eclipse.rdf4j.common.iteration.UnionIteration;
import org.eclipse.rdf4j.common.net.ParsedIRI;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Triple;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.datatypes.XMLDatatypeUtil;
import org.eclipse.rdf4j.model.impl.BooleanLiteral;
import org.eclipse.rdf4j.model.util.Literals;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.RDF4J;
import org.eclipse.rdf4j.model.vocabulary.SESAME;
import org.eclipse.rdf4j.model.vocabulary.XSD;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.And;
import org.eclipse.rdf4j.query.algebra.ArbitraryLengthPath;
import org.eclipse.rdf4j.query.algebra.BNodeGenerator;
import org.eclipse.rdf4j.query.algebra.BinaryTupleOperator;
import org.eclipse.rdf4j.query.algebra.BindingSetAssignment;
import org.eclipse.rdf4j.query.algebra.Bound;
import org.eclipse.rdf4j.query.algebra.Coalesce;
import org.eclipse.rdf4j.query.algebra.Compare;
import org.eclipse.rdf4j.query.algebra.CompareAll;
import org.eclipse.rdf4j.query.algebra.CompareAny;
import org.eclipse.rdf4j.query.algebra.Datatype;
import org.eclipse.rdf4j.query.algebra.DescribeOperator;
import org.eclipse.rdf4j.query.algebra.Difference;
import org.eclipse.rdf4j.query.algebra.Distinct;
import org.eclipse.rdf4j.query.algebra.EmptySet;
import org.eclipse.rdf4j.query.algebra.Exists;
import org.eclipse.rdf4j.query.algebra.Extension;
import org.eclipse.rdf4j.query.algebra.Filter;
import org.eclipse.rdf4j.query.algebra.FunctionCall;
import org.eclipse.rdf4j.query.algebra.Group;
import org.eclipse.rdf4j.query.algebra.IRIFunction;
import org.eclipse.rdf4j.query.algebra.If;
import org.eclipse.rdf4j.query.algebra.In;
import org.eclipse.rdf4j.query.algebra.Intersection;
import org.eclipse.rdf4j.query.algebra.IsBNode;
import org.eclipse.rdf4j.query.algebra.IsLiteral;
import org.eclipse.rdf4j.query.algebra.IsNumeric;
import org.eclipse.rdf4j.query.algebra.IsResource;
import org.eclipse.rdf4j.query.algebra.IsURI;
import org.eclipse.rdf4j.query.algebra.Join;
import org.eclipse.rdf4j.query.algebra.Label;
import org.eclipse.rdf4j.query.algebra.Lang;
import org.eclipse.rdf4j.query.algebra.LangMatches;
import org.eclipse.rdf4j.query.algebra.LeftJoin;
import org.eclipse.rdf4j.query.algebra.Like;
import org.eclipse.rdf4j.query.algebra.ListMemberOperator;
import org.eclipse.rdf4j.query.algebra.LocalName;
import org.eclipse.rdf4j.query.algebra.MathExpr;
import org.eclipse.rdf4j.query.algebra.MultiProjection;
import org.eclipse.rdf4j.query.algebra.Namespace;
import org.eclipse.rdf4j.query.algebra.Not;
import org.eclipse.rdf4j.query.algebra.Or;
import org.eclipse.rdf4j.query.algebra.Order;
import org.eclipse.rdf4j.query.algebra.Projection;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.QueryRoot;
import org.eclipse.rdf4j.query.algebra.Reduced;
import org.eclipse.rdf4j.query.algebra.Regex;
import org.eclipse.rdf4j.query.algebra.SameTerm;
import org.eclipse.rdf4j.query.algebra.Service;
import org.eclipse.rdf4j.query.algebra.SingletonSet;
import org.eclipse.rdf4j.query.algebra.Slice;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.Str;
import org.eclipse.rdf4j.query.algebra.TripleRef;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.UnaryTupleOperator;
import org.eclipse.rdf4j.query.algebra.Union;
import org.eclipse.rdf4j.query.algebra.ValueConstant;
import org.eclipse.rdf4j.query.algebra.ValueExpr;
import org.eclipse.rdf4j.query.algebra.ValueExprTripleRef;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.ZeroLengthPath;
import org.eclipse.rdf4j.query.algebra.evaluation.EvaluationStrategy;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryBindingSet;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryOptimizer;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryOptimizerPipeline;
import org.eclipse.rdf4j.query.algebra.evaluation.RDFStarTripleSource;
import org.eclipse.rdf4j.query.algebra.evaluation.TripleSource;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.FederatedService;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.FederatedServiceResolver;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.FederatedServiceResolverClient;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.ServiceJoinIterator;
import org.eclipse.rdf4j.query.algebra.evaluation.function.Function;
import org.eclipse.rdf4j.query.algebra.evaluation.function.FunctionRegistry;
import org.eclipse.rdf4j.query.algebra.evaluation.function.datetime.Now;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.EvaluationStatistics;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.ExternalSet;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.StandardQueryOptimizerPipeline;
import org.eclipse.rdf4j.query.algebra.evaluation.iterator.BadlyDesignedLeftJoinIterator;
import org.eclipse.rdf4j.query.algebra.evaluation.iterator.DescribeIteration;
import org.eclipse.rdf4j.query.algebra.evaluation.iterator.ExtensionIterator;
import org.eclipse.rdf4j.query.algebra.evaluation.iterator.FilterIterator;
import org.eclipse.rdf4j.query.algebra.evaluation.iterator.GroupIterator;
import org.eclipse.rdf4j.query.algebra.evaluation.iterator.HashJoinIteration;
import org.eclipse.rdf4j.query.algebra.evaluation.iterator.JoinIterator;
import org.eclipse.rdf4j.query.algebra.evaluation.iterator.LeftJoinIterator;
import org.eclipse.rdf4j.query.algebra.evaluation.iterator.MultiProjectionIterator;
import org.eclipse.rdf4j.query.algebra.evaluation.iterator.OrderIterator;
import org.eclipse.rdf4j.query.algebra.evaluation.iterator.PathIteration;
import org.eclipse.rdf4j.query.algebra.evaluation.iterator.ProjectionIterator;
import org.eclipse.rdf4j.query.algebra.evaluation.iterator.SPARQLMinusIteration;
import org.eclipse.rdf4j.query.algebra.evaluation.iterator.ZeroLengthPathIteration;
import org.eclipse.rdf4j.query.algebra.evaluation.util.EvaluationStrategies;
import org.eclipse.rdf4j.query.algebra.evaluation.util.MathUtil;
import org.eclipse.rdf4j.query.algebra.evaluation.util.OrderComparator;
import org.eclipse.rdf4j.query.algebra.evaluation.util.QueryEvaluationUtil;
import org.eclipse.rdf4j.query.algebra.evaluation.util.ValueComparator;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.helpers.TupleExprs;
import org.eclipse.rdf4j.query.algebra.helpers.VarNameCollector;
import org.eclipse.rdf4j.query.impl.MapBindingSet;
import org.eclipse.rdf4j.util.UUIDable;

public class StrictEvaluationStrategy
implements EvaluationStrategy,
FederatedServiceResolverClient,
UUIDable {
    protected final TripleSource tripleSource;
    protected final Dataset dataset;
    protected FederatedServiceResolver serviceResolver;
    private Value sharedValueOfNow;
    private final long iterationCacheSyncThreshold;
    private boolean trackResultSize;
    private boolean trackTime;
    private final UUID uuid;
    private QueryOptimizerPipeline pipeline;

    public StrictEvaluationStrategy(TripleSource tripleSource, FederatedServiceResolver serviceResolver) {
        this(tripleSource, null, serviceResolver);
    }

    public StrictEvaluationStrategy(TripleSource tripleSource, Dataset dataset, FederatedServiceResolver serviceResolver) {
        this(tripleSource, dataset, serviceResolver, 0L, new EvaluationStatistics());
    }

    public StrictEvaluationStrategy(TripleSource tripleSource, Dataset dataset, FederatedServiceResolver serviceResolver, long iterationCacheSyncTreshold, EvaluationStatistics evaluationStatistics) {
        this(tripleSource, dataset, serviceResolver, iterationCacheSyncTreshold, evaluationStatistics, false);
    }

    public StrictEvaluationStrategy(TripleSource tripleSource, Dataset dataset, FederatedServiceResolver serviceResolver, long iterationCacheSyncTreshold, EvaluationStatistics evaluationStatistics, boolean trackResultSize) {
        this.tripleSource = tripleSource;
        this.dataset = dataset;
        this.serviceResolver = serviceResolver;
        this.iterationCacheSyncThreshold = iterationCacheSyncTreshold;
        this.pipeline = new StandardQueryOptimizerPipeline(this, tripleSource, evaluationStatistics);
        this.uuid = UUID.randomUUID();
        EvaluationStrategies.register(this);
        this.trackResultSize = trackResultSize;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public void setFederatedServiceResolver(FederatedServiceResolver resolver) {
        this.serviceResolver = resolver;
    }

    @Override
    public FederatedService getService(String serviceUrl) throws QueryEvaluationException {
        return this.serviceResolver.getService(serviceUrl);
    }

    @Override
    public void setOptimizerPipeline(QueryOptimizerPipeline pipeline) {
        Objects.requireNonNull(pipeline);
        this.pipeline = pipeline;
    }

    @Override
    public TupleExpr optimize(TupleExpr expr, EvaluationStatistics evaluationStatistics, BindingSet bindings) {
        for (QueryOptimizer optimizer : this.pipeline.getOptimizers()) {
            optimizer.optimize(expr, this.dataset, bindings);
        }
        return expr;
    }

    @Override
    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(TupleExpr expr, BindingSet bindings) throws QueryEvaluationException {
        Object ret;
        if (expr instanceof StatementPattern) {
            ret = this.evaluate((StatementPattern)expr, bindings);
        } else if (expr instanceof UnaryTupleOperator) {
            ret = this.evaluate((UnaryTupleOperator)expr, bindings);
        } else if (expr instanceof BinaryTupleOperator) {
            ret = this.evaluate((BinaryTupleOperator)expr, bindings);
        } else if (expr instanceof SingletonSet) {
            ret = this.evaluate((SingletonSet)expr, bindings);
        } else if (expr instanceof EmptySet) {
            ret = this.evaluate((EmptySet)expr, bindings);
        } else if (expr instanceof ExternalSet) {
            ret = this.evaluate((ExternalSet)expr, bindings);
        } else if (expr instanceof ZeroLengthPath) {
            ret = this.evaluate((ZeroLengthPath)expr, bindings);
        } else if (expr instanceof ArbitraryLengthPath) {
            ret = this.evaluate((ArbitraryLengthPath)expr, bindings);
        } else if (expr instanceof BindingSetAssignment) {
            ret = this.evaluate((BindingSetAssignment)expr, bindings);
        } else if (expr instanceof TripleRef) {
            ret = this.evaluate((TripleRef)expr, bindings);
        } else {
            if (expr == null) {
                throw new IllegalArgumentException("expr must not be null");
            }
            throw new QueryEvaluationException("Unsupported tuple expr type: " + expr.getClass());
        }
        if (this.trackTime) {
            expr.setTotalTimeNanosActual(Math.max(0L, expr.getTotalTimeNanosActual()));
            ret = new TimedIterator((CloseableIteration<BindingSet, QueryEvaluationException>)ret, (QueryModelNode)expr);
        }
        if (this.trackResultSize) {
            expr.setResultSizeActual(Math.max(0L, expr.getResultSizeActual()));
            ret = new ResultSizeCountingIterator((CloseableIteration<BindingSet, QueryEvaluationException>)ret, (QueryModelNode)expr);
        }
        return ret;
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(ArbitraryLengthPath alp, BindingSet bindings) throws QueryEvaluationException {
        StatementPattern.Scope scope = alp.getScope();
        Var subjectVar = alp.getSubjectVar();
        TupleExpr pathExpression = alp.getPathExpression();
        Var objVar = alp.getObjectVar();
        Var contextVar = alp.getContextVar();
        long minLength = alp.getMinLength();
        return new PathIteration(this, scope, subjectVar, pathExpression, objVar, contextVar, minLength, bindings);
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(ZeroLengthPath zlp, BindingSet bindings) throws QueryEvaluationException {
        Var subjectVar = zlp.getSubjectVar();
        Var objVar = zlp.getObjectVar();
        Var contextVar = zlp.getContextVar();
        Value subj = null;
        try {
            subj = this.evaluate(subjectVar, bindings);
        }
        catch (QueryEvaluationException queryEvaluationException) {
            // empty catch block
        }
        Value obj = null;
        try {
            obj = this.evaluate(objVar, bindings);
        }
        catch (QueryEvaluationException queryEvaluationException) {
            // empty catch block
        }
        if (subj != null && obj != null && !subj.equals(obj)) {
            return new EmptyIteration();
        }
        return this.getZeroLengthPathIterator(bindings, subjectVar, objVar, contextVar, subj, obj);
    }

    protected ZeroLengthPathIteration getZeroLengthPathIterator(BindingSet bindings, Var subjectVar, Var objVar, Var contextVar, Value subj, Value obj) {
        return new ZeroLengthPathIteration(this, subjectVar, objVar, subj, obj, contextVar, bindings);
    }

    @Override
    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(Service service, String serviceUri, CloseableIteration<BindingSet, QueryEvaluationException> bindings) throws QueryEvaluationException {
        try {
            FederatedService fs = this.serviceResolver.getService(serviceUri);
            return fs.evaluate(service, bindings, service.getBaseURI());
        }
        catch (QueryEvaluationException e) {
            if (service.isSilent()) {
                return bindings;
            }
            throw new QueryEvaluationException((Throwable)e);
        }
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(Service service, BindingSet bindings) throws QueryEvaluationException {
        String serviceUri;
        Var serviceRef = service.getServiceRef();
        if (serviceRef.hasValue()) {
            serviceUri = serviceRef.getValue().stringValue();
        } else if (bindings != null && bindings.getValue(serviceRef.getName()) != null) {
            serviceUri = bindings.getBinding(serviceRef.getName()).getValue().stringValue();
        } else {
            throw new QueryEvaluationException("SERVICE variables must be bound at evaluation time.");
        }
        try {
            FederatedService fs = this.serviceResolver.getService(serviceUri);
            HashSet freeVars = new HashSet(service.getServiceVars());
            freeVars.removeAll(bindings.getBindingNames());
            MapBindingSet allBindings = new MapBindingSet();
            for (Object binding : bindings) {
                allBindings.addBinding(binding.getName(), binding.getValue());
            }
            Set<Var> boundVars = this.getBoundVariables(service);
            for (Var boundVar : boundVars) {
                freeVars.remove(boundVar.getName());
                allBindings.addBinding(boundVar.getName(), boundVar.getValue());
            }
            bindings = allBindings;
            String baseUri = service.getBaseURI();
            if (freeVars.isEmpty()) {
                boolean exists = fs.ask(service, bindings, baseUri);
                if (exists) {
                    return new SingletonIteration((Object)bindings);
                }
                return new EmptyIteration();
            }
            return fs.select(service, freeVars, bindings, baseUri);
        }
        catch (RuntimeException e) {
            if (service.isSilent()) {
                return new SingletonIteration((Object)bindings);
            }
            throw e;
        }
    }

    private Set<Var> getBoundVariables(Service service) {
        BoundVarVisitor visitor = new BoundVarVisitor();
        visitor.meet(service);
        return visitor.boundVars;
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(DescribeOperator operator, BindingSet bindings) throws QueryEvaluationException {
        CloseableIteration<BindingSet, QueryEvaluationException> iter = this.evaluate(operator.getArg(), bindings);
        return new DescribeIteration((Iteration<BindingSet, QueryEvaluationException>)iter, this, operator.getBindingNames(), bindings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(StatementPattern statementPattern, final BindingSet bindings) throws QueryEvaluationException {
        subjVar = statementPattern.getSubjectVar();
        predVar = statementPattern.getPredicateVar();
        objVar = statementPattern.getObjectVar();
        conVar = statementPattern.getContextVar();
        subjValue = this.getVarValue(subjVar, bindings);
        predValue = this.getVarValue(predVar, bindings);
        objValue = this.getVarValue(objVar, bindings);
        contextValue = this.getVarValue(conVar, bindings);
        stIter1 = null;
        stIter2 /* !! */  = null;
        stIter3 = null;
        resultingIterator = null;
        if (this.isUnbound(subjVar, bindings) || this.isUnbound(predVar, bindings) || this.isUnbound(objVar, bindings) || this.isUnbound(conVar, bindings)) {
            return new EmptyIteration();
        }
        allGood = false;
        try {
            block97: {
                block98: {
                    block96: {
                        graphs = null;
                        emptyGraph = false;
                        if (this.dataset != null) {
                            if (statementPattern.getScope() == StatementPattern.Scope.DEFAULT_CONTEXTS) {
                                graphs = this.dataset.getDefaultGraphs();
                                emptyGraph = graphs.isEmpty() != false && this.dataset.getNamedGraphs().isEmpty() == false;
                            } else {
                                graphs = this.dataset.getNamedGraphs();
                                v0 = emptyGraph = graphs.isEmpty() != false && this.dataset.getDefaultGraphs().isEmpty() == false;
                            }
                        }
                        if (emptyGraph) {
                            var19_18 = new EmptyIteration();
                            return var19_18;
                        }
                        if (graphs != null && !graphs.isEmpty()) break block96;
                        contexts = contextValue != null ? (RDF4J.NIL.equals((Object)contextValue) || SESAME.NIL.equals((Object)contextValue) ? new Resource[]{null} : new Resource[]{(Resource)contextValue}) : new Resource[]{};
                        ** GOTO lbl50
                    }
                    if (contextValue == null) break block97;
                    if (!graphs.contains(contextValue)) break block98;
                    contexts = new Resource[]{(Resource)contextValue};
                    ** GOTO lbl50
                }
                var19_19 = new EmptyIteration();
                return var19_19;
            }
            try {
                contexts = new Resource[graphs.size()];
                i = 0;
                for (IRI graph : graphs) {
                    context = null;
                    if (!RDF4J.NIL.equals((Object)graph) && !SESAME.NIL.equals((Object)graph)) {
                        context = graph;
                    }
                    contexts[i++] = context;
                }
lbl50:
                // 3 sources

                stIter1 = this.tripleSource.getStatements((Resource)subjValue, (IRI)predValue, objValue, contexts);
                stIter2 /* !! */  = contexts.length == 0 && statementPattern.getScope() == StatementPattern.Scope.NAMED_CONTEXTS ? new FilterIteration<Statement, QueryEvaluationException>(stIter1){

                    protected boolean accept(Statement st) {
                        return st.getContext() != null;
                    }
                } : stIter1;
            }
            catch (ClassCastException e) {
                var17_16 = new EmptyIteration();
                return var17_16;
            }
            stIter3 = new FilterIteration<Statement, QueryEvaluationException>(stIter2 /* !! */ ){

                protected boolean accept(Statement st) {
                    Resource subj = st.getSubject();
                    IRI pred = st.getPredicate();
                    Value obj = st.getObject();
                    Resource context = st.getContext();
                    if (subjVar != null && subjValue == null) {
                        if (subjVar.equals((Object)predVar) && !subj.equals(pred)) {
                            return false;
                        }
                        if (subjVar.equals((Object)objVar) && !subj.equals(obj)) {
                            return false;
                        }
                        if (subjVar.equals((Object)conVar) && !subj.equals(context)) {
                            return false;
                        }
                    }
                    if (predVar != null && predValue == null) {
                        if (predVar.equals((Object)objVar) && !pred.equals((Object)obj)) {
                            return false;
                        }
                        if (predVar.equals((Object)conVar) && !pred.equals((Object)context)) {
                            return false;
                        }
                    }
                    return objVar == null || objValue != null || !objVar.equals((Object)conVar) || obj.equals(context);
                }
            };
            resultingIterator = new ConvertingIteration<Statement, BindingSet, QueryEvaluationException>((Iteration)stIter3){

                protected BindingSet convert(Statement st) {
                    QueryBindingSet result = new QueryBindingSet(bindings);
                    if (subjVar != null && !subjVar.isConstant() && !result.hasBinding(subjVar.getName())) {
                        result.addBinding(subjVar.getName(), (Value)st.getSubject());
                    }
                    if (predVar != null && !predVar.isConstant() && !result.hasBinding(predVar.getName())) {
                        result.addBinding(predVar.getName(), (Value)st.getPredicate());
                    }
                    if (objVar != null && !objVar.isConstant() && !result.hasBinding(objVar.getName())) {
                        result.addBinding(objVar.getName(), st.getObject());
                    }
                    if (conVar != null && !conVar.isConstant() && !result.hasBinding(conVar.getName()) && st.getContext() != null) {
                        result.addBinding(conVar.getName(), (Value)st.getContext());
                    }
                    return result;
                }
            };
            allGood = true;
            var16_31 = resultingIterator;
            return var16_31;
        }
        finally {
            if (!allGood) {
                try {
                    if (resultingIterator != null) {
                        resultingIterator.close();
                    }
                }
                finally {
                    try {
                        if (stIter3 != null) {
                            stIter3.close();
                        }
                    }
                    finally {
                        try {
                            if (stIter2 /* !! */  != null) {
                                stIter2 /* !! */ .close();
                            }
                        }
                        finally {
                            if (stIter1 != null) {
                                stIter1.close();
                            }
                        }
                    }
                }
            }
        }
    }

    protected boolean isUnbound(Var var, BindingSet bindings) {
        if (var == null) {
            return false;
        }
        return bindings.hasBinding(var.getName()) && bindings.getValue(var.getName()) == null;
    }

    protected Value getVarValue(Var var, BindingSet bindings) {
        if (var == null) {
            return null;
        }
        if (var.hasValue()) {
            return var.getValue();
        }
        return bindings.getValue(var.getName());
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(UnaryTupleOperator expr, BindingSet bindings) throws QueryEvaluationException {
        if (expr instanceof Projection) {
            return this.evaluate((Projection)expr, bindings);
        }
        if (expr instanceof MultiProjection) {
            return this.evaluate((MultiProjection)expr, bindings);
        }
        if (expr instanceof Filter) {
            return this.evaluate((Filter)expr, bindings);
        }
        if (expr instanceof Service) {
            return this.evaluate((Service)expr, bindings);
        }
        if (expr instanceof Slice) {
            return this.evaluate((Slice)expr, bindings);
        }
        if (expr instanceof Extension) {
            return this.evaluate((Extension)expr, bindings);
        }
        if (expr instanceof Distinct) {
            return this.evaluate((Distinct)expr, bindings);
        }
        if (expr instanceof Reduced) {
            return this.evaluate((Reduced)expr, bindings);
        }
        if (expr instanceof Group) {
            return this.evaluate((Group)expr, bindings);
        }
        if (expr instanceof Order) {
            return this.evaluate((Order)expr, bindings);
        }
        if (expr instanceof QueryRoot) {
            this.sharedValueOfNow = null;
            return this.evaluate(expr.getArg(), bindings);
        }
        if (expr instanceof DescribeOperator) {
            return this.evaluate((DescribeOperator)expr, bindings);
        }
        if (expr == null) {
            throw new IllegalArgumentException("expr must not be null");
        }
        throw new QueryEvaluationException("Unknown unary tuple operator type: " + expr.getClass());
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(BindingSetAssignment bsa, final BindingSet bindings) throws QueryEvaluationException {
        final Iterator assignments = bsa.getBindingSets().iterator();
        if (bindings.size() == 0) {
            return new CloseableIteratorIteration(assignments);
        }
        LookAheadIteration<BindingSet, QueryEvaluationException> result = new LookAheadIteration<BindingSet, QueryEvaluationException>(){

            protected BindingSet getNextElement() throws QueryEvaluationException {
                QueryBindingSet nextResult = null;
                block0: while (nextResult == null && assignments.hasNext()) {
                    BindingSet assignedBindings = (BindingSet)assignments.next();
                    for (String name : assignedBindings.getBindingNames()) {
                        Value assignedValue;
                        if (nextResult == null) {
                            nextResult = new QueryBindingSet(bindings);
                        }
                        if ((assignedValue = assignedBindings.getValue(name)) == null) continue;
                        Value existingValue = bindings.getValue(name);
                        if (existingValue == null || assignedValue.equals(existingValue)) {
                            if (existingValue != null) continue;
                            nextResult.addBinding(name, assignedValue);
                            continue;
                        }
                        nextResult = null;
                        continue block0;
                    }
                }
                return nextResult;
            }
        };
        return result;
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(Projection projection, BindingSet bindings) throws QueryEvaluationException {
        Object result = this.evaluate(projection.getArg(), bindings);
        result = new ProjectionIterator(projection, (CloseableIteration<BindingSet, QueryEvaluationException>)result, bindings);
        return result;
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(MultiProjection multiProjection, BindingSet bindings) throws QueryEvaluationException {
        Object result = this.evaluate(multiProjection.getArg(), bindings);
        result = new MultiProjectionIterator(multiProjection, (CloseableIteration<BindingSet, QueryEvaluationException>)result, bindings);
        return result;
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(Filter filter, BindingSet bindings) throws QueryEvaluationException {
        Object result = this.evaluate(filter.getArg(), bindings);
        result = new FilterIterator(filter, (CloseableIteration<BindingSet, QueryEvaluationException>)result, this);
        return result;
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(Slice slice, BindingSet bindings) throws QueryEvaluationException {
        OffsetIteration result = this.evaluate(slice.getArg(), bindings);
        if (slice.hasOffset()) {
            result = new OffsetIteration(result, slice.getOffset());
        }
        if (slice.hasLimit()) {
            result = new LimitIteration((Iteration)result, slice.getLimit());
        }
        return result;
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(Extension extension, BindingSet bindings) throws QueryEvaluationException {
        Object result;
        try {
            result = this.evaluate(extension.getArg(), bindings);
        }
        catch (ValueExprEvaluationException e) {
            result = new EmptyIteration();
        }
        result = new ExtensionIterator(extension, (CloseableIteration<BindingSet, QueryEvaluationException>)result, this);
        return result;
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(Distinct distinct, BindingSet bindings) throws QueryEvaluationException {
        return new DistinctIteration(this.evaluate(distinct.getArg(), bindings));
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(Reduced reduced, BindingSet bindings) throws QueryEvaluationException {
        return new ReducedIteration(this.evaluate(reduced.getArg(), bindings));
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(Group node, BindingSet bindings) throws QueryEvaluationException {
        return new GroupIterator(this, node, bindings, this.iterationCacheSyncThreshold);
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(Order node, BindingSet bindings) throws QueryEvaluationException {
        ValueComparator vcmp = new ValueComparator();
        OrderComparator cmp = new OrderComparator(this, node, vcmp);
        boolean reduced = this.isReducedOrDistinct((QueryModelNode)node);
        long limit = this.getLimit((QueryModelNode)node);
        return new OrderIterator(this.evaluate(node.getArg(), bindings), cmp, limit, reduced, this.iterationCacheSyncThreshold);
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(BinaryTupleOperator expr, BindingSet bindings) throws QueryEvaluationException {
        if (expr instanceof Join) {
            return this.evaluate((Join)expr, bindings);
        }
        if (expr instanceof LeftJoin) {
            return this.evaluate((LeftJoin)expr, bindings);
        }
        if (expr instanceof Union) {
            return this.evaluate((Union)expr, bindings);
        }
        if (expr instanceof Intersection) {
            return this.evaluate((Intersection)expr, bindings);
        }
        if (expr instanceof Difference) {
            return this.evaluate((Difference)expr, bindings);
        }
        if (expr == null) {
            throw new IllegalArgumentException("expr must not be null");
        }
        throw new QueryEvaluationException("Unsupported binary tuple operator type: " + expr.getClass());
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(Join join, BindingSet bindings) throws QueryEvaluationException {
        if (join.getRightArg() instanceof Service) {
            CloseableIteration<BindingSet, QueryEvaluationException> leftIter = this.evaluate(join.getLeftArg(), bindings);
            return new ServiceJoinIterator(leftIter, (Service)join.getRightArg(), bindings, this);
        }
        if (this.isOutOfScopeForLeftArgBindings(join.getRightArg())) {
            return new HashJoinIteration((EvaluationStrategy)this, join, bindings);
        }
        return new JoinIterator(this, join, bindings);
    }

    private boolean isOutOfScopeForLeftArgBindings(TupleExpr expr) {
        return TupleExprs.isVariableScopeChange((TupleExpr)expr) || TupleExprs.containsSubquery((TupleExpr)expr);
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(LeftJoin leftJoin, BindingSet bindings) throws QueryEvaluationException {
        if (TupleExprs.containsSubquery((TupleExpr)leftJoin.getRightArg())) {
            return new HashJoinIteration((EvaluationStrategy)this, leftJoin, bindings);
        }
        VarNameCollector optionalVarCollector = new VarNameCollector();
        leftJoin.getRightArg().visit((QueryModelVisitor)optionalVarCollector);
        if (leftJoin.hasCondition()) {
            leftJoin.getCondition().visit((QueryModelVisitor)optionalVarCollector);
        }
        Set problemVars = optionalVarCollector.getVarNames();
        problemVars.removeAll(leftJoin.getLeftArg().getBindingNames());
        problemVars.retainAll(bindings.getBindingNames());
        if (problemVars.isEmpty()) {
            return new LeftJoinIterator(this, leftJoin, bindings);
        }
        return new BadlyDesignedLeftJoinIterator(this, leftJoin, bindings, problemVars);
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(final Union union, final BindingSet bindings) throws QueryEvaluationException {
        DelayedIteration<BindingSet, QueryEvaluationException> leftArg = new DelayedIteration<BindingSet, QueryEvaluationException>(){

            protected Iteration<BindingSet, QueryEvaluationException> createIteration() throws QueryEvaluationException {
                return StrictEvaluationStrategy.this.evaluate(union.getLeftArg(), bindings);
            }
        };
        DelayedIteration<BindingSet, QueryEvaluationException> rightArg = new DelayedIteration<BindingSet, QueryEvaluationException>(){

            protected Iteration<BindingSet, QueryEvaluationException> createIteration() throws QueryEvaluationException {
                return StrictEvaluationStrategy.this.evaluate(union.getRightArg(), bindings);
            }
        };
        return new UnionIteration(new Iteration[]{leftArg, rightArg});
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(final Intersection intersection, final BindingSet bindings) throws QueryEvaluationException {
        DelayedIteration<BindingSet, QueryEvaluationException> leftArg = new DelayedIteration<BindingSet, QueryEvaluationException>(){

            protected Iteration<BindingSet, QueryEvaluationException> createIteration() throws QueryEvaluationException {
                return StrictEvaluationStrategy.this.evaluate(intersection.getLeftArg(), bindings);
            }
        };
        DelayedIteration<BindingSet, QueryEvaluationException> rightArg = new DelayedIteration<BindingSet, QueryEvaluationException>(){

            protected Iteration<BindingSet, QueryEvaluationException> createIteration() throws QueryEvaluationException {
                return StrictEvaluationStrategy.this.evaluate(intersection.getRightArg(), bindings);
            }
        };
        return new IntersectIteration((Iteration)leftArg, (Iteration)rightArg);
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(final Difference difference, final BindingSet bindings) throws QueryEvaluationException {
        DelayedIteration<BindingSet, QueryEvaluationException> leftArg = new DelayedIteration<BindingSet, QueryEvaluationException>(){

            protected Iteration<BindingSet, QueryEvaluationException> createIteration() throws QueryEvaluationException {
                return StrictEvaluationStrategy.this.evaluate(difference.getLeftArg(), bindings);
            }
        };
        DelayedIteration<BindingSet, QueryEvaluationException> rightArg = new DelayedIteration<BindingSet, QueryEvaluationException>(){

            protected Iteration<BindingSet, QueryEvaluationException> createIteration() throws QueryEvaluationException {
                return StrictEvaluationStrategy.this.evaluate(difference.getRightArg(), bindings);
            }
        };
        return new SPARQLMinusIteration(leftArg, rightArg);
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(SingletonSet singletonSet, BindingSet bindings) throws QueryEvaluationException {
        return new SingletonIteration((Object)bindings);
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(EmptySet emptySet, BindingSet bindings) throws QueryEvaluationException {
        return new EmptyIteration();
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(ExternalSet external, BindingSet bindings) throws QueryEvaluationException {
        return external.evaluate(bindings);
    }

    @Override
    public Value evaluate(ValueExpr expr, BindingSet bindings) throws QueryEvaluationException {
        if (expr instanceof Var) {
            return this.evaluate((Var)expr, bindings);
        }
        if (expr instanceof ValueConstant) {
            return this.evaluate((ValueConstant)expr, bindings);
        }
        if (expr instanceof BNodeGenerator) {
            return this.evaluate((BNodeGenerator)expr, bindings);
        }
        if (expr instanceof Bound) {
            return this.evaluate((Bound)expr, bindings);
        }
        if (expr instanceof Str) {
            return this.evaluate((Str)expr, bindings);
        }
        if (expr instanceof Label) {
            return this.evaluate((Label)expr, bindings);
        }
        if (expr instanceof Lang) {
            return this.evaluate((Lang)expr, bindings);
        }
        if (expr instanceof LangMatches) {
            return this.evaluate((LangMatches)expr, bindings);
        }
        if (expr instanceof Datatype) {
            return this.evaluate((Datatype)expr, bindings);
        }
        if (expr instanceof Namespace) {
            return this.evaluate((Namespace)expr, bindings);
        }
        if (expr instanceof LocalName) {
            return this.evaluate((LocalName)expr, bindings);
        }
        if (expr instanceof IsResource) {
            return this.evaluate((IsResource)expr, bindings);
        }
        if (expr instanceof IsURI) {
            return this.evaluate((IsURI)expr, bindings);
        }
        if (expr instanceof IsBNode) {
            return this.evaluate((IsBNode)expr, bindings);
        }
        if (expr instanceof IsLiteral) {
            return this.evaluate((IsLiteral)expr, bindings);
        }
        if (expr instanceof IsNumeric) {
            return this.evaluate((IsNumeric)expr, bindings);
        }
        if (expr instanceof IRIFunction) {
            return this.evaluate((IRIFunction)expr, bindings);
        }
        if (expr instanceof Regex) {
            return this.evaluate((Regex)expr, bindings);
        }
        if (expr instanceof Coalesce) {
            return this.evaluate((Coalesce)expr, bindings);
        }
        if (expr instanceof Like) {
            return this.evaluate((Like)expr, bindings);
        }
        if (expr instanceof FunctionCall) {
            return this.evaluate((FunctionCall)expr, bindings);
        }
        if (expr instanceof And) {
            return this.evaluate((And)expr, bindings);
        }
        if (expr instanceof Or) {
            return this.evaluate((Or)expr, bindings);
        }
        if (expr instanceof Not) {
            return this.evaluate((Not)expr, bindings);
        }
        if (expr instanceof SameTerm) {
            return this.evaluate((SameTerm)expr, bindings);
        }
        if (expr instanceof Compare) {
            return this.evaluate((Compare)expr, bindings);
        }
        if (expr instanceof MathExpr) {
            return this.evaluate((MathExpr)expr, bindings);
        }
        if (expr instanceof In) {
            return this.evaluate((In)expr, bindings);
        }
        if (expr instanceof CompareAny) {
            return this.evaluate((CompareAny)expr, bindings);
        }
        if (expr instanceof CompareAll) {
            return this.evaluate((CompareAll)expr, bindings);
        }
        if (expr instanceof Exists) {
            return this.evaluate((Exists)expr, bindings);
        }
        if (expr instanceof If) {
            return this.evaluate((If)expr, bindings);
        }
        if (expr instanceof ListMemberOperator) {
            return this.evaluate((ListMemberOperator)expr, bindings);
        }
        if (expr instanceof ValueExprTripleRef) {
            return this.evaluate((ValueExprTripleRef)expr, bindings);
        }
        if (expr == null) {
            throw new IllegalArgumentException("expr must not be null");
        }
        throw new QueryEvaluationException("Unsupported value expr type: " + expr.getClass());
    }

    public Value evaluate(Var var, BindingSet bindings) throws QueryEvaluationException {
        Value value = var.getValue();
        if (value == null) {
            value = bindings.getValue(var.getName());
        }
        if (value == null) {
            throw new ValueExprEvaluationException();
        }
        return value;
    }

    public Value evaluate(ValueConstant valueConstant, BindingSet bindings) throws QueryEvaluationException {
        return valueConstant.getValue();
    }

    public Value evaluate(BNodeGenerator node, BindingSet bindings) throws QueryEvaluationException {
        ValueExpr nodeIdExpr = node.getNodeIdExpr();
        if (nodeIdExpr != null) {
            Value nodeId = this.evaluate(nodeIdExpr, bindings);
            if (nodeId instanceof Literal) {
                String nodeLabel = ((Literal)nodeId).getLabel() + bindings.toString().hashCode();
                return this.tripleSource.getValueFactory().createBNode(nodeLabel);
            }
            throw new ValueExprEvaluationException("BNODE function argument must be a literal");
        }
        return this.tripleSource.getValueFactory().createBNode();
    }

    public Value evaluate(Bound node, BindingSet bindings) throws QueryEvaluationException {
        try {
            Value argValue = this.evaluate(node.getArg(), bindings);
            return BooleanLiteral.valueOf((argValue != null ? 1 : 0) != 0);
        }
        catch (ValueExprEvaluationException e) {
            return BooleanLiteral.FALSE;
        }
    }

    public Value evaluate(Str node, BindingSet bindings) throws QueryEvaluationException {
        Value argValue = this.evaluate(node.getArg(), bindings);
        if (argValue instanceof IRI) {
            return this.tripleSource.getValueFactory().createLiteral(argValue.toString());
        }
        if (argValue instanceof Literal) {
            Literal literal = (Literal)argValue;
            if (QueryEvaluationUtil.isSimpleLiteral(literal)) {
                return literal;
            }
            return this.tripleSource.getValueFactory().createLiteral(literal.getLabel());
        }
        if (argValue instanceof Triple) {
            return this.tripleSource.getValueFactory().createLiteral(argValue.toString());
        }
        throw new ValueExprEvaluationException();
    }

    public Value evaluate(Label node, BindingSet bindings) throws QueryEvaluationException {
        Value argValue = this.evaluate(node.getArg(), bindings);
        if (argValue instanceof Literal) {
            Literal literal = (Literal)argValue;
            if (QueryEvaluationUtil.isSimpleLiteral(literal)) {
                return literal;
            }
            return this.tripleSource.getValueFactory().createLiteral(literal.getLabel());
        }
        throw new ValueExprEvaluationException();
    }

    public Value evaluate(Lang node, BindingSet bindings) throws QueryEvaluationException {
        Value argValue = this.evaluate(node.getArg(), bindings);
        if (argValue instanceof Literal) {
            Literal literal = (Literal)argValue;
            return this.tripleSource.getValueFactory().createLiteral(literal.getLanguage().orElse(""));
        }
        throw new ValueExprEvaluationException();
    }

    public Value evaluate(Datatype node, BindingSet bindings) throws QueryEvaluationException {
        Value v = this.evaluate(node.getArg(), bindings);
        if (v instanceof Literal) {
            Literal literal = (Literal)v;
            if (literal.getDatatype() != null) {
                return literal.getDatatype();
            }
            if (literal.getLanguage().isPresent()) {
                return RDF.LANGSTRING;
            }
            return XSD.STRING;
        }
        throw new ValueExprEvaluationException();
    }

    public Value evaluate(Namespace node, BindingSet bindings) throws QueryEvaluationException {
        Value argValue = this.evaluate(node.getArg(), bindings);
        if (argValue instanceof IRI) {
            IRI uri = (IRI)argValue;
            return this.tripleSource.getValueFactory().createIRI(uri.getNamespace());
        }
        throw new ValueExprEvaluationException();
    }

    public Value evaluate(LocalName node, BindingSet bindings) throws QueryEvaluationException {
        Value argValue = this.evaluate(node.getArg(), bindings);
        if (argValue instanceof IRI) {
            IRI uri = (IRI)argValue;
            return this.tripleSource.getValueFactory().createLiteral(uri.getLocalName());
        }
        throw new ValueExprEvaluationException();
    }

    public Value evaluate(IsResource node, BindingSet bindings) throws QueryEvaluationException {
        Value argValue = this.evaluate(node.getArg(), bindings);
        return BooleanLiteral.valueOf((boolean)(argValue instanceof Resource));
    }

    public Value evaluate(IsURI node, BindingSet bindings) throws QueryEvaluationException {
        Value argValue = this.evaluate(node.getArg(), bindings);
        return BooleanLiteral.valueOf((boolean)(argValue instanceof IRI));
    }

    public Value evaluate(IsBNode node, BindingSet bindings) throws QueryEvaluationException {
        Value argValue = this.evaluate(node.getArg(), bindings);
        return BooleanLiteral.valueOf((boolean)(argValue instanceof BNode));
    }

    public Value evaluate(IsLiteral node, BindingSet bindings) throws QueryEvaluationException {
        Value argValue = this.evaluate(node.getArg(), bindings);
        return BooleanLiteral.valueOf((boolean)(argValue instanceof Literal));
    }

    public Value evaluate(IsNumeric node, BindingSet bindings) throws QueryEvaluationException {
        Value argValue = this.evaluate(node.getArg(), bindings);
        if (argValue instanceof Literal) {
            Literal lit = (Literal)argValue;
            IRI datatype = lit.getDatatype();
            return BooleanLiteral.valueOf((boolean)XMLDatatypeUtil.isNumericDatatype((IRI)datatype));
        }
        return BooleanLiteral.FALSE;
    }

    public IRI evaluate(IRIFunction node, BindingSet bindings) throws QueryEvaluationException {
        Value argValue = this.evaluate(node.getArg(), bindings);
        if (argValue instanceof Literal) {
            IRI result;
            Literal lit = (Literal)argValue;
            String uriString = lit.getLabel();
            String baseURI = node.getBaseURI();
            try {
                ParsedIRI iri = ParsedIRI.create((String)uriString);
                if (!iri.isAbsolute() && baseURI != null) {
                    uriString = ParsedIRI.create((String)baseURI).resolve(iri).toString();
                } else if (!iri.isAbsolute()) {
                    throw new ValueExprEvaluationException("not an absolute IRI reference: " + uriString);
                }
            }
            catch (IllegalArgumentException e) {
                throw new ValueExprEvaluationException("not a valid IRI reference: " + uriString);
            }
            try {
                result = this.tripleSource.getValueFactory().createIRI(uriString);
            }
            catch (IllegalArgumentException e) {
                throw new ValueExprEvaluationException(e.getMessage());
            }
            return result;
        }
        if (argValue instanceof IRI) {
            return (IRI)argValue;
        }
        throw new ValueExprEvaluationException();
    }

    public Value evaluate(Regex node, BindingSet bindings) throws QueryEvaluationException {
        Value arg = this.evaluate(node.getArg(), bindings);
        Value parg = this.evaluate(node.getPatternArg(), bindings);
        Value farg = null;
        ValueExpr flagsArg = node.getFlagsArg();
        if (flagsArg != null) {
            farg = this.evaluate(flagsArg, bindings);
        }
        if (QueryEvaluationUtil.isStringLiteral(arg) && QueryEvaluationUtil.isSimpleLiteral(parg) && (farg == null || QueryEvaluationUtil.isSimpleLiteral(farg))) {
            String text = ((Literal)arg).getLabel();
            String ptn = ((Literal)parg).getLabel();
            String flags = "";
            if (farg != null) {
                flags = ((Literal)farg).getLabel();
            }
            int f = 0;
            block9: for (char c : flags.toCharArray()) {
                switch (c) {
                    case 's': {
                        f |= 0x20;
                        continue block9;
                    }
                    case 'm': {
                        f |= 8;
                        continue block9;
                    }
                    case 'i': {
                        f |= 2;
                        f |= 0x40;
                        continue block9;
                    }
                    case 'x': {
                        f |= 4;
                        continue block9;
                    }
                    case 'd': {
                        f |= 1;
                        continue block9;
                    }
                    case 'u': {
                        f |= 0x40;
                        continue block9;
                    }
                    case 'q': {
                        f |= 0x10;
                        continue block9;
                    }
                    default: {
                        throw new ValueExprEvaluationException(flags);
                    }
                }
            }
            Pattern pattern = Pattern.compile(ptn, f);
            boolean result = pattern.matcher(text).find();
            return BooleanLiteral.valueOf((boolean)result);
        }
        throw new ValueExprEvaluationException();
    }

    public Value evaluate(LangMatches node, BindingSet bindings) throws QueryEvaluationException {
        Value langTagValue = this.evaluate(node.getLeftArg(), bindings);
        Value langRangeValue = this.evaluate(node.getRightArg(), bindings);
        if (QueryEvaluationUtil.isSimpleLiteral(langTagValue) && QueryEvaluationUtil.isSimpleLiteral(langRangeValue)) {
            String langTag = ((Literal)langTagValue).getLabel();
            String langRange = ((Literal)langRangeValue).getLabel();
            boolean result = Literals.langMatches((String)langTag, (String)langRange);
            return BooleanLiteral.valueOf((boolean)result);
        }
        throw new ValueExprEvaluationException();
    }

    public Value evaluate(Like node, BindingSet bindings) throws QueryEvaluationException {
        String snippet;
        Value val = this.evaluate(node.getArg(), bindings);
        String strVal = null;
        if (val instanceof IRI) {
            strVal = val.toString();
        } else if (val instanceof Literal) {
            strVal = ((Literal)val).getLabel();
        }
        if (strVal == null) {
            throw new ValueExprEvaluationException();
        }
        if (!node.isCaseSensitive()) {
            strVal = strVal.toLowerCase();
        }
        int valIndex = 0;
        int prevPatternIndex = -1;
        int patternIndex = node.getOpPattern().indexOf(42);
        if (patternIndex == -1) {
            return BooleanLiteral.valueOf((boolean)node.getOpPattern().equals(strVal));
        }
        if (patternIndex > 0) {
            snippet = node.getOpPattern().substring(0, patternIndex);
            if (!strVal.startsWith(snippet)) {
                return BooleanLiteral.FALSE;
            }
            valIndex += snippet.length();
            prevPatternIndex = patternIndex;
            patternIndex = node.getOpPattern().indexOf(42, patternIndex + 1);
        }
        while (patternIndex != -1) {
            snippet = node.getOpPattern().substring(prevPatternIndex + 1, patternIndex);
            valIndex = strVal.indexOf(snippet, valIndex);
            if (valIndex == -1) {
                return BooleanLiteral.FALSE;
            }
            valIndex += snippet.length();
            prevPatternIndex = patternIndex;
            patternIndex = node.getOpPattern().indexOf(42, patternIndex + 1);
        }
        snippet = node.getOpPattern().substring(prevPatternIndex + 1);
        if (snippet.length() > 0) {
            int i;
            valIndex = strVal.indexOf(snippet, valIndex);
            while ((i = strVal.indexOf(snippet, valIndex + 1)) != -1) {
                valIndex = i;
            }
            if (valIndex == -1) {
                return BooleanLiteral.FALSE;
            }
            if ((valIndex += snippet.length()) < strVal.length()) {
                return BooleanLiteral.FALSE;
            }
        }
        return BooleanLiteral.TRUE;
    }

    public Value evaluate(FunctionCall node, BindingSet bindings) throws QueryEvaluationException {
        Function function = (Function)FunctionRegistry.getInstance().get(node.getURI()).orElseThrow(() -> new QueryEvaluationException("Unknown function '" + node.getURI() + "'"));
        if (function instanceof Now) {
            return this.evaluate((Now)function, bindings);
        }
        List args = node.getArgs();
        Value[] argValues = new Value[args.size()];
        for (int i = 0; i < args.size(); ++i) {
            argValues[i] = this.evaluate((ValueExpr)args.get(i), bindings);
        }
        return function.evaluate(this.tripleSource, argValues);
    }

    public Value evaluate(And node, BindingSet bindings) throws QueryEvaluationException {
        try {
            Value leftValue = this.evaluate(node.getLeftArg(), bindings);
            if (!QueryEvaluationUtil.getEffectiveBooleanValue(leftValue)) {
                return BooleanLiteral.FALSE;
            }
        }
        catch (ValueExprEvaluationException e) {
            Value rightValue = this.evaluate(node.getRightArg(), bindings);
            if (!QueryEvaluationUtil.getEffectiveBooleanValue(rightValue)) {
                return BooleanLiteral.FALSE;
            }
            throw new ValueExprEvaluationException();
        }
        Value rightValue = this.evaluate(node.getRightArg(), bindings);
        return BooleanLiteral.valueOf((boolean)QueryEvaluationUtil.getEffectiveBooleanValue(rightValue));
    }

    public Value evaluate(Or node, BindingSet bindings) throws QueryEvaluationException {
        try {
            Value leftValue = this.evaluate(node.getLeftArg(), bindings);
            if (QueryEvaluationUtil.getEffectiveBooleanValue(leftValue)) {
                return BooleanLiteral.TRUE;
            }
        }
        catch (ValueExprEvaluationException e) {
            Value rightValue = this.evaluate(node.getRightArg(), bindings);
            if (QueryEvaluationUtil.getEffectiveBooleanValue(rightValue)) {
                return BooleanLiteral.TRUE;
            }
            throw new ValueExprEvaluationException();
        }
        Value rightValue = this.evaluate(node.getRightArg(), bindings);
        return BooleanLiteral.valueOf((boolean)QueryEvaluationUtil.getEffectiveBooleanValue(rightValue));
    }

    public Value evaluate(Not node, BindingSet bindings) throws QueryEvaluationException {
        Value argValue = this.evaluate(node.getArg(), bindings);
        boolean argBoolean = QueryEvaluationUtil.getEffectiveBooleanValue(argValue);
        return BooleanLiteral.valueOf((!argBoolean ? 1 : 0) != 0);
    }

    public Value evaluate(Now node, BindingSet bindings) throws QueryEvaluationException {
        if (this.sharedValueOfNow == null) {
            this.sharedValueOfNow = node.evaluate(this.tripleSource.getValueFactory(), new Value[0]);
        }
        return this.sharedValueOfNow;
    }

    public Value evaluate(SameTerm node, BindingSet bindings) throws QueryEvaluationException {
        Value leftVal = this.evaluate(node.getLeftArg(), bindings);
        Value rightVal = this.evaluate(node.getRightArg(), bindings);
        return BooleanLiteral.valueOf((leftVal != null && leftVal.equals(rightVal) ? 1 : 0) != 0);
    }

    public Value evaluate(Coalesce node, BindingSet bindings) throws ValueExprEvaluationException {
        Value result = null;
        for (ValueExpr expr : node.getArguments()) {
            try {
                result = this.evaluate(expr, bindings);
                break;
            }
            catch (QueryEvaluationException queryEvaluationException) {
            }
        }
        if (result == null) {
            throw new ValueExprEvaluationException("COALESCE arguments do not evaluate to a value: " + node.getSignature());
        }
        return result;
    }

    public Value evaluate(Compare node, BindingSet bindings) throws QueryEvaluationException {
        Value leftVal = this.evaluate(node.getLeftArg(), bindings);
        Value rightVal = this.evaluate(node.getRightArg(), bindings);
        return BooleanLiteral.valueOf((boolean)QueryEvaluationUtil.compare(leftVal, rightVal, node.getOperator()));
    }

    public Value evaluate(MathExpr node, BindingSet bindings) throws QueryEvaluationException {
        Value leftVal = this.evaluate(node.getLeftArg(), bindings);
        Value rightVal = this.evaluate(node.getRightArg(), bindings);
        if (leftVal instanceof Literal && rightVal instanceof Literal) {
            return MathUtil.compute((Literal)leftVal, (Literal)rightVal, node.getOperator());
        }
        throw new ValueExprEvaluationException("Both arguments must be numeric literals");
    }

    public Value evaluate(If node, BindingSet bindings) throws QueryEvaluationException {
        boolean conditionIsTrue;
        try {
            Value value = this.evaluate(node.getCondition(), bindings);
            conditionIsTrue = QueryEvaluationUtil.getEffectiveBooleanValue(value);
        }
        catch (ValueExprEvaluationException e) {
            return null;
        }
        Value result = conditionIsTrue ? this.evaluate(node.getResult(), bindings) : this.evaluate(node.getAlternative(), bindings);
        return result;
    }

    public Value evaluate(In node, BindingSet bindings) throws QueryEvaluationException {
        Value leftValue = this.evaluate(node.getArg(), bindings);
        boolean result = false;
        String bindingName = (String)node.getSubQuery().getBindingNames().iterator().next();
        try (CloseableIteration<BindingSet, QueryEvaluationException> iter = this.evaluate(node.getSubQuery(), bindings);){
            while (!result && iter.hasNext()) {
                BindingSet bindingSet = (BindingSet)iter.next();
                Value rightValue = bindingSet.getValue(bindingName);
                result = leftValue == null && rightValue == null || leftValue != null && leftValue.equals(rightValue);
            }
        }
        return BooleanLiteral.valueOf((boolean)result);
    }

    public Value evaluate(ListMemberOperator node, BindingSet bindings) throws QueryEvaluationException {
        List args = node.getArguments();
        Value leftValue = this.evaluate((ValueExpr)args.get(0), bindings);
        boolean result = false;
        ValueExprEvaluationException typeError = null;
        for (int i = 1; i < args.size(); ++i) {
            ValueExpr arg = (ValueExpr)args.get(i);
            try {
                Value rightValue = this.evaluate(arg, bindings);
                boolean bl = result = leftValue == null && rightValue == null;
                if (!result) {
                    result = QueryEvaluationUtil.compare(leftValue, rightValue, Compare.CompareOp.EQ);
                }
                if (!result) continue;
                break;
            }
            catch (ValueExprEvaluationException caught) {
                typeError = caught;
            }
        }
        if (typeError != null && !result) {
            throw typeError;
        }
        return BooleanLiteral.valueOf((boolean)result);
    }

    public Value evaluate(CompareAny node, BindingSet bindings) throws QueryEvaluationException {
        boolean result;
        block10: {
            Value leftValue = this.evaluate(node.getArg(), bindings);
            result = false;
            String bindingName = (String)node.getSubQuery().getBindingNames().iterator().next();
            CloseableIteration<BindingSet, QueryEvaluationException> iter = this.evaluate(node.getSubQuery(), bindings);
            block7: while (true) {
                while (!result && iter.hasNext()) {
                    BindingSet bindingSet = (BindingSet)iter.next();
                    Value rightValue = bindingSet.getValue(bindingName);
                    try {
                        result = QueryEvaluationUtil.compare(leftValue, rightValue, node.getOperator());
                        continue block7;
                    }
                    catch (ValueExprEvaluationException valueExprEvaluationException) {
                    }
                }
                break block10;
                {
                    continue block7;
                    break;
                }
                break;
            }
            finally {
                if (iter != null) {
                    iter.close();
                }
            }
        }
        return BooleanLiteral.valueOf((boolean)result);
    }

    public Value evaluate(CompareAll node, BindingSet bindings) throws QueryEvaluationException {
        boolean result;
        block10: {
            Value leftValue = this.evaluate(node.getArg(), bindings);
            result = true;
            String bindingName = (String)node.getSubQuery().getBindingNames().iterator().next();
            CloseableIteration<BindingSet, QueryEvaluationException> iter = this.evaluate(node.getSubQuery(), bindings);
            block7: while (true) {
                while (result && iter.hasNext()) {
                    BindingSet bindingSet = (BindingSet)iter.next();
                    Value rightValue = bindingSet.getValue(bindingName);
                    try {
                        result = QueryEvaluationUtil.compare(leftValue, rightValue, node.getOperator());
                        continue block7;
                    }
                    catch (ValueExprEvaluationException e) {
                        result = false;
                    }
                }
                break block10;
                {
                    continue block7;
                    break;
                }
                break;
            }
            finally {
                if (iter != null) {
                    iter.close();
                }
            }
        }
        return BooleanLiteral.valueOf((boolean)result);
    }

    public Value evaluate(Exists node, BindingSet bindings) throws QueryEvaluationException {
        try (CloseableIteration<BindingSet, QueryEvaluationException> iter = this.evaluate(node.getSubQuery(), bindings);){
            BooleanLiteral booleanLiteral = BooleanLiteral.valueOf((boolean)iter.hasNext());
            return booleanLiteral;
        }
    }

    @Override
    public boolean isTrue(ValueExpr expr, BindingSet bindings) throws QueryEvaluationException {
        try {
            Value value = this.evaluate(expr, bindings);
            return QueryEvaluationUtil.getEffectiveBooleanValue(value);
        }
        catch (ValueExprEvaluationException e) {
            return false;
        }
    }

    protected boolean isReducedOrDistinct(QueryModelNode node) {
        QueryModelNode parent = node.getParentNode();
        if (parent instanceof Slice) {
            return this.isReducedOrDistinct(parent);
        }
        return parent instanceof Distinct || parent instanceof Reduced;
    }

    protected long getLimit(QueryModelNode node) {
        QueryModelNode parent;
        long offset = 0L;
        if (node instanceof Slice) {
            Slice slice = (Slice)node;
            if (slice.hasOffset() && slice.hasLimit()) {
                return slice.getOffset() + slice.getLimit();
            }
            if (slice.hasLimit()) {
                return slice.getLimit();
            }
            if (slice.hasOffset()) {
                offset = slice.getOffset();
            }
        }
        if ((parent = node.getParentNode()) instanceof Distinct || parent instanceof Reduced || parent instanceof Slice) {
            long limit = this.getLimit(parent);
            if (offset > 0L && limit < Long.MAX_VALUE) {
                return offset + limit;
            }
            return limit;
        }
        return Long.MAX_VALUE;
    }

    public Value evaluate(ValueExprTripleRef node, BindingSet bindings) throws QueryEvaluationException {
        Value subj = this.evaluate(node.getSubjectVar(), bindings);
        if (!(subj instanceof Resource)) {
            throw new ValueExprEvaluationException("no subject value");
        }
        Value pred = this.evaluate(node.getPredicateVar(), bindings);
        if (!(pred instanceof IRI)) {
            throw new ValueExprEvaluationException("no predicate value");
        }
        Value obj = this.evaluate(node.getObjectVar(), bindings);
        if (obj == null) {
            throw new ValueExprEvaluationException("no object value");
        }
        return this.tripleSource.getValueFactory().createTriple((Resource)subj, (IRI)pred, obj);
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(TripleRef ref, final BindingSet bindings) {
        final Var subjVar = ref.getSubjectVar();
        final Var predVar = ref.getPredicateVar();
        final Var objVar = ref.getObjectVar();
        final Var extVar = ref.getExprVar();
        final Value subjValue = this.getVarValue(subjVar, bindings);
        final Value predValue = this.getVarValue(predVar, bindings);
        final Value objValue = this.getVarValue(objVar, bindings);
        final Value extValue = this.getVarValue(extVar, bindings);
        if (extValue != null && !(extValue instanceof Resource)) {
            return new EmptyIteration();
        }
        boolean sourceSupportsRdfStar = this.tripleSource instanceof RDFStarTripleSource;
        if (sourceSupportsRdfStar) {
            CloseableIteration<? extends Triple, QueryEvaluationException> sourceIter = ((RDFStarTripleSource)this.tripleSource).getRdfStarTriples((Resource)subjValue, (IRI)predValue, objValue);
            FilterIteration<Triple, QueryEvaluationException> filterIter = new FilterIteration<Triple, QueryEvaluationException>(sourceIter){

                protected boolean accept(Triple triple) throws QueryEvaluationException {
                    if (subjValue != null && !subjValue.equals(triple.getSubject())) {
                        return false;
                    }
                    if (predValue != null && !predValue.equals(triple.getPredicate())) {
                        return false;
                    }
                    if (objValue != null && !objValue.equals(triple.getObject())) {
                        return false;
                    }
                    return extValue == null || extValue.equals(triple);
                }
            };
            return new ConvertingIteration<Triple, BindingSet, QueryEvaluationException>((Iteration)filterIter){

                protected BindingSet convert(Triple triple) throws QueryEvaluationException {
                    QueryBindingSet result = new QueryBindingSet(bindings);
                    if (subjValue == null) {
                        result.addBinding(subjVar.getName(), (Value)triple.getSubject());
                    }
                    if (predValue == null) {
                        result.addBinding(predVar.getName(), (Value)triple.getPredicate());
                    }
                    if (objValue == null) {
                        result.addBinding(objVar.getName(), triple.getObject());
                    }
                    if (extValue == null) {
                        result.addBinding(extVar.getName(), (Value)triple);
                    }
                    return result;
                }
            };
        }
        ConvertingIteration<Statement, Resource, QueryEvaluationException> iter = new ConvertingIteration<Statement, Resource, QueryEvaluationException>(this.tripleSource.getStatements((Resource)extValue, RDF.TYPE, (Value)RDF.STATEMENT, new Resource[0])){

            protected Resource convert(Statement sourceObject) throws QueryEvaluationException {
                return sourceObject.getSubject();
            }
        };
        return new LookAheadIteration<BindingSet, QueryEvaluationException>((CloseableIteration)iter, bindings, subjValue, subjVar, predValue, predVar, objValue, objVar, extValue, extVar){
            final /* synthetic */ CloseableIteration val$iter;
            final /* synthetic */ BindingSet val$bindings;
            final /* synthetic */ Value val$subjValue;
            final /* synthetic */ Var val$subjVar;
            final /* synthetic */ Value val$predValue;
            final /* synthetic */ Var val$predVar;
            final /* synthetic */ Value val$objValue;
            final /* synthetic */ Var val$objVar;
            final /* synthetic */ Value val$extValue;
            final /* synthetic */ Var val$extVar;
            {
                this.val$iter = closeableIteration;
                this.val$bindings = bindingSet;
                this.val$subjValue = value;
                this.val$subjVar = var;
                this.val$predValue = value2;
                this.val$predVar = var2;
                this.val$objValue = value3;
                this.val$objVar = var3;
                this.val$extValue = value4;
                this.val$extVar = var4;
            }

            protected void handleClose() throws QueryEvaluationException {
                super.handleClose();
                this.val$iter.close();
            }

            protected BindingSet getNextElement() throws QueryEvaluationException {
                while (this.val$iter.hasNext()) {
                    QueryBindingSet result;
                    Resource theNode = (Resource)this.val$iter.next();
                    if (!this.matchValue(theNode, this.val$subjValue, this.val$subjVar, result = new QueryBindingSet(this.val$bindings), RDF.SUBJECT) || !this.matchValue(theNode, this.val$predValue, this.val$predVar, result, RDF.PREDICATE) || !this.matchValue(theNode, this.val$objValue, this.val$objVar, result, RDF.OBJECT)) continue;
                    if (this.val$extValue == null) {
                        result.addBinding(this.val$extVar.getName(), (Value)theNode);
                    } else if (!this.val$extValue.equals(theNode)) continue;
                    return result;
                }
                return null;
            }

            private boolean matchValue(Resource theNode, Value value, Var var, QueryBindingSet result, IRI predicate) {
                try (CloseableIteration<? extends Statement, QueryEvaluationException> valueiter = StrictEvaluationStrategy.this.tripleSource.getStatements(theNode, predicate, null, new Resource[0]);){
                    while (valueiter.hasNext()) {
                        Statement valueStatement = (Statement)valueiter.next();
                        if (!theNode.equals(valueStatement.getSubject()) || value != null && !value.equals(valueStatement.getObject())) continue;
                        if (value == null) {
                            result.addBinding(var.getName(), valueStatement.getObject());
                        }
                        boolean bl = true;
                        return bl;
                    }
                    boolean bl = false;
                    return bl;
                }
            }
        };
    }

    @Override
    public void setTrackResultSize(boolean trackResultSize) {
        this.trackResultSize = trackResultSize;
    }

    @Override
    public void setTrackTime(boolean trackTime) {
        this.trackTime = trackTime;
    }

    private static class TimedIterator
    extends IterationWrapper<BindingSet, QueryEvaluationException> {
        CloseableIteration<BindingSet, QueryEvaluationException> iterator;
        QueryModelNode queryModelNode;
        Stopwatch stopwatch = Stopwatch.createUnstarted();

        public TimedIterator(CloseableIteration<BindingSet, QueryEvaluationException> iterator, QueryModelNode queryModelNode) {
            super(iterator);
            this.iterator = iterator;
            this.queryModelNode = queryModelNode;
        }

        public BindingSet next() throws QueryEvaluationException {
            this.stopwatch.start();
            BindingSet next = (BindingSet)this.iterator.next();
            this.stopwatch.stop();
            return next;
        }

        public boolean hasNext() throws QueryEvaluationException {
            this.stopwatch.start();
            boolean hasNext = super.hasNext();
            this.stopwatch.stop();
            return hasNext;
        }

        protected void handleClose() throws QueryEvaluationException {
            try {
                this.queryModelNode.setTotalTimeNanosActual(this.queryModelNode.getTotalTimeNanosActual() + this.stopwatch.elapsed(TimeUnit.NANOSECONDS));
            }
            finally {
                super.handleClose();
            }
        }
    }

    private static class ResultSizeCountingIterator
    extends IterationWrapper<BindingSet, QueryEvaluationException> {
        CloseableIteration<BindingSet, QueryEvaluationException> iterator;
        QueryModelNode queryModelNode;

        public ResultSizeCountingIterator(CloseableIteration<BindingSet, QueryEvaluationException> iterator, QueryModelNode queryModelNode) {
            super(iterator);
            this.iterator = iterator;
            this.queryModelNode = queryModelNode;
        }

        public BindingSet next() throws QueryEvaluationException {
            this.queryModelNode.setResultSizeActual(this.queryModelNode.getResultSizeActual() + 1L);
            return (BindingSet)this.iterator.next();
        }
    }

    private static class BoundVarVisitor
    extends AbstractQueryModelVisitor<RuntimeException> {
        private final Set<Var> boundVars = new HashSet<Var>();

        private BoundVarVisitor() {
        }

        public void meet(Var var) {
            if (var.hasValue()) {
                this.boundVars.add(var);
            }
        }
    }
}

