/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelNodeBase;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.ValueExpr;
import org.eclipse.rdf4j.query.algebra.Var;

public class TupleFunctionCall
extends QueryModelNodeBase
implements TupleExpr {
    private String uri;
    private List<ValueExpr> args = new ArrayList<ValueExpr>();
    private List<Var> resultVars = new ArrayList<Var>();

    public String getURI() {
        return this.uri;
    }

    public void setURI(String uri) {
        this.uri = uri;
    }

    public List<ValueExpr> getArgs() {
        return this.args;
    }

    public void setArgs(Iterable<ValueExpr> args) {
        this.args.clear();
        this.addArgs(args);
    }

    public void addArgs(ValueExpr ... args) {
        for (ValueExpr arg : args) {
            this.addArg(arg);
        }
    }

    public void addArgs(Iterable<ValueExpr> args) {
        for (ValueExpr arg : args) {
            this.addArg(arg);
        }
    }

    public void addArg(ValueExpr arg) {
        assert (arg != null) : "arg must not be null";
        this.args.add(arg);
        arg.setParentNode(this);
    }

    public List<Var> getResultVars() {
        return this.resultVars;
    }

    public void setResultVars(Iterable<Var> resultVars) {
        this.resultVars.clear();
        this.addResultVars(resultVars);
    }

    public void addResultVars(Var ... resultVars) {
        for (Var var : resultVars) {
            this.addResultVar(var);
        }
    }

    public void addResultVars(Iterable<Var> resultVars) {
        for (Var var : resultVars) {
            this.addResultVar(var);
        }
    }

    public void addResultVar(Var resultVar) {
        assert (resultVar != null) : "resultVar must not be null";
        this.resultVars.add(resultVar);
        resultVar.setParentNode(this);
    }

    @Override
    public Set<String> getBindingNames() {
        return this.getAssuredBindingNames();
    }

    @Override
    public Set<String> getAssuredBindingNames() {
        LinkedHashSet<String> bindingNames = new LinkedHashSet<String>(2 * this.resultVars.size());
        for (Var var : this.resultVars) {
            bindingNames.add(var.getName());
        }
        return bindingNames;
    }

    @Override
    public <X extends Exception> void visit(QueryModelVisitor<X> visitor) throws X {
        visitor.meetOther(this);
    }

    @Override
    public <X extends Exception> void visitChildren(QueryModelVisitor<X> visitor) throws X {
        for (ValueExpr arg : this.args) {
            arg.visit(visitor);
        }
        for (Var var : this.resultVars) {
            var.visit(visitor);
        }
        super.visitChildren(visitor);
    }

    @Override
    public void replaceChildNode(QueryModelNode current, QueryModelNode replacement) {
        if (this.replaceNodeInList(this.args, current, replacement)) {
            return;
        }
        if (this.replaceNodeInList(this.resultVars, current, replacement)) {
            return;
        }
        super.replaceChildNode(current, replacement);
    }

    @Override
    public String getSignature() {
        StringBuilder sb = new StringBuilder(64);
        sb.append(super.getSignature());
        sb.append(" (").append(this.uri);
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof TupleFunctionCall) {
            TupleFunctionCall o = (TupleFunctionCall)other;
            return this.uri.equals(o.getURI()) && this.args.equals(o.getArgs()) && this.resultVars.equals(o.getResultVars());
        }
        return false;
    }

    public int hashCode() {
        return this.uri.hashCode() ^ this.args.hashCode() ^ this.resultVars.hashCode();
    }

    @Override
    public TupleFunctionCall clone() {
        TupleFunctionCall clone = (TupleFunctionCall)super.clone();
        clone.args = new ArrayList<ValueExpr>(this.getArgs().size());
        for (ValueExpr arg : this.getArgs()) {
            clone.addArg(arg.clone());
        }
        clone.resultVars = new ArrayList<Var>(this.getResultVars().size());
        for (Var var : this.getResultVars()) {
            clone.addResultVar(var.clone());
        }
        return clone;
    }
}

