/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.model.base;

import org.eclipse.rdf4j.model.IRI;

public abstract class AbstractIRI
implements IRI {
    private static final long serialVersionUID = 7799969821538513046L;

    @Override
    public String stringValue() {
        return this.getNamespace() + this.getLocalName();
    }

    @Override
    public boolean equals(Object o) {
        return this == o || o instanceof IRI && this.toString().equals(o.toString());
    }

    @Override
    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this.stringValue();
    }

    static class GenericIRI
    extends AbstractIRI {
        private static final long serialVersionUID = 2209156550690548467L;
        private String iri;
        private int split;

        GenericIRI(String iri) {
            this.iri = iri;
            this.split = 0;
        }

        GenericIRI(String namespace, String localName) {
            this.iri = namespace + localName;
            this.split = namespace.length();
        }

        @Override
        public String stringValue() {
            return this.iri;
        }

        @Override
        public String getNamespace() {
            return this.iri.substring(0, this.split());
        }

        @Override
        public String getLocalName() {
            return this.iri.substring(this.split());
        }

        private int split() {
            if (this.split > 0) {
                return this.split;
            }
            this.split = this.iri.indexOf(35) + 1;
            if (this.split > 0) {
                return this.split;
            }
            this.split = this.iri.lastIndexOf(47) + 1;
            if (this.split > 0) {
                return this.split;
            }
            this.split = this.iri.lastIndexOf(58) + 1;
            if (this.split > 0) {
                return this.split;
            }
            return 0;
        }
    }
}

