/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.memory.model;

import java.lang.reflect.Field;
import org.eclipse.rdf4j.model.impl.ContextStatement;
import org.eclipse.rdf4j.sail.memory.model.MemIRI;
import org.eclipse.rdf4j.sail.memory.model.MemResource;
import org.eclipse.rdf4j.sail.memory.model.MemValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemStatement
extends ContextStatement {
    private static final Logger logger = LoggerFactory.getLogger(MemStatement.class);
    private static final long serialVersionUID = -3073275483628334134L;
    private final boolean explicit;
    private volatile int sinceSnapshot;
    private volatile int tillSnapshot = Integer.MAX_VALUE;

    public MemStatement(MemResource subject, MemIRI predicate, MemValue object, MemResource context, int sinceSnapshot) {
        this(subject, predicate, object, context, true, sinceSnapshot);
    }

    public MemStatement(MemResource subject, MemIRI predicate, MemValue object, MemResource context, boolean explicit, int sinceSnapshot) {
        super(subject, predicate, object, context);
        this.explicit = explicit;
        this.setSinceSnapshot(sinceSnapshot);
    }

    @Override
    public MemResource getSubject() {
        return (MemResource)super.getSubject();
    }

    @Override
    public MemIRI getPredicate() {
        return (MemIRI)super.getPredicate();
    }

    @Override
    public MemValue getObject() {
        return (MemValue)super.getObject();
    }

    @Override
    public MemResource getContext() {
        return (MemResource)super.getContext();
    }

    public void setSinceSnapshot(int snapshot) {
        this.sinceSnapshot = snapshot;
    }

    public int getSinceSnapshot() {
        return this.sinceSnapshot;
    }

    public void setTillSnapshot(int snapshot) {
        this.tillSnapshot = snapshot;
    }

    public int getTillSnapshot() {
        return this.tillSnapshot;
    }

    public boolean isInSnapshot(int snapshot) {
        return snapshot >= this.sinceSnapshot && snapshot < this.tillSnapshot;
    }

    @Deprecated(since="4.0.0", forRemoval=true)
    public void setExplicit(boolean explicit) {
        logger.warn("The explicit field has been set to final for improved performance. Java reflection will be used to modify it. Take note that the MemorySailStore will not detect this change and may assume that it doesn't have any inferred statements!");
        try {
            Field explicitField = MemStatement.class.getDeclaredField("explicit");
            explicitField.setAccessible(true);
            explicitField.set(this, explicit);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isExplicit() {
        return this.explicit;
    }

    public void addToComponentLists() {
        this.getSubject().addSubjectStatement(this);
        this.getPredicate().addPredicateStatement(this);
        this.getObject().addObjectStatement(this);
        MemResource context = this.getContext();
        if (context != null) {
            context.addContextStatement(this);
        }
    }

    public void removeFromComponentLists() {
        this.getSubject().removeSubjectStatement(this);
        this.getPredicate().removePredicateStatement(this);
        this.getObject().removeObjectStatement(this);
        MemResource context = this.getContext();
        if (context != null) {
            context.removeContextStatement(this);
        }
    }

    public boolean matchesSPO(MemResource subject, MemIRI predicate, MemValue object) {
        return !(subject != null && !this.exactSameSubject(subject) || predicate != null && !this.exactSamePredicate(predicate) || object != null && !this.exactSameObject(object));
    }
}

