/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.sail.shacl.ConnectionsGroup;
import org.eclipse.rdf4j.sail.shacl.RdfsSubClassOfReasoner;
import org.eclipse.rdf4j.sail.shacl.ShaclSail;
import org.eclipse.rdf4j.sail.shacl.ast.Cache;
import org.eclipse.rdf4j.sail.shacl.ast.Identifiable;
import org.eclipse.rdf4j.sail.shacl.ast.ShaclProperties;
import org.eclipse.rdf4j.sail.shacl.ast.Shape;
import org.eclipse.rdf4j.sail.shacl.ast.SparqlFragment;
import org.eclipse.rdf4j.sail.shacl.ast.StatementMatcher;
import org.eclipse.rdf4j.sail.shacl.ast.ValidationApproach;
import org.eclipse.rdf4j.sail.shacl.ast.ValidationQuery;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.paths.Path;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.EmptyNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNodeProvider;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ShiftToNodeShape;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.TargetChainPopper;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.UnionNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.Unique;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationReportNode;
import org.eclipse.rdf4j.sail.shacl.ast.targets.TargetChain;
import org.eclipse.rdf4j.sail.shacl.results.ValidationResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyShape
extends Shape
implements ConstraintComponent,
Identifiable {
    private static final Logger logger = LoggerFactory.getLogger(PropertyShape.class);
    List<String> name;
    List<String> description;
    Object defaultValue;
    Object group;
    Path path;

    public PropertyShape() {
    }

    public PropertyShape(PropertyShape propertyShape) {
        super(propertyShape);
        this.name = propertyShape.name;
        this.description = propertyShape.description;
        this.defaultValue = propertyShape.defaultValue;
        this.group = propertyShape.group;
        this.path = propertyShape.path;
    }

    public static PropertyShape getInstance(ShaclProperties properties, RepositoryConnection connection, Cache cache, ShaclSail shaclSail) {
        Shape shape = cache.get(properties.getId());
        if (shape == null) {
            shape = new PropertyShape();
            cache.put(properties.getId(), shape);
            shape.populate(properties, connection, cache, shaclSail);
        }
        if (shape.constraintComponents.isEmpty()) {
            shape.deactivated = true;
        }
        return (PropertyShape)shape;
    }

    @Override
    public void populate(ShaclProperties properties, RepositoryConnection connection, Cache cache, ShaclSail shaclSail) {
        super.populate(properties, connection, cache, shaclSail);
        this.path = Path.buildPath(connection, properties.getPath());
        if (this.path == null) {
            throw new IllegalStateException(properties.getId() + " is a sh:PropertyShape without a sh:path!");
        }
        this.constraintComponents = this.getConstraintComponents(properties, connection, cache, shaclSail);
    }

    @Override
    protected Shape shallowClone() {
        return new PropertyShape(this);
    }

    @Override
    public void toModel(Resource subject, IRI predicate, Model model, Set<Resource> cycleDetection) {
        super.toModel(subject, predicate, model, cycleDetection);
        model.add(this.getId(), RDF.TYPE, SHACL.PROPERTY_SHAPE, new Resource[0]);
        if (subject != null) {
            if (predicate == null) {
                model.add(subject, SHACL.PROPERTY, this.getId(), new Resource[0]);
            } else {
                model.add(subject, predicate, this.getId(), new Resource[0]);
            }
        }
        model.add(this.getId(), SHACL.PATH, this.path.getId(), new Resource[0]);
        this.path.toModel(this.path.getId(), null, model, cycleDetection);
        if (cycleDetection.contains(this.getId())) {
            return;
        }
        cycleDetection.add(this.getId());
        this.constraintComponents.forEach(c -> c.toModel(this.getId(), null, model, cycleDetection));
    }

    @Override
    public void setTargetChain(TargetChain targetChain) {
        super.setTargetChain(targetChain.add(this.path));
    }

    @Override
    public ValidationQuery generateSparqlValidationQuery(ConnectionsGroup connectionsGroup, boolean logValidationPlans, boolean negatePlan, boolean negateChildren, ConstraintComponent.Scope scope) {
        if (this.deactivated) {
            return ValidationQuery.Deactivated.getInstance();
        }
        ValidationQuery validationQuery = this.constraintComponents.stream().map(c -> {
            ValidationQuery validationQuery1 = c.generateSparqlValidationQuery(connectionsGroup, logValidationPlans, negatePlan, negateChildren, ConstraintComponent.Scope.propertyShape);
            if (!(c instanceof PropertyShape)) {
                return validationQuery1.withConstraintComponent(c.getConstraintComponent());
            }
            return validationQuery1;
        }).reduce(ValidationQuery::union).orElseThrow(IllegalStateException::new);
        if (this.constraintComponents.size() == 1 && !(this.constraintComponents.get(0) instanceof PropertyShape)) {
            validationQuery.withShape(this);
            validationQuery.withSeverity(this.getSeverity());
            validationQuery.makeCurrentStateValidationReport();
        }
        if (scope == ConstraintComponent.Scope.propertyShape) {
            validationQuery.popTargetChain();
        } else {
            validationQuery.shiftToNodeShape();
        }
        return validationQuery;
    }

    @Override
    public PlanNode generateTransactionalValidationPlan(ConnectionsGroup connectionsGroup, boolean logValidationPlans, PlanNodeProvider overrideTargetNode, ConstraintComponent.Scope scope) {
        if (this.isDeactivated()) {
            return EmptyNode.getInstance();
        }
        PlanNode union = EmptyNode.getInstance();
        for (ConstraintComponent constraintComponent : this.constraintComponents) {
            if (!this.getPath().isSupported()) {
                logger.error("Unsupported path detected. Shape ignored! \n" + this.toString());
                continue;
            }
            PlanNode validationPlanNode = constraintComponent.generateTransactionalValidationPlan(connectionsGroup, logValidationPlans, overrideTargetNode, ConstraintComponent.Scope.propertyShape);
            if (!(constraintComponent instanceof PropertyShape)) {
                validationPlanNode = new ValidationReportNode(validationPlanNode, t -> new ValidationResult(t.getActiveTarget(), t.getValue(), this, constraintComponent.getConstraintComponent(), this.getSeverity(), t.getScope()));
            }
            validationPlanNode = scope == ConstraintComponent.Scope.propertyShape ? Unique.getInstance(new TargetChainPopper(validationPlanNode), true) : Unique.getInstance(new ShiftToNodeShape(validationPlanNode), true);
            union = UnionNode.getInstance(union, validationPlanNode);
        }
        return union;
    }

    @Override
    public PlanNode getAllTargetsPlan(ConnectionsGroup connectionsGroup, ConstraintComponent.Scope scope) {
        PlanNode planNode = this.constraintComponents.stream().map(c -> c.getAllTargetsPlan(connectionsGroup, ConstraintComponent.Scope.propertyShape)).distinct().reduce((xva$0, xva$1) -> UnionNode.getInstanceDedupe(xva$0, xva$1)).orElse(EmptyNode.getInstance());
        planNode = UnionNode.getInstanceDedupe(planNode, this.getTargetChain().getEffectiveTarget("_target", ConstraintComponent.Scope.propertyShape, connectionsGroup.getRdfsSubClassOfReasoner()).getPlanNode(connectionsGroup, ConstraintComponent.Scope.propertyShape, true, null));
        planNode = scope == ConstraintComponent.Scope.propertyShape ? Unique.getInstance(new TargetChainPopper(planNode), true) : new ShiftToNodeShape(planNode);
        planNode = Unique.getInstance(planNode, false);
        return planNode;
    }

    @Override
    public ValidationApproach getPreferredValidationApproach(ConnectionsGroup connectionsGroup) {
        return this.constraintComponents.stream().map(constraintComponent -> constraintComponent.getPreferredValidationApproach(connectionsGroup)).reduce(ValidationApproach::reducePreferred).orElse(ValidationApproach.MOST_COMPATIBLE);
    }

    public Path getPath() {
        return this.path;
    }

    @Override
    public ConstraintComponent deepClone() {
        PropertyShape nodeShape = new PropertyShape(this);
        nodeShape.constraintComponents = this.constraintComponents.stream().map(ConstraintComponent::deepClone).collect(Collectors.toList());
        return nodeShape;
    }

    @Override
    public SparqlFragment buildSparqlValidNodes_rsx_targetShape(StatementMatcher.Variable subject, StatementMatcher.Variable object, RdfsSubClassOfReasoner rdfsSubClassOfReasoner, ConstraintComponent.Scope scope, StatementMatcher.StableRandomVariableProvider stableRandomVariableProvider) {
        List<SparqlFragment> sparqlFragments = this.constraintComponents.stream().map(shape -> shape.buildSparqlValidNodes_rsx_targetShape(object, stableRandomVariableProvider.next(), rdfsSubClassOfReasoner, ConstraintComponent.Scope.propertyShape, stableRandomVariableProvider)).collect(Collectors.toList());
        if (SparqlFragment.isFilterCondition(sparqlFragments)) {
            return SparqlFragment.and(sparqlFragments);
        }
        return SparqlFragment.join(sparqlFragments);
    }
}

