/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.common.app;

import java.util.Locale;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AppVersion
implements Comparable<AppVersion> {
    private static final Pattern VERSION_REGEX = Pattern.compile("^\\s*(\\d+)(?:\\.(\\d+)(?:\\.(\\d+))?)?(M[^\\-\\+]*)?(?:-([^\\+]+))?(?:\\+(.+))?\\s*$");
    private int major;
    private int minor;
    private int patch;
    private int milestone;
    private String modifier;
    private String build;

    public AppVersion() {
        this(-1, -1, -1, -1, null);
    }

    public AppVersion(int major, int minor) {
        this(major, minor, -1, -1, null);
    }

    public AppVersion(int major, int minor, int patch) {
        this(major, minor, patch, -1, null);
    }

    public AppVersion(int major, int minor, String modifier) {
        this(major, minor, -1, -1, modifier);
    }

    public AppVersion(int major, int minor, int patch, String modifier) {
        this(major, minor, patch, -1, modifier);
    }

    public AppVersion(int major, int minor, int patch, int milestone, String modifier) {
        this(major, minor, patch, milestone, modifier, null);
    }

    public AppVersion(int major, int minor, int patch, int milestone, String modifier, String build) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.milestone = milestone;
        this.modifier = modifier;
        this.build = build;
    }

    public int getMajor() {
        return this.major;
    }

    public void setMajor(int major) {
        this.major = major;
    }

    public int getMinor() {
        return this.minor;
    }

    public void setMinor(int minor) {
        this.minor = minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public void setPatch(int micro) {
        this.patch = micro;
    }

    public void setMilestone(int milestone) {
        this.milestone = milestone;
    }

    public int getMilestone() {
        return this.milestone;
    }

    public String getModifier() {
        return this.modifier;
    }

    public void setModifier(String modifier) {
        this.modifier = modifier;
    }

    public boolean equals(Object other) {
        boolean isEqual = false;
        if (other instanceof AppVersion) {
            AppVersion o = (AppVersion)other;
            boolean bl = isEqual = this.major == o.major && this.minor == o.minor && this.patch == o.patch && this.milestone == o.milestone;
            if (isEqual) {
                isEqual = this.modifier == o.modifier || this.modifier != null && this.modifier.equalsIgnoreCase(o.modifier);
            }
        }
        return isEqual;
    }

    public int hashCode() {
        int hash = 31 * (31 * this.major + this.minor);
        if (this.patch > 0) {
            hash += this.patch;
        }
        if (this.milestone > 0) {
            hash += this.milestone;
        }
        if (this.modifier != null) {
            hash ^= this.modifier.toLowerCase(Locale.ENGLISH).hashCode();
        }
        return hash;
    }

    public boolean olderThan(AppVersion other) {
        return this.compareTo(other) < 0;
    }

    public boolean newerThan(AppVersion other) {
        return this.compareTo(other) > 0;
    }

    @Override
    public int compareTo(AppVersion other) {
        int result = this.major - other.major;
        if (result == 0) {
            result = this.minor - other.minor;
        }
        if (result == 0) {
            result = this.patch - other.patch;
        }
        if (result == 0 && (this.milestone > -1 || other.milestone > -1)) {
            if (this.milestone > -1) {
                result = other.milestone == -1 ? -1 : this.milestone - other.milestone;
            } else if (other.milestone > -1) {
                result = 1;
            }
        }
        if (result == 0 && !Objects.equals(this.modifier, other.modifier)) {
            result = this.modifier == null ? 1 : (other.modifier == null ? -1 : this.modifier.compareToIgnoreCase(other.modifier));
        }
        return result;
    }

    public static AppVersion parse(String versionString) {
        if (versionString.equals("dev")) {
            return new AppVersion(-1, -1, "dev");
        }
        Matcher m = VERSION_REGEX.matcher(versionString);
        if (!m.find()) {
            throw new NumberFormatException("Illegal version string: " + versionString);
        }
        int minorSeparator = m.start(2) - 1;
        int patchSeparator = m.start(3) - 1;
        int milestoneSeparator = m.start(4);
        int modifierSeparator = m.start(5) - 1;
        int buildSeparator = m.start(6) - 1;
        if (minorSeparator == -1) {
            throw new NumberFormatException("Illegal version string: " + versionString);
        }
        boolean hasPatch = patchSeparator > -1;
        boolean hasMilestone = milestoneSeparator > -1;
        boolean hasModifier = modifierSeparator > -1;
        boolean hasBuild = buildSeparator > -1;
        String major = versionString.substring(0, minorSeparator);
        String minor = null;
        String patch = null;
        String milestone = null;
        String modifier = null;
        String build = null;
        if (hasBuild) {
            build = versionString.substring(buildSeparator + 1);
        }
        if (hasModifier) {
            modifier = hasBuild ? versionString.substring(modifierSeparator + 1, buildSeparator) : versionString.substring(modifierSeparator + 1);
        }
        if (hasMilestone) {
            milestone = hasModifier ? versionString.substring(milestoneSeparator + 1, modifierSeparator) : (hasBuild ? versionString.substring(milestoneSeparator + 1, buildSeparator) : versionString.substring(milestoneSeparator + 1));
        }
        if (hasPatch) {
            patch = hasMilestone ? versionString.substring(patchSeparator + 1, milestoneSeparator) : (hasModifier ? versionString.substring(patchSeparator + 1, modifierSeparator) : (hasBuild ? versionString.substring(patchSeparator + 1, buildSeparator) : versionString.substring(patchSeparator + 1)));
            minor = versionString.substring(minorSeparator + 1, patchSeparator);
        } else {
            minor = hasMilestone ? versionString.substring(minorSeparator + 1, milestoneSeparator) : (hasModifier ? versionString.substring(minorSeparator + 1, modifierSeparator) : (hasBuild ? versionString.substring(minorSeparator + 1, buildSeparator) : versionString.substring(minorSeparator + 1)));
        }
        int majorInt = Integer.parseInt(major);
        int minorInt = Integer.parseInt(minor);
        int patchInt = patch == null ? -1 : Integer.parseInt(patch);
        int milestoneInt = milestone == null ? -1 : Integer.parseInt(milestone);
        return new AppVersion(majorInt, minorInt, patchInt, milestoneInt, modifier, build);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(16);
        if (this.major >= 0) {
            sb.append(this.major).append('.').append(this.minor);
        }
        if (this.patch >= 0) {
            sb.append('.').append(this.patch);
        }
        if (this.milestone >= 0) {
            sb.append('M').append(this.milestone);
        }
        if (this.modifier != null) {
            if (sb.length() > 0) {
                sb.append('-');
            }
            sb.append(this.modifier);
        }
        if (this.build != null) {
            if (sb.length() > 0) {
                sb.append('+');
            }
            sb.append(this.build);
        }
        return sb.toString();
    }
}

