/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.memory.model;

import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.sail.memory.model.MemResource;
import org.eclipse.rdf4j.sail.memory.model.MemStatement;
import org.eclipse.rdf4j.sail.memory.model.MemStatementList;

public class MemIRI
implements IRI,
MemResource {
    private static final long serialVersionUID = 9118488004995852467L;
    private final String namespace;
    private final String localName;
    private final transient Object creator;
    private int hashCode = 0;
    private final transient MemStatementList subjectStatements = new MemStatementList();
    private final transient MemStatementList predicateStatements = new MemStatementList();
    private final transient MemStatementList objectStatements = new MemStatementList();
    private final transient MemStatementList contextStatements = new MemStatementList();

    public MemIRI(Object creator, String namespace, String localName) {
        this.creator = creator;
        this.namespace = namespace;
        this.localName = localName;
    }

    public String toString() {
        return this.namespace + this.localName;
    }

    @Override
    public String stringValue() {
        return this.toString();
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public String getLocalName() {
        return this.localName;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof MemIRI) {
            MemIRI o = (MemIRI)other;
            return this.namespace.equals(o.getNamespace()) && this.localName.equals(o.getLocalName());
        }
        if (other instanceof IRI) {
            String otherStr = other.toString();
            return this.namespace.length() + this.localName.length() == otherStr.length() && otherStr.endsWith(this.localName) && otherStr.startsWith(this.namespace);
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.toString().hashCode();
        }
        return this.hashCode;
    }

    @Override
    public Object getCreator() {
        return this.creator;
    }

    @Override
    public boolean hasStatements() {
        return !this.subjectStatements.isEmpty() || !this.predicateStatements.isEmpty() || !this.objectStatements.isEmpty() || !this.contextStatements.isEmpty();
    }

    @Override
    public MemStatementList getSubjectStatementList() {
        return this.subjectStatements;
    }

    @Override
    public int getSubjectStatementCount() {
        return this.subjectStatements.size();
    }

    @Override
    public void addSubjectStatement(MemStatement st) {
        this.subjectStatements.add(st);
    }

    @Override
    public void removeSubjectStatement(MemStatement st) {
        this.subjectStatements.remove(st);
    }

    @Override
    public void cleanSnapshotsFromSubjectStatements(int currentSnapshot) {
        this.subjectStatements.cleanSnapshots(currentSnapshot);
    }

    public MemStatementList getPredicateStatementList() {
        return this.predicateStatements;
    }

    public int getPredicateStatementCount() {
        return this.predicateStatements.size();
    }

    public void addPredicateStatement(MemStatement st) {
        this.predicateStatements.add(st);
    }

    public void removePredicateStatement(MemStatement st) {
        this.predicateStatements.remove(st);
    }

    public void cleanSnapshotsFromPredicateStatements(int currentSnapshot) {
        this.predicateStatements.cleanSnapshots(currentSnapshot);
    }

    @Override
    public MemStatementList getObjectStatementList() {
        return this.objectStatements;
    }

    @Override
    public int getObjectStatementCount() {
        return this.objectStatements.size();
    }

    @Override
    public void addObjectStatement(MemStatement st) {
        this.objectStatements.add(st);
    }

    @Override
    public void removeObjectStatement(MemStatement st) {
        this.objectStatements.remove(st);
    }

    @Override
    public void cleanSnapshotsFromObjectStatements(int currentSnapshot) {
        this.objectStatements.cleanSnapshots(currentSnapshot);
    }

    @Override
    public MemStatementList getContextStatementList() {
        return this.contextStatements;
    }

    @Override
    public int getContextStatementCount() {
        return this.contextStatements.size();
    }

    @Override
    public void addContextStatement(MemStatement st) {
        this.contextStatements.add(st);
    }

    @Override
    public void removeContextStatement(MemStatement st) {
        this.contextStatements.remove(st);
    }

    @Override
    public void cleanSnapshotsFromContextStatements(int currentSnapshot) {
        this.contextStatements.cleanSnapshots(currentSnapshot);
    }
}

